/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilesTracker {
    public static final String PROP_PROFILES = "profiles";
    private static final Map<String, Map<StorageDescription, ProfilesTracker>> settingProfiles = new HashMap<String, Map<StorageDescription, ProfilesTracker>>();
    private static final Logger LOG = Logger.getLogger(ProfilesTracker.class.getName());
    private final SettingsType.Locator locator;
    private final MimeTypesTracker mimeTypes;
    private final FileSystem systemFileSystem;
    private final Listener listener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final String LOCK = new String("ProfilesTracker.LOCK");
    private Map<String, ProfileDescription> profiles = Collections.emptyMap();
    private Map<String, ProfileDescription> profilesByDisplayName = Collections.emptyMap();
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            ProfilesTracker.this.rebuild();
        }
    });
    private final Set<FileObject> trackedFolders = new HashSet<FileObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilesTracker get(String string, String string2) {
        assert (string != null) : "The parameter settingsTypeId must not be null";
        assert (string2 != null) : "The parameter basePath must not be null";
        StorageDescription storageDescription = SettingsType.find(string);
        assert (storageDescription != null) : "Invalid editor settings type id: '" + string + "'";
        Map<String, Map<StorageDescription, ProfilesTracker>> map = settingProfiles;
        synchronized (map) {
            ProfilesTracker profilesTracker;
            Map<StorageDescription, ProfilesTracker> map2 = settingProfiles.get(string2);
            if (map2 == null) {
                map2 = new WeakHashMap<StorageDescription, ProfilesTracker>();
                settingProfiles.put(string2, map2);
            }
            if ((profilesTracker = map2.get(storageDescription)) == null) {
                SettingsType.Locator locator = SettingsType.getLocator(storageDescription);
                assert (locator.isUsingProfiles()) : "No need to track profiles for settings that do not use profiles.";
                profilesTracker = new ProfilesTracker(locator, MimeTypesTracker.get(null, string2));
                map2.put(storageDescription, profilesTracker);
            }
            return profilesTracker;
        }
    }

    ProfilesTracker(SettingsType.Locator locator, MimeTypesTracker mimeTypesTracker) {
        this.locator = locator;
        this.mimeTypes = mimeTypesTracker;
        this.rebuild();
        this.listener = new Listener();
        FileSystem fileSystem = null;
        try {
            fileSystem = FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        this.systemFileSystem = fileSystem;
        this.systemFileSystem.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listener, (Object)this.systemFileSystem));
        this.mimeTypes.addPropertyChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProfilesDisplayNames() {
        String string = this.LOCK;
        synchronized (string) {
            return this.profilesByDisplayName.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileDescription getProfileByDisplayName(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            return this.profilesByDisplayName.get(string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            Object object;
            Object object2;
            Object object3;
            HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
            FileObject fileObject = FileUtil.getConfigFile((String)this.mimeTypes.getBasePath());
            if (fileObject != null && fileObject.isFolder()) {
                this.locator.scan(fileObject, null, null, false, true, true, false, hashMap);
                object3 = this.mimeTypes.getMimeTypes();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.locator.scan(fileObject, (String)object, null, false, true, true, false, hashMap);
                }
            }
            object3 = new HashMap();
            object2 = new HashMap();
            for (String string2 : hashMap.keySet()) {
                Object object4;
                List list = (List)hashMap.get(string2);
                String string3 = null;
                boolean bl = false;
                String string4 = null;
                Object object5 = list.iterator();
                while (object5.hasNext()) {
                    object4 = (Object[])object5.next();
                    FileObject fileObject2 = (FileObject)object4[0];
                    FileObject fileObject3 = (FileObject)object4[1];
                    boolean bl2 = (Boolean)object4[2];
                    if (fileObject2 != null) {
                        this.trackedFolders.add(fileObject2.getParent());
                        string4 = fileObject2.getPath();
                        if (string3 == null && (string3 = Utils.getLocalizedName(fileObject2, null)) == null) {
                            string3 = Utils.getLocalizedName(fileObject2, string2, null);
                        }
                    } else {
                        string4 = fileObject3.getPath();
                    }
                    if (!bl) {
                        bl = bl2;
                    }
                    if (string3 == null || !bl) continue;
                    break;
                }
                if ((object5 = (ProfileDescription)((HashMap)object2).get(string3 = string3 == null ? string2 : string3)) != null) {
                    object4 = fileObject.getPath() + "/" + this.locator.getWritableFileName(null, string2, null, false);
                    if (((String)object4).startsWith(string4)) {
                        ((HashMap)object3).remove(((ProfileDescription)object5).getId());
                        ((HashMap)object2).remove(string3);
                        LOG.warning("Ignoring profile '" + ((ProfileDescription)object5).getId() + "' (" + ((ProfileDescription)object5).profileOrigin + ") in favor of '" + string2 + "' (" + string4 + ") with the same display name.");
                    } else {
                        LOG.warning("Ignoring profile '" + string2 + "' (" + string4 + "), it's got the same display name as '" + ((ProfileDescription)object5).getId() + "' (" + ((ProfileDescription)object5).profileOrigin + ").");
                        continue;
                    }
                }
                object4 = this.reuseOrCreate(string2, string3, bl, string4);
                ((HashMap)object3).put(string2, object4);
                ((HashMap)object2).put(string3, object4);
            }
            assert (((HashMap)object2).size() == ((HashMap)object3).size()) : "Inconsistent profile maps";
            if (!((Object)this.profiles).equals(object3)) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_PROFILES, this.profiles, object3);
                this.profiles = object3;
                this.profilesByDisplayName = object2;
            }
            object = this.trackedFolders.iterator();
            while (object.hasNext()) {
                if (((FileObject)object.next()).isValid()) continue;
                object.remove();
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    private ProfileDescription reuseOrCreate(String string, String string2, boolean bl, String string3) {
        ProfileDescription profileDescription = this.profiles.get(string);
        if (profileDescription != null && profileDescription.getDisplayName().equals(string2) && profileDescription.isRollbackAllowed() == bl) {
            return profileDescription;
        }
        return new ProfileDescription(string, string2, bl, string3);
    }

    private final class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProfilesTracker.this.rebuild();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.notifyRebuild(fileRenameEvent.getFile());
        }

        private void notifyRebuild(FileObject fileObject) {
            String string = fileObject.getPath();
            if (string.startsWith(ProfilesTracker.this.mimeTypes.getBasePath())) {
                ProfilesTracker.this.task.schedule(100);
            }
        }
    }

    public static final class ProfileDescription {
        private final String id;
        private final String displayName;
        private final boolean isRollbackAllowed;
        private final String profileOrigin;

        private ProfileDescription(String string, String string2, boolean bl, String string3) {
            this.id = string;
            this.displayName = string2;
            this.isRollbackAllowed = bl;
            this.profileOrigin = string3;
        }

        public boolean isRollbackAllowed() {
            return this.isRollbackAllowed;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }
    }
}

