/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.SaveAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class SaveAsAction
extends AbstractAction
implements ContextAwareAction {
    private Lookup context;
    private Lookup.Result<SaveAsCapable> lkpInfo;
    private boolean isGlobal = false;
    private boolean isDirty = true;
    private PropertyChangeListener registryListener;
    private LookupListener lookupListener;

    private SaveAsAction() {
        this(Utilities.actionsGlobalContext(), true);
    }

    private SaveAsAction(Lookup lookup, boolean bl) {
        super(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsAction"));
        this.context = lookup;
        this.isGlobal = bl;
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.setEnabled(false);
    }

    public static ContextAwareAction create() {
        return new SaveAsAction();
    }

    public boolean isEnabled() {
        if (this.isDirty || null == this.changeSupport || !this.changeSupport.hasListeners("enabled")) {
            this.refreshEnabled();
        }
        return super.isEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.refreshListeners();
        Collection collection = this.lkpInfo.allInstances();
        if (collection.size() > 0) {
            SaveAsCapable saveAsCapable = (SaveAsCapable)collection.iterator().next();
            File file = this.getNewFileName();
            if (null != file) {
                FileObject fileObject = null;
                try {
                    File file2 = file.getParentFile();
                    if (null == file2) {
                        throw new IOException(file.getAbsolutePath());
                    }
                    fileObject = FileUtil.createFolder((File)file2);
                }
                catch (IOException iOException) {
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_CannotCreateTargetFolder"), NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                    DialogDisplayer.getDefault().notify(notifyDescriptor);
                    return;
                }
                try {
                    saveAsCapable.saveAs(fileObject, file.getName());
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAsFailed", (Object)file.getName(), (Object)iOException.getLocalizedMessage()));
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private File getNewFileName() {
        File file;
        File file2;
        File file3 = null;
        File file4 = null;
        FileObject fileObject = this.getCurrentFileObject();
        if (null != fileObject) {
            file4 = file3 = FileUtil.toFile((FileObject)fileObject);
            if (null == file3) {
                file3 = new File(fileObject.getNameExt());
            }
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(DataObject.class, (String)"LBL_SaveAsTitle"));
        jFileChooser.setMultiSelectionEnabled(false);
        if (null != file3) {
            jFileChooser.setSelectedFile(file3);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)file3.getParentFile());
        }
        if (null != (file2 = this.getInitialFolderFrom(file3))) {
            jFileChooser.setCurrentDirectory(file2);
        }
        File file5 = file3;
        while (true) {
            if (0 != jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow())) {
                return null;
            }
            file3 = jFileChooser.getSelectedFile();
            if (null == file3 || !file3.equals(file5)) break;
            file = new NotifyDescriptor((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAs_SameFileSelected"), NbBundle.getMessage(DataObject.class, (String)"MSG_SaveAs_SameFileSelected_Title"), -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
        }
        if (this.isFromUserDir(file4)) {
            file = jFileChooser.getCurrentDirectory();
            NbPreferences.forModule(SaveAction.class).put("lastUsedDir", file.getAbsolutePath());
        }
        return file3;
    }

    private FileObject getCurrentFileObject() {
        DataObject dataObject;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != topComponent && null != (dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class))) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private File getInitialFolderFrom(File file) {
        File file2 = new File(System.getProperty("user.home"));
        if (null != file) {
            File file3 = file.getParentFile();
            if (this.isFromUserDir(file3)) {
                String string = NbPreferences.forModule(SaveAction.class).get("lastUsedDir", file2.getAbsolutePath());
                file2 = new File(string);
                if (!file2.exists() || !file2.isDirectory()) {
                    file2 = new File(System.getProperty("user.home"));
                }
            } else {
                file2 = file3;
            }
        }
        return file2;
    }

    private boolean isFromUserDir(File file) {
        if (null == file) {
            return false;
        }
        File file2 = new File(System.getProperty("netbeans.user"));
        return file.getAbsolutePath().startsWith(file2.getAbsolutePath());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SaveAsAction(lookup, false);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.refreshListeners();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.refreshListeners();
    }

    private PropertyChangeListener createRegistryListener() {
        return WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SaveAsAction.this.isDirty = true;
            }
        }, (Object)TopComponent.getRegistry());
    }

    private LookupListener createLookupListener() {
        return (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                SaveAsAction.this.isDirty = true;
            }
        }, this.lkpInfo);
    }

    private void refreshEnabled() {
        TopComponent topComponent;
        if (this.lkpInfo == null) {
            topComponent = new Lookup.Template(SaveAsCapable.class);
            this.lkpInfo = this.context.lookup((Lookup.Template)topComponent);
        }
        boolean bl = null != (topComponent = TopComponent.getRegistry().getActivated()) && WindowManager.getDefault().isEditorTopComponent(topComponent);
        this.setEnabled(null != this.lkpInfo && this.lkpInfo.allItems().size() != 0 && bl);
        this.isDirty = false;
    }

    private void refreshListeners() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo == null) {
            Lookup.Template template = new Lookup.Template(SaveAsCapable.class);
            this.lkpInfo = this.context.lookup(template);
        }
        if (null == this.changeSupport || !this.changeSupport.hasListeners("enabled")) {
            if (this.isGlobal && null != this.registryListener) {
                TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
                this.registryListener = null;
            }
            if (null != this.lookupListener) {
                this.lkpInfo.removeLookupListener(this.lookupListener);
                this.lookupListener = null;
            }
        } else {
            if (null == this.registryListener) {
                this.registryListener = this.createRegistryListener();
                TopComponent.getRegistry().addPropertyChangeListener(this.registryListener);
            }
            if (null == this.lookupListener) {
                this.lookupListener = this.createLookupListener();
                this.lkpInfo.addLookupListener(this.lookupListener);
            }
            this.refreshEnabled();
        }
    }

    boolean _isEnabled() {
        return super.isEnabled();
    }
}

