/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.codeviation.pojson.PojsonLoad;
import org.codeviation.pojson.PojsonSave;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Persistence {
    private static final Persistence instance = new Persistence();

    static Persistence getInstance() {
        return instance;
    }

    private Persistence() {
    }

    public synchronized boolean storeProjects(Collection<KenaiProject> collection) {
        File file = this.getMasterStorage();
        int n = 0;
        for (KenaiProject kenaiProject : collection) {
            String string = this.computeProjectFileName(kenaiProject.getName()) + "-" + n + ".kp";
            File file2 = new File(file, string);
            try {
                this.storeProject(file2, kenaiProject);
            }
            catch (IOException iOException) {
                Utils.logWarn(this, iOException);
                file2.delete();
            }
        }
        return true;
    }

    public synchronized Collection<KenaiProject> loadProjects() {
        ArrayList<KenaiProject> arrayList = new ArrayList<KenaiProject>();
        File file = this.getMasterStorage();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            PojsonLoad pojsonLoad = new PojsonLoad();
            for (File file2 : fileArray) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    ProjectData projectData = pojsonLoad.load(fileInputStream, ProjectData.class);
                    fileInputStream.close();
                    arrayList.add(KenaiProject.get(projectData));
                }
                catch (IOException iOException) {
                    Utils.logWarn(this, iOException);
                    file2.delete();
                }
            }
        }
        return arrayList;
    }

    private void storeProject(File file, KenaiProject kenaiProject) throws IOException {
        ProjectData projectData = kenaiProject.getData();
        PojsonSave<ProjectData> pojsonSave = new PojsonSave<ProjectData>();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        pojsonSave.save((Writer)outputStreamWriter, projectData);
        outputStreamWriter.close();
    }

    private String computeProjectFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    private File getMasterStorage() {
        File file;
        String string = System.getProperty("user.home");
        if (string == null) {
            string = System.getProperty("netbeans.user");
            file = new File(string);
        } else {
            file = new File(new File(string), "NetBeansKenai");
        }
        File file2 = new File(new File(file, "config"), "Kenai");
        file2.mkdirs();
        return file2;
    }
}

