/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.PojsonLoad;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiException
extends IOException {
    private String errorResponse = "";
    private String status;
    private HashMap<String, String> errors;

    public KenaiException(String string) {
        super(string);
    }

    public KenaiException(Throwable throwable) {
        this.initCause(throwable);
    }

    public KenaiException(String string, Throwable throwable, String string2) {
        super(string);
        this.initCause(throwable);
        this.errorResponse = string2;
    }

    public KenaiException(String string, String string2) {
        this(string);
        this.errorResponse = string2;
    }

    public <T> T getKenaiError(Class<T> clazz) {
        PojsonLoad pojsonLoad = PojsonLoad.create();
        return pojsonLoad.load(this.errorResponse == null ? "" : this.errorResponse, clazz);
    }

    private void fillErrorData() {
        PojsonLoad pojsonLoad = PojsonLoad.create();
        try {
            if (this.errorResponse == null) {
                this.status = "unknown";
                this.errors = new HashMap();
            } else {
                HashMap hashMap = (HashMap)pojsonLoad.toCollections(this.errorResponse);
                if (hashMap == null) {
                    this.status = "unknown";
                    this.errors = new HashMap();
                    this.errors.put("generic", this.errorResponse);
                } else {
                    this.status = (String)hashMap.get("status");
                    this.errors = (HashMap)hashMap.get("errors");
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(KenaiException.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.status = "unknown";
            this.errors = new HashMap();
            this.errors.put("generic", this.errorResponse);
        }
    }

    public String getAsString() {
        return this.errorResponse;
    }

    public String getStatus() {
        if (this.errorResponse == null) {
            return null;
        }
        if (this.status == null) {
            this.fillErrorData();
        }
        return this.status;
    }

    public Map<String, String> getErrors() {
        if (this.errorResponse == null) {
            return Collections.emptyMap();
        }
        if (this.errors == null) {
            this.fillErrorData();
        }
        return this.errors;
    }

    @Override
    public String toString() {
        return this.errorResponse == null ? super.toString() : super.toString() + ". Server response=" + this.errorResponse;
    }
}

