/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamUtil {
    private static final int BUFFER_SIZE = 2048;

    private StreamUtil() {
    }

    public static String asString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[2048];
        int n = -1;
        do {
            if ((n = bufferedReader.read(cArray)) == -1) continue;
            stringBuilder.append(cArray, 0, n);
        } while (n != -1);
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static Iterator<String> asLines(InputStream inputStream) throws IOException {
        return new LineIterator(inputStream);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[2048];
        int n = -1;
        do {
            if ((n = bufferedInputStream.read(byArray)) == -1) continue;
            bufferedOutputStream.write(byArray, 0, n);
        } while (n != -1);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static OutputStream nullOutputStream() {
        return new NullOutputStream();
    }

    public static Writer nullWriter() {
        return new OutputStreamWriter(new NullOutputStream());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineIterator
    implements Iterator<String> {
        private String line;
        private InputStream is;
        private BufferedReader br;

        public LineIterator(InputStream inputStream) throws IOException {
            this.is = inputStream;
            this.br = new BufferedReader(new InputStreamReader(inputStream));
            this.line = this.getNextLine();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            if (this.line == null) {
                throw new NoSuchElementException();
            }
            String string = this.line;
            try {
                this.line = this.getNextLine();
                if (this.line == null) {
                    this.is.close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        private String getNextLine() throws IOException {
            return this.br.readLine();
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }
}

