/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.File;
import java.io.FileFilter;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.patterns.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFilters {
    public static final Filter<File> EXISTS = new UniversalFF(0);
    public static final Filter<File> CAN_READ = new UniversalFF(1);
    public static final Filter<File> CAN_WRITE = new UniversalFF(2);
    public static final Filter<File> IS_FILE = new UniversalFF(4);
    public static final Filter<File> IS_DIRECTORY = new UniversalFF(5);
    public static final Filter<File> IS_HIDDEN = new UniversalFF(6);

    private FileFilters() {
    }

    public static Filter<File> name(String string) {
        return new UniversalFF(string);
    }

    public static Filter<File> extension(String string) {
        UniversalFF universalFF = new UniversalFF(-1);
        universalFF.extension = string;
        return universalFF;
    }

    public static FileFilter asFileFilter(Filter<File> filter) {
        if (filter instanceof FileFilter) {
            return (FileFilter)((Object)filter);
        }
        return new UniversalFF(filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UniversalFF
    implements Filter<File>,
    FileFilter {
        public static final int EXISTS = 0;
        public static final int CAN_READ = 1;
        public static final int CAN_WRITE = 2;
        public static final int CAN_EXECUTE = 3;
        public static final int IS_FILE = 4;
        public static final int IS_DIRECTORY = 5;
        public static final int IS_HIDDEN = 6;
        private int kind = -1;
        private Filter<String> rf;
        private Filter<File> df;
        private String extension;

        public UniversalFF(int n) {
            this.kind = n;
        }

        public UniversalFF(String string) {
            this.rf = Filters.Regexp(string);
        }

        public UniversalFF(Filter<File> filter) {
            this.df = filter;
        }

        @Override
        public boolean accept(File file) {
            if (this.df != null) {
                return this.df.accept(file);
            }
            if (this.rf != null) {
                return this.rf.accept(file.getName());
            }
            if (this.extension != null) {
                return file.getName().endsWith(this.extension);
            }
            switch (this.kind) {
                case 0: {
                    return file.exists();
                }
                case 1: {
                    return file.canRead();
                }
                case 2: {
                    return file.canWrite();
                }
                case 4: {
                    return file.isFile();
                }
                case 5: {
                    return file.isDirectory();
                }
                case 6: {
                    return file.isHidden();
                }
            }
            throw new IllegalStateException("Should never happen");
        }
    }
}

