/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.codeviation.commons.patterns.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    private static Filter<?> ALLWAYS_TRUE = new LogicalFilter(4);
    private static Filter<?> ALLWAYS_FALSE = new LogicalFilter(5);

    private Filters() {
    }

    public static <T> Filter<T> And(Filter<T> ... filterArray) {
        if (filterArray.length < 2) {
            throw new IllegalArgumentException("At least two filters needed!");
        }
        return new LogicalFilter(0, filterArray);
    }

    public static <T> Filter<T> Or(Filter<T> ... filterArray) {
        if (filterArray.length < 2) {
            throw new IllegalArgumentException("At least two filters needed!");
        }
        return new LogicalFilter(1, filterArray);
    }

    public static <T> Filter<T> Not(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null!");
        }
        return new LogicalFilter(2, filter);
    }

    public static <T> Filter<T> True() {
        return ALLWAYS_TRUE;
    }

    public static <T> Filter<T> False() {
        return ALLWAYS_FALSE;
    }

    public static <T> Filter<T> NotNull() {
        return new NotNullFilter();
    }

    public static <T> Filter<T> IsIn(Collection<? extends T> collection) {
        return new IsIn(collection);
    }

    public static <T> Filter<T> IsIn(T ... TArray) {
        return new IsIn(Arrays.asList(TArray));
    }

    public static Filter<String> Regexp(String string) {
        return new Regexp(string);
    }

    public static Filter<Object> InstanceOf(Class clazz) {
        return new InstanceOf(clazz);
    }

    public static <T> Filter<T> IncludeExclude(Filter<T> filter, Filter<T> filter2) {
        return new LogicalFilter(3, new Filter[]{filter, filter2});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceOf
    implements Filter<Object> {
        private Class clazz;

        public InstanceOf(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean accept(Object object) {
            return this.clazz.isInstance(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsIn<T>
    implements Filter<T> {
        private Collection container;

        public IsIn(Collection collection) {
            this.container = collection;
        }

        @Override
        public boolean accept(T t) {
            return this.container.contains(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogicalFilter<T>
    implements Filter<T> {
        private static final int AND = 0;
        private static final int OR = 1;
        private static final int NOT = 2;
        private static final int INCLUDE_EXCLUDE = 3;
        private static final int TRUE = 4;
        private static final int FALSE = 5;
        private int op;
        private Filter<T>[] filters;
        private Filter<T> filter;

        private LogicalFilter(int n) {
            this.op = n;
        }

        private LogicalFilter(int n, Filter<T> filter) {
            this.op = n;
            this.filter = filter;
        }

        private LogicalFilter(int n, Filter<T>[] filterArray) {
            this.op = n;
            this.filters = filterArray;
        }

        @Override
        public boolean accept(T t) {
            switch (this.op) {
                case 0: {
                    for (Filter<T> filter : this.filters) {
                        if (filter == null || filter.accept(t)) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    for (Filter<T> filter : this.filters) {
                        if (filter == null || !filter.accept(t)) continue;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return !this.filter.accept(t);
                }
                case 3: {
                    return this.filters[0].accept(t) && !this.filters[1].accept(t);
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
            }
            throw new IllegalStateException("Unknown filter operation!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotNullFilter<T>
    implements Filter<T> {
        private NotNullFilter() {
        }

        @Override
        public boolean accept(T t) {
            return t != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Regexp
    implements Filter<String> {
        private Pattern pattern;

        public Regexp(String string) {
            this.pattern = Pattern.compile(string);
        }

        @Override
        public boolean accept(String string) {
            return this.pattern.matcher(string).matches();
        }
    }
}

