/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;
import org.openide.util.io.NbMarshalledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Repository.class.getName());
    private static Repository repository;
    private static final AtomicReference<Object> ADD_FS;
    static final long serialVersionUID = -6344768369160069704L;
    private ArrayList<FileSystem> fileSystems;
    private transient ArrayList<FileSystem> fileSystemsClone;
    private FileSystem system;
    private Hashtable<String, FileSystem> names;
    private transient FCLSupport fclSupport;
    private Hashtable<RepositoryListener, RepositoryListener> listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (Repository.this.names.get(string2) != null) {
                    throw new PropertyVetoException("system name already exists: " + string + " -> " + string2, propertyChangeEvent);
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                if (fileSystem.isValid()) {
                    Repository.this.names.remove(string);
                }
                Repository.this.names.put(string2, fileSystem);
                fileSystem.setValid(true);
            }
        }
    };

    static void reset() {
        repository = null;
    }

    private static final synchronized boolean addFileSystemDelayed(FileSystem fileSystem) {
        return !ADD_FS.compareAndSet(ADD_FS, fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Lookup lookup = Lookup.getDefault();
        Object object = Repository.class;
        synchronized (Repository.class) {
            Repository repository = Repository.repository;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (repository == null) {
                object = (Repository)lookup.lookup(Repository.class);
                Repository repository2 = Repository.assignRepository((Repository)object);
                FileSystem fileSystem = ADD_FS.getAndSet(null);
                if (fileSystem != null) {
                    Repository.addFS(repository2, fileSystem);
                }
            }
            return;
        }
    }

    private static void addFS(Repository repository, FileSystem fileSystem) {
        repository.addFileSystem(fileSystem);
    }

    private static synchronized Repository assignRepository(Repository repository) {
        Repository.repository = repository;
        if (Repository.repository == null) {
            Repository.repository = new Repository(new MainFS());
        }
        return Repository.repository;
    }

    public Repository(FileSystem fileSystem) {
        this.system = fileSystem;
        this.init();
    }

    public static Repository getDefault() {
        Repository.initialize();
        return repository;
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        if (Repository.addFileSystemDelayed(this.system)) {
            this.addFileSystem(this.system);
        }
    }

    @Deprecated
    public final FileSystem getDefaultFileSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void addFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (!fileSystem.assigned && !this.fileSystems.contains(fileSystem)) {
                boolean bl2;
                fileSystem.setRepository(this);
                this.fileSystems.add(fileSystem);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                String string = fileSystem.getSystemName();
                boolean bl3 = bl2 = this.names.get(string) == null;
                if (bl2 && !string.equals("")) {
                    this.names.put(string, fileSystem);
                    fileSystem.setValid(true);
                } else {
                    fileSystem.setValid(false);
                }
                fileSystem.assigned = true;
                fileSystem.addPropertyChangeListener(this.propListener);
                fileSystem.addVetoableChangeListener(this.vetoListener);
                fileSystem.addNotify();
                bl = true;
            }
        }
        if (bl) {
            this.fireFileSystem(fileSystem, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void removeFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (fileSystem.isDefault()) {
                return;
            }
            bl = this.fileSystems.remove(fileSystem);
            if (bl) {
                fileSystem.setRepository(null);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                if (fileSystem.isValid()) {
                    this.names.remove(fileSystem.getSystemName());
                    fileSystem.setValid(false);
                }
                fileSystem.removePropertyChangeListener(this.propListener);
                fileSystem.removeVetoableChangeListener(this.vetoListener);
                fileSystem.removeNotify();
            }
            fileSystem.assigned = false;
        }
        if (bl) {
            this.fireFileSystem(fileSystem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void reorder(int[] nArray) {
        Repository repository = this;
        synchronized (repository) {
            if (nArray == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (nArray.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + nArray.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(nArray)) {
                StringBuffer stringBuffer = new StringBuffer("permutation is not really a permutation:");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[i]);
                }
                throw new IllegalArgumentException(stringBuffer.toString());
            }
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(this.fileSystems.size());
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.fileSystems.get(nArray[i]));
            }
            this.fileSystems = arrayList;
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
        }
        this.fireFileSystemReordered(nArray);
    }

    private static boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        try {
            for (int i = 0; i < n; ++i) {
                if (blArray[nArray[i]]) {
                    return false;
                }
                blArray[nArray[i]] = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> getFileSystems() {
        ArrayList<FileSystem> arrayList = this.fileSystemsClone;
        return Collections.enumeration(arrayList);
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> fileSystems() {
        return this.getFileSystems();
    }

    @Deprecated
    public final FileSystem[] toArray() {
        ArrayList<FileSystem> arrayList = this.fileSystemsClone;
        FileSystem[] fileSystemArray = new FileSystem[arrayList.size()];
        arrayList.toArray(fileSystemArray);
        return fileSystemArray;
    }

    @Deprecated
    public final FileSystem findFileSystem(String string) {
        FileSystem fileSystem = this.names.get(string);
        return fileSystem;
    }

    @Deprecated
    public final synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (FileSystem fileSystem : this.fileSystems) {
            if (fileSystem.isDefault() || fileSystem.isPersistent()) continue;
            objectOutput.writeObject(new NbMarshalledObject((Object)fileSystem));
        }
        objectOutput.writeObject(null);
    }

    @Deprecated
    public final synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        FileSystem fileSystem;
        Enumeration<? extends FileSystem> enumeration;
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(10);
        while ((enumeration = objectInput.readObject()) != null) {
            if (enumeration instanceof FileSystem) {
                fileSystem = (FileSystem)((Object)enumeration);
            } else {
                try {
                    object = (NbMarshalledObject)enumeration;
                    fileSystem = (FileSystem)object.get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    fileSystem = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    fileSystem = null;
                }
            }
            if (fileSystem == null) continue;
            arrayList.add(fileSystem);
        }
        enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            fileSystem = enumeration.nextElement();
            if (fileSystem.isPersistent()) continue;
            this.removeFileSystem(fileSystem);
        }
        this.system.assigned = false;
        this.init();
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.addFileSystem((FileSystem)object.next());
        }
    }

    @Deprecated
    public final FileObject find(String string, String string2, String string3) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final FileObject findResource(String string) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAllResources(String string) {
        assert (false) : "Deprecated.";
        Vector<FileObject> vector = new Vector<FileObject>(8);
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAll(String string, String string2, String string3) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        Vector<FileObject> vector = new Vector<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    private void fireFileSystem(FileSystem fileSystem, boolean bl) {
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, fileSystem, bl);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            if (bl) {
                repositoryListener.fileSystemAdded(repositoryEvent);
                continue;
            }
            repositoryListener.fileSystemRemoved(repositoryEvent);
        }
    }

    private void fireFileSystemReordered(int[] nArray) {
        RepositoryReorderedEvent repositoryReorderedEvent = new RepositoryReorderedEvent(this, nArray);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
        }
    }

    @Deprecated
    public final void addRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.put(repositoryListener, repositoryListener);
    }

    @Deprecated
    public final void removeRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.remove(repositoryListener);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    @Deprecated
    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().addFileChangeListener(fileChangeListener);
    }

    @Deprecated
    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().removeFileChangeListener(fileChangeListener);
    }

    static {
        ADD_FS = new AtomicReference();
        ADD_FS.set(ADD_FS);
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();
        private static final XMLFileSystem layers = new XMLFileSystem();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            ArrayList<URL> arrayList = new ArrayList<URL>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream inputStream = uRL.openStream();
                    try {
                        Manifest manifest = new Manifest(inputStream);
                        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (string == null) continue;
                        URL uRL2 = classLoader.getResource(string);
                        if (uRL2 != null) {
                            arrayList.add(uRL2);
                            continue;
                        }
                        LOG.warning("No such layer: " + string);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/generated-layer.xml"))) {
                    arrayList.add(uRL);
                }
                layers.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                LOG.log(Level.FINE, "Loading classpath layers: {0}", arrayList);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Setting layer URLs: " + arrayList, exception);
            }
            this.resultChanged(null);
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
            arrayList.add(MEMORY);
            for (FileSystem fileSystem : ALL.allInstances()) {
                if (Boolean.TRUE.equals(fileSystem.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem);
            }
            arrayList.add(layers);
            for (FileSystem fileSystem : ALL.allInstances()) {
                if (!Boolean.TRUE.equals(fileSystem.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem);
            }
            return arrayList.toArray(new FileSystem[0]);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.setDelegates(MainFS.computeDelegates());
        }
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        Replacer() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Repository.getDefault().writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Repository.getDefault().readExternal(objectInputStream);
        }

        public Object readResolve() {
            return Repository.getDefault();
        }
    }
}

