/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public class FileChooserBuilder {
    private boolean dirsOnly;
    private BadgeProvider badger;
    private String title;
    private String approveText;
    private static boolean PREVENT_SYMLINK_TRAVERSAL = !Boolean.getBoolean("allow.filechooser.symlink.traversal");
    private final String dirKey;
    private File failoverDir;
    private FileFilter filter;
    private boolean fileHiding;
    private boolean controlButtonsShown = true;
    private String aDescription;
    private boolean filesOnly;
    private static final boolean DONT_STORE_DIRECTORIES = Boolean.getBoolean("forget.recent.dirs");
    private SelectionApprover approver;
    private final List<FileFilter> filters = new ArrayList<FileFilter>(3);
    private boolean force = false;

    public FileChooserBuilder(Class clazz) {
        this(clazz.getName());
    }

    public FileChooserBuilder(String string) {
        Parameters.notNull((CharSequence)"dirKey", (Object)string);
        this.dirKey = string;
    }

    public FileChooserBuilder setDirectoriesOnly(boolean bl) {
        this.dirsOnly = bl;
        assert (!this.filesOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setFilesOnly(boolean bl) {
        this.filesOnly = bl;
        assert (!this.dirsOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setBadgeProvider(BadgeProvider badgeProvider) {
        this.badger = badgeProvider;
        return this;
    }

    public FileChooserBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public FileChooserBuilder setApproveText(String string) {
        this.approveText = string;
        return this;
    }

    public FileChooserBuilder setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
        return this;
    }

    public FileChooserBuilder setDefaultWorkingDirectory(File file) {
        this.failoverDir = file;
        return this;
    }

    public FileChooserBuilder setFileHiding(boolean bl) {
        this.fileHiding = bl;
        return this;
    }

    public FileChooserBuilder setControlButtonsAreShown(boolean bl) {
        this.controlButtonsShown = bl;
        return this;
    }

    public FileChooserBuilder setAccessibleDescription(String string) {
        this.aDescription = string;
        return this;
    }

    public JFileChooser createFileChooser() {
        SavedDirFileChooser savedDirFileChooser = new SavedDirFileChooser(this.dirKey, this.failoverDir, this.force, this.approver);
        this.prepareFileChooser(savedDirFileChooser);
        return savedDirFileChooser;
    }

    public FileChooserBuilder forceUseOfDefaultWorkingDirectory(boolean bl) {
        this.force = bl;
        return this;
    }

    private Component findDialogParent() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (component == null) {
            Frame[] frameArray = Frame.getFrames();
            component = frameArray.length == 0 ? null : frameArray[frameArray.length - 1];
        }
        return component;
    }

    public File[] showMultiOpenDialog() {
        JFileChooser jFileChooser = this.createFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this.findDialogParent());
        if (0 == n) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            return fileArray == null ? new File[]{} : fileArray;
        }
        return null;
    }

    public File showOpenDialog() {
        JFileChooser jFileChooser = this.createFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this.findDialogParent());
        if (0 == n) {
            File file = jFileChooser.getSelectedFile();
            if (file != null && !file.exists()) {
                file = null;
            }
            return file;
        }
        return null;
    }

    public File showSaveDialog() {
        JFileChooser jFileChooser = this.createFileChooser();
        int n = jFileChooser.showSaveDialog(this.findDialogParent());
        if (0 == n) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private void prepareFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setFileSelectionMode(this.dirsOnly ? 1 : (this.filesOnly ? 0 : 2));
        jFileChooser.setFileHidingEnabled(this.fileHiding);
        jFileChooser.setControlButtonsAreShown(this.controlButtonsShown);
        if (this.title != null) {
            jFileChooser.setDialogTitle(this.title);
        }
        if (this.approveText != null) {
            jFileChooser.setApproveButtonText(this.approveText);
        }
        if (this.badger != null) {
            jFileChooser.setFileView(new CustomFileView(new BadgeIconProvider(this.badger), jFileChooser.getFileSystemView()));
        }
        if (PREVENT_SYMLINK_TRAVERSAL) {
            FileUtil.preventFileChooserSymlinkTraversal(jFileChooser, jFileChooser.getCurrentDirectory());
        }
        if (this.filter != null) {
            jFileChooser.setFileFilter(this.filter);
        }
        if (this.aDescription != null) {
            jFileChooser.getAccessibleContext().setAccessibleDescription(this.aDescription);
        }
        if (!this.filters.isEmpty()) {
            for (FileFilter fileFilter : this.filters) {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
        }
    }

    public FileChooserBuilder addFileFilter(FileFilter fileFilter) {
        this.filters.add(fileFilter);
        return this;
    }

    public FileChooserBuilder setSelectionApprover(SelectionApprover selectionApprover) {
        this.approver = selectionApprover;
        return this;
    }

    private static final class BadgeIconProvider
    implements IconProvider {
        private final BadgeProvider badger;

        public BadgeIconProvider(BadgeProvider badgeProvider) {
            this.badger = badgeProvider;
        }

        public Icon getIcon(File file, Icon icon) {
            Icon icon2 = this.badger.getBadge(file);
            if (icon2 != null && icon != null) {
                return new MergedIcon(icon, icon2, this.badger.getXOffset(), this.badger.getYOffset());
            }
            return icon;
        }
    }

    public static interface BadgeProvider {
        public Icon getBadge(File var1);

        public int getXOffset();

        public int getYOffset();
    }

    private static final class CustomFileView
    extends FileView {
        private final IconProvider provider;
        private final FileSystemView view;

        CustomFileView(IconProvider iconProvider, FileSystemView fileSystemView) {
            this.provider = iconProvider;
            this.view = fileSystemView;
        }

        public Icon getIcon(File file) {
            Icon icon = this.view.getSystemIcon(file);
            icon = this.provider.getIcon(file, icon);
            return icon;
        }
    }

    static interface IconProvider {
        public Icon getIcon(File var1, Icon var2);
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            assert (icon != null);
            assert (icon2 != null);
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    private static final class SavedDirFileChooser
    extends JFileChooser {
        private final String dirKey;
        private final SelectionApprover approver;

        SavedDirFileChooser(String string, File file, boolean bl, SelectionApprover selectionApprover) {
            this.dirKey = string;
            this.approver = selectionApprover;
            if (bl && file != null && file.exists() && file.isDirectory()) {
                this.setCurrentDirectory(file);
            } else {
                String string2;
                String string3 = string2 = DONT_STORE_DIRECTORIES ? null : NbPreferences.forModule(FileChooserBuilder.class).get(string, null);
                if (string2 != null) {
                    File file2 = new File(string2);
                    if (file2.exists() && file2.isDirectory()) {
                        this.setCurrentDirectory(file2);
                    } else if (file != null) {
                        this.setCurrentDirectory(file);
                    }
                } else if (file != null) {
                    this.setCurrentDirectory(file);
                }
            }
        }

        public void approveSelection() {
            if (this.approver != null) {
                boolean bl = this.approver.approve(this.getSelectedFiles());
                if (bl) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }

        public int showOpenDialog(Component component) throws HeadlessException {
            int n = super.showOpenDialog(component);
            if (n == 0) {
                this.saveCurrentDir();
            }
            return n;
        }

        public int showSaveDialog(Component component) throws HeadlessException {
            int n = super.showSaveDialog(component);
            if (n == 0) {
                this.saveCurrentDir();
            }
            return n;
        }

        private void saveCurrentDir() {
            File file = super.getCurrentDirectory();
            if (!DONT_STORE_DIRECTORIES && file != null && file.exists() && file.isDirectory()) {
                NbPreferences.forModule(FileChooserBuilder.class).put(this.dirKey, file.getPath());
            }
        }
    }

    public static interface SelectionApprover {
        public boolean approve(File[] var1);
    }
}

