/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.search;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.lib2.ComponentUtils;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.lib2.search.DocumentFinder;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorFindSupport {
    private static final Logger LOG = Logger.getLogger(EditorFindSupport.class.getName());
    public static final String FIND_WHAT = "find-what";
    public static final String FIND_REPLACE_WITH = "find-replace-with";
    public static final String FIND_HIGHLIGHT_SEARCH = "find-highlight-search";
    public static final String FIND_INC_SEARCH = "find-inc-search";
    public static final String FIND_INC_SEARCH_DELAY = "find-inc-search-delay";
    public static final String FIND_BACKWARD_SEARCH = "find-backward-search";
    public static final String FIND_WRAP_SEARCH = "find-wrap-search";
    public static final String FIND_MATCH_CASE = "find-match-case";
    public static final String FIND_SMART_CASE = "find-smart-case";
    public static final String FIND_WHOLE_WORDS = "find-whole-words";
    public static final String FIND_REG_EXP = "find-reg-exp";
    public static final String FIND_HISTORY = "find-history";
    public static final String FIND_HISTORY_SIZE = "find-history-size";
    public static final String FIND_BLOCK_SEARCH = "find-block-search";
    public static final String FIND_BLOCK_SEARCH_START = "find-block-search-start";
    public static final String FIND_BLOCK_SEARCH_END = "find-block-search-end";
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String WRAP_BLOCK_START_LOCALE = "find-block-wrap-start";
    private static final String WRAP_BLOCK_END_LOCALE = "find-block-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    private static final int IMPORTANCE_FIND_OR_REPLACE = 800;
    private static EditorFindSupport findSupport;
    private Map<String, Object> findProps;
    private final WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> comp2layer = new WeakHashMap();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private SPW lastSelected;
    private List<SPW> historyList;

    private EditorFindSupport() {
    }

    public static EditorFindSupport getInstance() {
        if (findSupport == null) {
            findSupport = new EditorFindSupport();
        }
        return findSupport;
    }

    public Map<String, Object> createDefaultFindProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIND_WHAT, null);
        hashMap.put(FIND_REPLACE_WITH, null);
        hashMap.put(FIND_HIGHLIGHT_SEARCH, Boolean.TRUE);
        hashMap.put(FIND_INC_SEARCH, Boolean.TRUE);
        hashMap.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
        hashMap.put(FIND_WRAP_SEARCH, Boolean.TRUE);
        hashMap.put(FIND_MATCH_CASE, Boolean.FALSE);
        hashMap.put(FIND_SMART_CASE, Boolean.FALSE);
        hashMap.put(FIND_WHOLE_WORDS, Boolean.FALSE);
        hashMap.put(FIND_REG_EXP, Boolean.FALSE);
        hashMap.put(FIND_HISTORY, new Integer(30));
        return hashMap;
    }

    private int getBlockEndOffset() {
        Position position = (Position)this.getFindProperties().get(FIND_BLOCK_SEARCH_END);
        return position != null ? position.getOffset() : -1;
    }

    public Map<String, Object> getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.createDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String string) {
        return this.getFindProperties().get(string);
    }

    private Map<String, Object> getValidFindProperties(Map<String, Object> map) {
        return map != null ? map : this.getFindProperties();
    }

    public int[] getBlocks(int[] nArray, Document document, int n, int n2) throws BadLocationException {
        Map<String, Object> map = this.getValidFindProperties(null);
        boolean bl = Boolean.TRUE.equals(map.get(FIND_BLOCK_SEARCH));
        Position position = (Position)map.get(FIND_BLOCK_SEARCH_START);
        Position position2 = (Position)map.get(FIND_BLOCK_SEARCH_END);
        if (bl && position != null && position2 != null) {
            if (n2 >= position.getOffset() && n <= position2.getOffset()) {
                n = Math.max(position.getOffset(), n);
                n2 = Math.min(position2.getOffset(), n2);
            } else {
                return nArray;
            }
        }
        return DocumentFinder.findBlocks(document, n, n2, map, nArray);
    }

    public void putFindProperty(String string, Object object) {
        Object object2 = this.getFindProperty(string);
        if (object2 == null && object == null || object2 != null && object2.equals(object)) {
            return;
        }
        if (object != null) {
            this.getFindProperties().put(string, object);
        } else {
            this.getFindProperties().remove(string);
        }
        this.firePropertyChange(string, object2, object);
    }

    public void putFindProperties(Map<String, Object> map) {
        if (this.getFindProperties() != map) {
            this.getFindProperties().putAll(map);
        }
        if (map.get(FIND_BLOCK_SEARCH_END) != null) {
            this.firePropertyChange(null, null, null);
        }
    }

    public void setBlockSearchHighlight(int n, int n2) {
        BlockHighlighting blockHighlighting;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        BlockHighlighting blockHighlighting2 = blockHighlighting = jTextComponent == null ? null : this.findLayer(jTextComponent, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/BLOCK_SEARCH");
        if (blockHighlighting != null) {
            if (n >= 0 && n2 >= 0 && n < n2) {
                blockHighlighting.highlightBlock(n, n2, "block-search", true, true);
            } else {
                blockHighlighting.highlightBlock(-1, -1, "block-search", true, true);
            }
        }
    }

    public boolean incSearch(Map<String, Object> map, int n) {
        Boolean bl = (Boolean)(map = this.getValidFindProperties(map)).get(FIND_REG_EXP);
        if (bl != null && bl.booleanValue()) {
            return false;
        }
        bl = (Boolean)map.get(FIND_INC_SEARCH);
        if (bl != null && bl.booleanValue()) {
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (jTextComponent != null) {
                int n2;
                bl = (Boolean)map.get(FIND_BACKWARD_SEARCH);
                boolean bl2 = bl != null && bl != false;
                bl = (Boolean)map.get(FIND_BLOCK_SEARCH);
                boolean bl3 = bl != null && bl != false;
                Position position = (Position)map.get(FIND_BLOCK_SEARCH_START);
                int n3 = position != null ? position.getOffset() : -1;
                Position position2 = (Position)map.get(FIND_BLOCK_SEARCH_END);
                int n4 = position2 != null ? position2.getOffset() : -1;
                try {
                    int n5;
                    int n6 = bl3 && n3 > -1 ? n3 : 0;
                    int n7 = n5 = bl3 && n4 > 0 ? n4 : -1;
                    if (n6 > 0 && n5 == -1) {
                        return false;
                    }
                    int[] nArray = this.findInBlock(jTextComponent, n, n6, n5, map, false);
                    if (nArray == null) {
                        this.incSearchReset();
                        return false;
                    }
                    n2 = nArray[0];
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
                    return false;
                }
                if (n2 >= 0) {
                    int n8;
                    BlockHighlighting blockHighlighting = this.findLayer(jTextComponent, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
                    String string = (String)map.get(FIND_WHAT);
                    int n9 = n8 = string != null ? string.length() : 0;
                    if (n8 > 0) {
                        if (jTextComponent.getSelectionEnd() > jTextComponent.getSelectionStart()) {
                            jTextComponent.select(n, n);
                        }
                        if (blockHighlighting != null) {
                            blockHighlighting.highlightBlock(n2, n2 + n8, bl3 ? "inc-search" : "selection", false, false);
                        }
                        this.ensureVisible(jTextComponent, n2, n2);
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        BlockHighlighting blockHighlighting;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        BlockHighlighting blockHighlighting2 = blockHighlighting = jTextComponent == null ? null : this.findLayer(jTextComponent, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
        if (blockHighlighting != null) {
            blockHighlighting.highlightBlock(-1, -1, null, false, false);
        }
    }

    private boolean isBackSearch(Map map, boolean bl) {
        boolean bl2;
        Boolean bl3 = (Boolean)map.get(FIND_BACKWARD_SEARCH);
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            bl2 = !bl2;
        }
        return bl2;
    }

    private void selectText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        Caret caret = jTextComponent.getCaret();
        this.ensureVisible(jTextComponent, n, n2);
        if (bl) {
            caret.setDot(n2);
            caret.moveDot(n);
        } else {
            caret.setDot(n);
            caret.moveDot(n2);
        }
    }

    private void ensureVisible(JTextComponent jTextComponent, int n, int n2) {
        this.ensureVisible(jTextComponent, n, n2, new Insets(10, 10, 10, 10));
    }

    private void ensureVisible(JTextComponent jTextComponent, int n, int n2, Insets insets) {
        try {
            Rectangle rectangle = jTextComponent.modelToView(n);
            Rectangle rectangle2 = jTextComponent.modelToView(n2);
            if (rectangle != null && rectangle2 != null) {
                rectangle.add(rectangle2);
                if (insets != null) {
                    Rectangle rectangle3 = jTextComponent.getVisibleRect();
                    int n3 = insets.top < 0 ? -insets.top * rectangle3.height / 100 : insets.top * rectangle2.height;
                    rectangle.y -= n3;
                    rectangle.height += n3;
                    rectangle.height = rectangle.height + (insets.bottom < 0 ? -insets.bottom * rectangle3.height / 100 : insets.bottom * rectangle2.height);
                    int n4 = insets.left < 0 ? -insets.left * rectangle3.width / 100 : insets.left * rectangle2.width;
                    rectangle.x -= n4;
                    rectangle.width += n4;
                    rectangle.width = rectangle.width + (insets.right < 0 ? -insets.right * rectangle3.width / 100 : insets.right * rectangle2.width);
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private DocumentFinder.FindReplaceResult findReplaceImpl(String string, Map<String, Object> map, boolean bl, JTextComponent jTextComponent) {
        this.incSearchReset();
        map = this.getValidFindProperties(map);
        boolean bl2 = this.isBackSearch(map, bl);
        Object object = map.get(FIND_WHAT);
        if (object == null) {
            return null;
        }
        String string2 = "'" + object + "' ";
        if (jTextComponent != null) {
            Object object2;
            boolean bl3;
            ComponentUtils.clearStatusText(jTextComponent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            if (object.equals(jTextComponent.getSelectedText()) && n == (bl ^ (bl3 = (object2 = map.get(FIND_BACKWARD_SEARCH)) != null ? (Boolean)object2 : false) ? jTextComponent.getSelectionEnd() : jTextComponent.getSelectionStart())) {
                n += bl ^ bl3 ? -1 : 1;
            }
            bl3 = (object2 = (Boolean)map.get(FIND_BLOCK_SEARCH)) != null && ((Boolean)object2).booleanValue();
            Position position = (Position)map.get(FIND_BLOCK_SEARCH_START);
            int n2 = position != null ? position.getOffset() : -1;
            int n3 = this.getBlockEndOffset();
            try {
                DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceInBlock(string, jTextComponent, n, bl3 && n2 > -1 ? n2 : 0, bl3 && n3 > 0 ? n3 : -1, map, bl);
                int[] nArray = null;
                if (findReplaceResult != null) {
                    nArray = findReplaceResult.getFoundPositions();
                }
                if (nArray != null) {
                    this.selectText(jTextComponent, nArray[0], nArray[1], bl2);
                    String string3 = string2 + NbBundle.getBundle(EditorFindSupport.class).getString(FOUND_LOCALE) + ' ' + DocUtils.debugPosition(jTextComponent.getDocument(), nArray[0]);
                    if (nArray[2] == 1) {
                        string3 = string3 + "; ";
                        string3 = bl3 && n3 > 0 && n2 > -1 ? string3 + (bl2 ? NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_BLOCK_END_LOCALE) : NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_BLOCK_START_LOCALE)) : string3 + (bl2 ? NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_END_LOCALE) : NbBundle.getBundle(EditorFindSupport.class).getString(WRAP_START_LOCALE));
                        ComponentUtils.setStatusText(jTextComponent, string3, 800);
                        jTextComponent.getToolkit().beep();
                    } else {
                        ComponentUtils.setStatusText(jTextComponent, string3, 800);
                    }
                    return findReplaceResult;
                }
                ComponentUtils.setStatusText(jTextComponent, string2 + NbBundle.getBundle(EditorFindSupport.class).getString(NOT_FOUND_LOCALE), 800);
                jTextComponent.getCaret().setDot(jTextComponent.getCaret().getDot());
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
            }
        }
        return null;
    }

    public boolean find(Map<String, Object> map, boolean bl) {
        DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceImpl(null, map, bl, EditorRegistry.lastFocusedComponent());
        return findReplaceResult != null;
    }

    private DocumentFinder.FindReplaceResult findReplaceInBlock(String string, JTextComponent jTextComponent, int n, int n2, int n3, Map<String, Object> map, boolean bl) throws BadLocationException {
        if (jTextComponent != null) {
            int[] nArray;
            map = this.getValidFindProperties(map);
            Document document = jTextComponent.getDocument();
            int n4 = -1;
            boolean bl2 = false;
            String string2 = null;
            boolean bl3 = this.isBackSearch(map, bl);
            Boolean bl4 = (Boolean)map.get(FIND_WRAP_SEARCH);
            boolean bl5 = bl4 != null && bl4 != false;
            int n5 = document.getLength();
            if (n3 == -1) {
                n3 = n5;
            }
            if (n == -1) {
                n = n5;
            }
            while (true) {
                int n6;
                int n7;
                DocumentFinder.FindReplaceResult findReplaceResult;
                if ((findReplaceResult = DocumentFinder.findReplaceResult(string, document, Math.min(n7 = n, n6 = bl3 ? n2 : n3), Math.max(n7, n6), map, bl)) == null) {
                    return null;
                }
                nArray = findReplaceResult.getFoundPositions();
                string2 = findReplaceResult.getReplacedString();
                if (nArray == null || (n4 = nArray[0]) != -1 || !bl5) break;
                n = bl3 ? n3 : n2;
                bl2 = true;
                bl5 = false;
            }
            if (n4 != -1) {
                int[] nArray2 = new int[]{n4, nArray[1], bl2 ? 1 : 0};
                return new DocumentFinder.FindReplaceResult(nArray2, string2);
            }
        }
        return null;
    }

    public int[] findInBlock(JTextComponent jTextComponent, int n, int n2, int n3, Map<String, Object> map, boolean bl) throws BadLocationException {
        DocumentFinder.FindReplaceResult findReplaceResult = this.findReplaceInBlock(null, jTextComponent, n, n2, n3, map, bl);
        return findReplaceResult == null ? null : findReplaceResult.getFoundPositions();
    }

    public boolean replace(Map<String, Object> map, boolean bl) throws BadLocationException {
        this.incSearchReset();
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        return this.replaceImpl(map, bl, jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceImpl(Map<String, Object> map, boolean bl, JTextComponent jTextComponent) throws BadLocationException {
        int n;
        map = this.getValidFindProperties(map);
        boolean bl2 = Boolean.TRUE.equals(map.get(FIND_BACKWARD_SEARCH));
        if (bl) {
            bl2 = !bl2;
        }
        boolean bl3 = Boolean.TRUE.equals(map.get(FIND_BLOCK_SEARCH));
        Position position = (Position)map.get(FIND_BLOCK_SEARCH_START);
        int n2 = n = position != null ? position.getOffset() : -1;
        if (jTextComponent != null) {
            DocumentFinder.FindReplaceResult findReplaceResult;
            int n3;
            Object object;
            String string = (String)map.get(FIND_REPLACE_WITH);
            Caret caret = jTextComponent.getCaret();
            if (caret.isSelectionVisible() && caret.getDot() != caret.getMark()) {
                int n4 = caret.getDot();
                object = map.get(FIND_BACKWARD_SEARCH);
                n3 = (object != null ? (Boolean)object : 0) ? 1 : 0;
                n4 = bl ^ n3 ? jTextComponent.getSelectionEnd() : jTextComponent.getSelectionStart();
                jTextComponent.setCaretPosition(n4);
            }
            if ((findReplaceResult = this.findReplaceImpl(string, map, bl, jTextComponent)) == null) {
                return false;
            }
            string = findReplaceResult.getReplacedString();
            object = jTextComponent.getDocument();
            n3 = jTextComponent.getSelectionStart();
            int n5 = jTextComponent.getSelectionEnd() - n3;
            DocUtils.atomicLock((Document)object);
            try {
                if (n5 > 0) {
                    object.remove(n3, n5);
                }
                if (string != null && string.length() > 0) {
                    object.insertString(n3, string, null);
                    if (n3 == n) {
                        position = object.createPosition(n3);
                        map.put(FIND_BLOCK_SEARCH_START, position);
                    }
                }
            }
            finally {
                DocUtils.atomicUnlock((Document)object);
                if (bl3) {
                    this.setBlockSearchHighlight(n, this.getBlockEndOffset());
                }
            }
            int n6 = bl2 || string == null ? n3 : n3 + string.length();
            caret.setDot(n6);
        }
        return true;
    }

    public void replaceAll(Map<String, Object> map) {
        this.incSearchReset();
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        this.replaceAllImpl(map, jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceAllImpl(Map<String, Object> map, JTextComponent jTextComponent) {
        Position position;
        map = this.getValidFindProperties(map);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        String string = (String)hashMap.get(FIND_REPLACE_WITH);
        Object v = hashMap.get(FIND_WHAT);
        if (v == null) {
            return;
        }
        if (v.equals(string)) {
            return;
        }
        Document document = jTextComponent.getDocument();
        int n = document.getLength();
        int n2 = 0;
        int n3 = 0;
        boolean bl = Boolean.TRUE.equals(hashMap.get(FIND_BLOCK_SEARCH));
        boolean bl2 = Boolean.TRUE.equals(hashMap.get(FIND_WRAP_SEARCH));
        boolean bl3 = Boolean.TRUE.equals(hashMap.get(FIND_BACKWARD_SEARCH));
        if (bl2) {
            hashMap.put(FIND_WRAP_SEARCH, Boolean.FALSE);
            hashMap.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
            this.firePropertyChange(null, null, null);
        }
        int n4 = (position = (Position)hashMap.get(FIND_BLOCK_SEARCH_START)) != null ? position.getOffset() : -1;
        int n5 = this.getBlockEndOffset();
        if (jTextComponent != null) {
            DocUtils.atomicLock(document);
            try {
                Object object;
                Object object2;
                int n6;
                int n7 = 0;
                int n8 = -1;
                int n9 = jTextComponent.getCaret().getDot();
                if (!bl2) {
                    if (bl3) {
                        n7 = 0;
                        n8 = n9;
                    } else {
                        n7 = n9;
                        n8 = -1;
                    }
                }
                int n10 = n6 = bl2 ? 0 : jTextComponent.getCaret().getDot();
                int n11 = bl && n4 > -1 ? (bl3 ? n5 : n4) : (bl3 ? -1 : n6);
                do {
                    n5 = this.getBlockEndOffset();
                    object2 = this.findReplaceInBlock(string, jTextComponent, n11, bl && n4 > -1 ? n4 : n7, bl && n5 > 0 ? n5 : n8, hashMap, bl3);
                    if (object2 == null) break;
                    object = ((DocumentFinder.FindReplaceResult)object2).getFoundPositions();
                    String string2 = ((DocumentFinder.FindReplaceResult)object2).getReplacedString();
                    if (object == null) break;
                    ++n3;
                    int n12 = object[1] - object[0];
                    boolean bl4 = false;
                    try {
                        document.remove(object[0], n12);
                    }
                    catch (BadLocationException badLocationException) {
                        if (ComponentUtils.isGuardedException(badLocationException)) {
                            bl4 = true;
                        }
                        throw badLocationException;
                    }
                    if (bl4) {
                        n11 = bl3 ? object[0] : object[0] + n12;
                        continue;
                    }
                    if (string2 != null && string2.length() > 0) {
                        int n13 = object[0];
                        document.insertString(n13, string2, null);
                        if (n13 == n4) {
                            position = document.createPosition(n13);
                            map.put(FIND_BLOCK_SEARCH_START, position);
                        }
                    }
                    n11 = bl3 ? object[0] : object[0] + (string2 != null ? string2.length() : 0);
                    ++n2;
                } while (n2 <= n);
                if (n3 == 0) {
                    object2 = "'' ";
                    if (v != null) {
                        object2 = "'" + v + "' ";
                    }
                    ComponentUtils.setStatusText(jTextComponent, (String)object2 + NbBundle.getBundle(EditorFindSupport.class).getString(NOT_FOUND_LOCALE), 800);
                } else {
                    object2 = new MessageFormat(NbBundle.getBundle(EditorFindSupport.class).getString(ITEMS_REPLACED_LOCALE));
                    object = ((Format)object2).format(new Object[]{new Integer(n2), new Integer(n3)});
                    ComponentUtils.setStatusText(jTextComponent, (String)object, 800);
                }
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
            }
            finally {
                DocUtils.atomicUnlock(document);
                if (bl) {
                    this.setBlockSearchHighlight(n4, this.getBlockEndOffset());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hookLayer(BlockHighlighting blockHighlighting, JTextComponent jTextComponent) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> map = this.comp2layer.get(jTextComponent);
            if (map == null) {
                map = new HashMap<String, WeakReference<BlockHighlighting>>();
                this.comp2layer.put(jTextComponent, map);
            }
            map.put(blockHighlighting.getLayerTypeId(), new WeakReference<BlockHighlighting>(blockHighlighting));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhookLayer(BlockHighlighting blockHighlighting, JTextComponent jTextComponent) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> map = this.comp2layer.get(jTextComponent);
            if (map != null) {
                map.remove(blockHighlighting.getLayerTypeId());
                if (map.isEmpty()) {
                    this.comp2layer.remove(jTextComponent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockHighlighting findLayer(JTextComponent jTextComponent, String string) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            WeakReference<BlockHighlighting> weakReference;
            Map<String, WeakReference<BlockHighlighting>> map = this.comp2layer.get(jTextComponent);
            BlockHighlighting blockHighlighting = null;
            if (map != null && (weakReference = map.get(string)) != null) {
                blockHighlighting = (BlockHighlighting)weakReference.get();
            }
            return blockHighlighting;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public void setHistory(List<SPW> list) {
        this.historyList = new ArrayList<SPW>(list);
        this.firePropertyChange(FIND_HISTORY_CHANGED_PROP, null, null);
    }

    public List<SPW> getHistory() {
        return this.historyList;
    }

    public void setLastSelected(SPW sPW) {
        this.lastSelected = sPW;
        Map<String, Object> map = this.getFindProperties();
        if (sPW == null) {
            return;
        }
        map.put(FIND_WHAT, sPW.getSearchExpression());
        map.put(FIND_MATCH_CASE, sPW.isMatchCase());
        map.put(FIND_REG_EXP, sPW.isRegExp());
        map.put(FIND_WHOLE_WORDS, sPW.isWholeWords());
    }

    public SPW getLastSelected() {
        return this.lastSelected;
    }

    public void addToHistory(SPW sPW) {
        if (sPW == null) {
            return;
        }
        this.firePropertyChange(FIND_HISTORY_PROP, null, sPW);
    }

    public static final class SPW {
        private String searchExpression;
        private boolean wholeWords;
        private boolean matchCase;
        private boolean regExp;

        public SPW(String string, boolean bl, boolean bl2, boolean bl3) {
            this.searchExpression = string;
            this.wholeWords = bl;
            this.matchCase = bl2;
            this.regExp = bl3;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SPW)) {
                return false;
            }
            SPW sPW = (SPW)object;
            return this.searchExpression.equals(sPW.getSearchExpression()) && this.wholeWords == sPW.isWholeWords() && this.matchCase == sPW.isMatchCase() && this.regExp == sPW.isRegExp();
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + (this.wholeWords ? 1 : 0);
            n = 37 * n + (this.matchCase ? 1 : 0);
            n = 37 * n + (this.regExp ? 1 : 0);
            n = 37 * n + this.searchExpression.hashCode();
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            stringBuffer.append('\n');
            stringBuffer.append("wholeWords:");
            stringBuffer.append(this.wholeWords);
            stringBuffer.append('\n');
            stringBuffer.append("matchCase:");
            stringBuffer.append(this.matchCase);
            stringBuffer.append('\n');
            stringBuffer.append("regExp:");
            stringBuffer.append(this.regExp);
            return stringBuffer.toString();
        }
    }
}

