/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.search;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DocumentFinder {
    private static final Logger LOG = Logger.getLogger(EditorFindSupport.class.getName());

    private DocumentFinder() {
    }

    /*
     * Unable to fully structure code
     */
    private static DocFinder getFinder(Document var0, Map var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = (String)var1_1.get("find-what");
        if (var4_4 == null || var4_4.length() == 0) {
            if (var3_3) {
                return FalseBlocksFinder.INSTANCE;
            }
            return FalseFinder.INSTANCE;
        }
        var5_5 = (Boolean)var1_1.get("find-backward-search");
        v0 = var6_6 = var5_5 != null && var5_5 != false;
        if (var2_2) {
            var6_6 = var6_6 == false;
        }
        var7_7 = (var5_5 = (Boolean)var1_1.get("find-match-case")) != null && var5_5 != false;
        var5_5 = (Boolean)var1_1.get("find-smart-case");
        var8_8 = var5_5 != null && var5_5 != false;
        var5_5 = (Boolean)var1_1.get("find-whole-words");
        v1 = var9_9 = var5_5 != null && var5_5 != false;
        if (var8_8 && !var7_7) {
            var10_10 = var4_4.length();
            for (var11_11 = 0; var11_11 < var10_10; ++var11_11) {
                if (!Character.isUpperCase(var4_4.charAt(var11_11))) continue;
                var7_7 = true;
            }
        }
        var10_10 = (var5_5 = (Boolean)var1_1.get("find-reg-exp")) != null && var5_5 != false ? 1 : 0;
        var11_12 = null;
        if (var10_10 != 0) {
            try {
                var11_12 = PatternCache.getPattern(var4_4, var7_7);
                if (var11_12 != null) ** GOTO lbl39
                var11_12 = var7_7 != false ? Pattern.compile(var4_4, 8) : Pattern.compile(var4_4, 10);
                PatternCache.putPattern(var4_4, var7_7, var11_12);
            }
            catch (PatternSyntaxException var12_13) {
                if (!var3_3) {
                    var13_23 = new NotifyDescriptor.Message((Object)var12_13.getDescription(), 0);
                    var13_23.setTitle(NbBundle.getBundle(DocumentFinder.class).getString("pattern-error-dialog-title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)var13_23);
                }
                PatternCache.putPattern(var4_4, var7_7, null);
                return null;
            }
        } else {
            PatternCache.clear();
        }
lbl39:
        // 3 sources

        if (var3_3) {
            if (var9_9 && var10_10 == 0) {
                var12_14 = new WholeWordsBlocksFinder();
                var12_14.setParams(var0, var4_4, var7_7);
                return var12_14;
            }
            if (var10_10 != 0) {
                var12_15 = new RegExpBlocksFinder();
                var12_15.setParams(var11_12, var7_7);
                return var12_15;
            }
            var12_16 = new StringBlocksFinder();
            var12_16.setParams(var4_4, var7_7);
            return var12_16;
        }
        if (var9_9 && var10_10 == 0) {
            if (var6_6) {
                var12_17 = new WholeWordsBwdFinder();
                var12_17.setParams(var0, var4_4, var7_7);
                return var12_17;
            }
            var12_18 = new WholeWordsFwdFinder();
            var12_18.setParams(var0, var4_4, var7_7);
            return var12_18;
        }
        if (var10_10 != 0) {
            if (var6_6) {
                var12_19 = new RegExpBwdFinder();
                var12_19.setParams(var11_12, var7_7);
                return var12_19;
            }
            var12_20 = new RegExpFwdFinder();
            var12_20.setParams(var11_12, var7_7);
            return var12_20;
        }
        if (var6_6) {
            var12_21 = new StringBwdFinder();
            var12_21.setParams(var4_4, var7_7);
            return var12_21;
        }
        var12_22 = new StringFwdFinder();
        var12_22.setParams(var4_4, var7_7);
        return var12_22;
    }

    private static FindReplaceResult findReplaceImpl(String string, Document document, int n, int n2, Map map, boolean bl) throws BadLocationException {
        Matcher matcher;
        CharSequence charSequence;
        int n3;
        boolean bl2;
        DocFinder docFinder;
        int[] nArray = new int[2];
        if (n2 == -1) {
            n2 = document.getLength();
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if ((docFinder = DocumentFinder.getFinder(document, map, bl, false)) == null) {
            return null;
        }
        docFinder.reset();
        Boolean bl3 = (Boolean)map.get("find-backward-search");
        boolean bl4 = bl2 = bl3 != null && bl3 != false;
        if (bl) {
            bl2 = !bl2;
        }
        boolean bl5 = (bl3 = (Boolean)map.get("find-block-search")) != null && bl3 != false;
        Position position = (Position)map.get("find-block-search-start");
        int n5 = position != null ? position.getOffset() : 0;
        Position position2 = (Position)map.get("find-block-search-end");
        int n6 = n3 = position2 != null ? position2.getOffset() : document.getLength();
        if (n5 > n3) {
            LOG.log(Level.WARNING, "end=" + n3 + " < start=" + n5);
            int n7 = n5;
            n5 = n3;
            n3 = n7;
        }
        CharSequence charSequence2 = DocumentUtilities.getText((Document)document);
        CharSequence charSequence3 = charSequence = bl5 ? charSequence2.subSequence(n5, n3) : charSequence2;
        int n8 = bl2 && !bl5 ? (n2 < document.getLength() ? n2 : n) : (bl2 && bl5 ? n2 - n : (!bl2 && bl5 ? n - n5 : n));
        if (n8 < 0 || n8 > charSequence.length()) {
            LOG.log(Level.INFO, "Index: " + n8 + "\nOffset: " + n + "-" + n2 + "\nBlock: " + n5 + "-" + n3 + "\nLength : " + charSequence.length());
            n8 = Math.max(n8, 0);
            n8 = Math.min(n8, charSequence.length());
        }
        int n9 = docFinder.find(n8, charSequence);
        if (!docFinder.isFound()) {
            nArray[0] = -1;
            return new FindReplaceResult(nArray, string);
        }
        nArray[0] = bl5 ? n5 + n9 : n9;
        if (docFinder instanceof StringFinder) {
            int n10 = ((StringFinder)docFinder).getFoundLength();
            nArray[1] = nArray[0] + n10;
        }
        if (docFinder instanceof RegExpFinder && (matcher = ((RegExpFinder)docFinder).getMatcher()) != null && string != null) {
            CharSequence charSequence4 = charSequence2.subSequence(nArray[0], nArray[1]);
            matcher.reset(charSequence4);
            if (matcher.find()) {
                try {
                    string = matcher.replaceFirst(DocumentFinder.convertStringForMatcher(string));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)indexOutOfBoundsException.getLocalizedMessage(), 0);
                    message.setTitle(NbBundle.getBundle(DocumentFinder.class).getString("pattern-error-dialog-title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return null;
                }
            }
        }
        return new FindReplaceResult(nArray, string);
    }

    public static int[] find(Document document, int n, int n2, Map map, boolean bl) throws BadLocationException {
        FindReplaceResult findReplaceResult = DocumentFinder.findReplaceImpl(null, document, n, n2, map, bl);
        if (findReplaceResult == null) {
            return null;
        }
        return findReplaceResult.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findBlocks(Document document, int n, int n2, Map map, int[] nArray) throws BadLocationException {
        BlocksFinder blocksFinder = (BlocksFinder)DocumentFinder.getFinder(document, map, false, true);
        if (blocksFinder == null) {
            return nArray;
        }
        CharSequence charSequence = DocumentUtilities.getText((Document)document, (int)n, (int)(n2 - n));
        if (charSequence == null) {
            return null;
        }
        BlocksFinder blocksFinder2 = blocksFinder;
        synchronized (blocksFinder2) {
            blocksFinder.reset();
            blocksFinder.setBlocks(nArray);
            blocksFinder.find(n, charSequence);
            int[] nArray2 = blocksFinder.getBlocks();
            return nArray2;
        }
    }

    public static FindReplaceResult findReplaceResult(String string, Document document, int n, int n2, Map map, boolean bl) throws BadLocationException {
        return DocumentFinder.findReplaceImpl(string, document, n, n2, map, bl);
    }

    private static String convertStringForMatcher(String string) {
        String string2 = null;
        if (string != null) {
            String[] stringArray = string.split("\\\\\\\\", string.length());
            string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                string3 = string3.replace("\\r", "\r");
                string3 = string3.replace("\\n", "\n");
                string3 = string3.replace("\\t", "\t");
                string2 = string2 + string3;
                if (i == stringArray.length - 1) continue;
                string2 = string2 + "\\\\";
            }
        }
        return string2;
    }

    private static abstract class AbstractBlocksFinder
    extends AbstractFinder
    implements BlocksFinder {
        private static int[] EMPTY_INT_ARRAY = new int[0];
        private int[] blocks = EMPTY_INT_ARRAY;
        private int blocksInd;
        private boolean closed;

        private AbstractBlocksFinder() {
        }

        public void reset() {
            super.reset();
            this.blocksInd = 0;
            this.closed = false;
        }

        public final int[] getBlocks() {
            if (!this.closed) {
                this.closeBlocks();
                this.closed = true;
            }
            return this.blocks;
        }

        public final void setBlocks(int[] nArray) {
            this.blocks = nArray;
            this.blocksInd = 0;
            this.closed = false;
        }

        protected final void addBlock(int n, int n2) {
            if (this.blocksInd + 2 > this.blocks.length) {
                int[] nArray = new int[Math.max(10, (this.blocksInd + 1) * 2)];
                System.arraycopy(this.blocks, 0, nArray, 0, this.blocks.length);
                this.blocks = nArray;
            }
            this.blocks[this.blocksInd] = n;
            this.blocks[this.blocksInd + 1] = n2;
            this.blocksInd += 2;
        }

        protected final void closeBlocks() {
            this.addBlock(-1, -1);
        }

        public final String debugBlocks() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (this.blocks[n] != -1) {
                stringBuffer.append(n / 2 + 1 + ": [" + this.blocks[n] + ", " + this.blocks[n + 1] + "]\n");
                n += 2;
            }
            return stringBuffer.toString();
        }
    }

    private static abstract class AbstractFinder
    implements DocFinder {
        protected boolean found;

        private AbstractFinder() {
        }

        public final boolean isFound() {
            return this.found;
        }

        public void reset() {
            this.found = false;
        }
    }

    private static interface BlocksFinder
    extends DocFinder {
        public void setBlocks(int[] var1);

        public int[] getBlocks();
    }

    private static interface DocFinder {
        public int find(int var1, CharSequence var2);

        public boolean isFound();

        public void reset();
    }

    private static final class FalseBlocksFinder
    extends AbstractBlocksFinder {
        public static final FalseBlocksFinder INSTANCE = new FalseBlocksFinder();

        public int find(int n, CharSequence charSequence) {
            return -1;
        }

        private FalseBlocksFinder() {
        }
    }

    private static class FalseFinder
    extends AbstractFinder
    implements StringFinder {
        public static final FalseFinder INSTANCE = new FalseFinder();

        public int find(int n, CharSequence charSequence) {
            return -1;
        }

        public int getFoundLength() {
            return 0;
        }

        private FalseFinder() {
        }
    }

    public static class FindReplaceResult {
        private int[] positions;
        private String replacedString;

        public FindReplaceResult(int[] nArray, String string) {
            this.positions = nArray;
            this.replacedString = string;
        }

        public String getReplacedString() {
            return this.replacedString;
        }

        public int[] getFoundPositions() {
            return this.positions;
        }
    }

    private static abstract class GenericBwdFinder
    extends AbstractFinder {
        private GenericBwdFinder() {
        }

        public final int find(int n, CharSequence charSequence) {
            int n2;
            boolean bl = false;
            int n3 = charSequence.length();
            for (n2 = n != 0 ? n - 1 : charSequence.length() - 1; n2 >= 0 && n2 < n3; n2 += this.scan(charSequence.charAt(n2), n2 == n3)) {
                if (!this.found) continue;
                break;
            }
            return n2;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static abstract class GenericFwdFinder
    extends AbstractFinder {
        private GenericFwdFinder() {
        }

        public final int find(int n, CharSequence charSequence) {
            int n2;
            int n3 = charSequence.length();
            int n4 = n3 - 1;
            for (n2 = n; n2 >= 0 && n2 < n3; n2 += this.scan(charSequence.charAt(n2), n2 == n4)) {
                if (!this.found) continue;
                break;
            }
            return n2;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static class PatternCache {
        private static String cache_str;
        private static boolean cache_matchCase;
        private static Pattern cache_pattern;

        private PatternCache() {
        }

        public static void putPattern(String string, boolean bl, Pattern pattern) {
            cache_str = string;
            cache_matchCase = bl;
            cache_pattern = pattern;
        }

        public static Pattern getPattern(String string, boolean bl) {
            if (string == null) {
                return null;
            }
            if (string.equals(cache_str) && bl == cache_matchCase) {
                return cache_pattern;
            }
            return null;
        }

        public static void clear() {
            cache_str = null;
            cache_matchCase = false;
            cache_pattern = null;
        }
    }

    private static final class RegExpBlocksFinder
    extends AbstractBlocksFinder {
        Pattern pattern;
        int stringInd;
        boolean matchCase;

        public void setParams(Pattern pattern, boolean bl) {
            this.pattern = pattern;
            this.matchCase = bl;
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        public int find(int n, CharSequence charSequence) {
            Matcher matcher = this.pattern.matcher(charSequence);
            int n2 = 0;
            while (matcher.find()) {
                int n3 = n + matcher.start();
                int n4 = n + matcher.end();
                this.addBlock(n3, n4);
                n2 = n3;
            }
            return n2;
        }
    }

    private static class RegExpBwdFinder
    extends RegExpFinder {
        boolean matchCase;
        Pattern pattern;
        int length = 0;
        Matcher matcher;

        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean bl) {
            this.matchCase = bl;
            this.pattern = pattern;
        }

        public int getFoundLength() {
            return this.length;
        }

        public void reset() {
            super.reset();
            this.length = 0;
        }

        private int lineFind(int n, int n2, CharSequence charSequence) {
            this.matcher = this.pattern.matcher(charSequence.subSequence(n, n2));
            int n3 = -1;
            while (this.matcher.find()) {
                int n4 = this.matcher.start();
                int n5 = this.matcher.end();
                this.length = n5 - n4;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                n3 = n4;
            }
            return n3;
        }

        public int find(int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = n != 0 ? n - 1 : charSequence.length() - 1;
            int n4 = n2;
            for (int i = n2; i >= 0; --i) {
                char c = charSequence.charAt(i);
                if (c == '\n' || i == 0) {
                    int n5 = this.lineFind(n4 + (i == 0 ? 0 : 1), n3 + 1, charSequence);
                    if (n5 != -1) {
                        this.found = true;
                        return i + n5 + (i == 0 ? 0 : 1);
                    }
                    n3 = --n4;
                    continue;
                }
                --n4;
            }
            return -1;
        }
    }

    private static abstract class RegExpFinder
    extends AbstractFinder
    implements StringFinder {
        private RegExpFinder() {
        }

        public abstract Matcher getMatcher();
    }

    private static final class RegExpFwdFinder
    extends RegExpFinder {
        Pattern pattern;
        boolean matchCase;
        int length = 0;
        Matcher matcher;

        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean bl) {
            this.matchCase = bl;
            this.pattern = pattern;
        }

        public int getFoundLength() {
            return this.length;
        }

        public void reset() {
            super.reset();
            this.length = 0;
        }

        public int find(int n, CharSequence charSequence) {
            this.matcher = this.pattern.matcher(charSequence);
            if (this.matcher.find(n)) {
                this.found = true;
                int n2 = this.matcher.start();
                int n3 = this.matcher.end();
                this.length = n3 - n2;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                return n2;
            }
            return -1;
        }
    }

    private static final class StringBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        public int find(int n, CharSequence charSequence) {
            int n2 = 0;
            int n3 = charSequence.length();
            while (n2 >= 0 && n2 < n3) {
                char c = charSequence.charAt(n2);
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        int n4 = n + n2 + 1;
                        this.addBlock(n4 - this.stringInd, n4);
                        this.stringInd = 0;
                    }
                    ++n2;
                    continue;
                }
                n2 += 1 - this.stringInd;
                this.stringInd = 0;
            }
            return n2;
        }
    }

    private static class StringBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        int endInd;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = this.endInd;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            if (this.stringInd == this.endInd) {
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            return n;
        }
    }

    private static interface StringFinder
    extends DocFinder {
        public int getFoundLength();
    }

    private static final class StringFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    this.found = true;
                    return 1 - this.stringInd;
                }
                return 1;
            }
            if (this.stringInd == 0) {
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            return n;
        }
    }

    private static final class WholeWordsBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;
        Document doc;

        public void setParams(Document document, String string, boolean bl) {
            this.matchCase = bl;
            this.doc = document;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = DocUtils.isIdentifierPart(document, this.chars[0]);
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        public int find(int n, CharSequence charSequence) {
            int n2 = 0;
            int n3 = charSequence.length();
            int n4 = n3 - 1;
            while (n2 >= 0 && n2 < n3) {
                int n5;
                char c = charSequence.charAt(n2);
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.wordFound) {
                    if (DocUtils.isIdentifierPart(this.doc, c)) {
                        this.insideWord = this.firstCharWordPart;
                        n2 -= this.chars.length - 1;
                    } else {
                        n5 = n + n2;
                        this.addBlock(n5 - this.chars.length, n5);
                        this.insideWord = false;
                        ++n2;
                    }
                    this.wordFound = false;
                    this.stringInd = 0;
                    continue;
                }
                if (this.stringInd == 0) {
                    if (c != this.chars[0] || this.insideWord) {
                        this.insideWord = DocUtils.isIdentifierPart(this.doc, c);
                        ++n2;
                        continue;
                    }
                    this.stringInd = 1;
                    if (this.chars.length == 1) {
                        if (n2 == n4) {
                            n5 = n + n2;
                            this.addBlock(n5, n5 + 1);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n2;
                    continue;
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        if (n2 == n4) {
                            n5 = n + 1;
                            this.addBlock(n5 - this.stringInd, n5);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n2;
                    continue;
                }
                n2 += 1 - this.stringInd;
                this.stringInd = 0;
                this.insideWord = this.firstCharWordPart;
            }
            return n2;
        }
    }

    private static final class WholeWordsBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean lastCharWordPart;
        boolean wordFound;
        int endInd;
        Document doc;

        public void setParams(Document document, String string, boolean bl) {
            this.doc = document;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
            DocUtils.isIdentifierPart(document, this.chars[this.endInd]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = this.endInd;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (DocUtils.isIdentifierPart(this.doc, c)) {
                    this.wordFound = false;
                    this.insideWord = this.lastCharWordPart;
                    this.stringInd = this.endInd;
                    return this.endInd;
                }
                this.found = true;
                return 1;
            }
            if (this.stringInd == this.endInd) {
                if (c != this.chars[this.endInd] || this.insideWord) {
                    this.insideWord = DocUtils.isIdentifierPart(this.doc, c);
                    return -1;
                }
                this.stringInd = this.endInd - 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            this.insideWord = this.lastCharWordPart;
            return n;
        }
    }

    private static final class WholeWordsFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        Document doc;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;

        public void setParams(Document document, String string, boolean bl) {
            this.doc = document;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = DocUtils.isIdentifierPart(document, this.chars[0]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (DocUtils.isIdentifierPart(this.doc, c)) {
                    this.wordFound = false;
                    this.insideWord = this.firstCharWordPart;
                    this.stringInd = 0;
                    return 1 - this.chars.length;
                }
                this.found = true;
                return -this.chars.length;
            }
            if (this.stringInd == 0) {
                if (c != this.chars[0] || this.insideWord) {
                    this.insideWord = DocUtils.isIdentifierPart(this.doc, c);
                    return 1;
                }
                this.stringInd = 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    if (bl) {
                        this.found = true;
                        return 1 - this.chars.length;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            this.insideWord = this.firstCharWordPart;
            return n;
        }
    }
}

