/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyntaxHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.SyntaxHighlighting";
    private final HashMap<String, WeakHashMap<TokenId, AttributeSet>> attribsCache = new HashMap();
    private final HashMap<String, FontColorSettings> fcsCache = new HashMap();
    private final Document document;
    private final String mimeTypeForHack;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    public SyntaxHighlighting(Document document) {
        this.document = document;
        String string = (String)document.getProperty("mimeType");
        this.mimeTypeForHack = string != null && string.startsWith("test") ? string : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int n, int n2) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            if (this.hierarchy == null) {
                this.hierarchy = TokenHierarchy.get((Document)this.document);
                this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
            }
            if (this.hierarchy.isActive()) {
                return new HSImpl(this.version, this.hierarchy, n, n2);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        if (tokenHierarchyEvent.type() == TokenHierarchyEventType.ACTIVITY || tokenHierarchyEvent.type() == TokenHierarchyEventType.LANGUAGE_PATHS) {
            return;
        }
        Object object = this;
        synchronized (object) {
            ++this.version;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            object = new StringBuilder();
            TokenSequence tokenSequence = this.hierarchy.tokenSequence();
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append("Tokens after change: <" + tokenHierarchyEvent.affectedStartOffset() + ", " + tokenHierarchyEvent.affectedEndOffset() + ">\n");
            SyntaxHighlighting.dumpSequence(tokenSequence, (StringBuilder)object);
            ((StringBuilder)object).append("--------------------------------------------\n\n");
            LOG.finest(((StringBuilder)object).toString());
        }
        this.fireHighlightsChange(tokenHierarchyEvent.affectedStartOffset(), tokenHierarchyEvent.affectedEndOffset());
    }

    private static void dumpSequence(TokenSequence<?> tokenSequence, StringBuilder stringBuilder) {
        if (tokenSequence == null) {
            stringBuilder.append("Inactive TokenHierarchy");
        } else {
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 != null) {
                    SyntaxHighlighting.dumpSequence(tokenSequence2, stringBuilder);
                    continue;
                }
                Token token = tokenSequence.token();
                stringBuilder.append("<");
                stringBuilder.append(String.format("%3s", tokenSequence.offset())).append(", ");
                stringBuilder.append(String.format("%3s", tokenSequence.offset() + token.length())).append(", ");
                stringBuilder.append(String.format("%+3d", token.length())).append("> : ");
                stringBuilder.append(SyntaxHighlighting.tokenId(token.id(), true)).append(" : '");
                stringBuilder.append(SyntaxHighlighting.tokenText(token));
                stringBuilder.append("'\n");
            }
        }
    }

    private static String tokenId(TokenId tokenId, boolean bl) {
        if (bl) {
            return String.format("%20s.%-15s", tokenId.getClass().getSimpleName(), tokenId.name());
        }
        return tokenId.getClass().getSimpleName() + "." + tokenId.name();
    }

    private static String tokenText(Token<?> token) {
        CharSequence charSequence = token.text();
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Character.isISOControl(c)) {
                switch (c) {
                    case '\n': {
                        stringBuilder.append("\\n");
                        break;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        break;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        break;
                    }
                    default: {
                        stringBuilder.append("\\").append(Integer.toOctalString(c));
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String attributeSet(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return "AttributeSet is null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (obj == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("'").append(obj.toString()).append("'");
            }
            stringBuilder.append(" = ");
            if (object == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("'").append(object.toString()).append("'");
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HSImpl
    implements HighlightsSequence {
        private static final int S_NORMAL = 1;
        private static final int S_EMBEDDED_HEAD = 2;
        private static final int S_EMBEDDED_TAIL = 3;
        private static final int S_DONE = 4;
        private final long version;
        private final TokenHierarchy<? extends Document> scanner;
        private final int startOffset;
        private final int endOffset;
        private List<TokenSequence<?>> sequences;
        private int state = -1;
        private LogHelper logHelper;

        public HSImpl(long l, TokenHierarchy<? extends Document> tokenHierarchy, int n, int n2) {
            this.version = l;
            this.scanner = tokenHierarchy;
            this.startOffset = n;
            this.endOffset = n2;
            this.sequences = null;
            if (LOG.isLoggable(Level.FINE)) {
                this.logHelper = new LogHelper();
                this.logHelper.startTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                TokenSequence tokenSequence;
                if (this.checkVersion()) {
                    if (this.sequences == null) {
                        this.sequences = new ArrayList();
                        tokenSequence = this.scanner.tokenSequence();
                        if (tokenSequence != null) {
                            tokenSequence.move(this.startOffset);
                            this.sequences.add(tokenSequence);
                            this.state = 1;
                        } else {
                            this.state = 4;
                        }
                    }
                } else {
                    this.state = 4;
                }
                switch (this.state) {
                    case 1: {
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 2: {
                        tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveStart();
                        if (tokenSequence.moveNext()) {
                            this.state = 1;
                            break;
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 3: {
                        this.sequences.remove(this.sequences.size() - 1);
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid state: " + this.state);
                    }
                }
                if (this.state == 1) {
                    tokenSequence = this.sequences.get(this.sequences.size() - 1);
                    TokenSequence tokenSequence2 = tokenSequence.embedded();
                    while (tokenSequence2 != null && tokenSequence2.moveNext()) {
                        this.sequences.add(this.sequences.size(), tokenSequence2);
                        if (tokenSequence2.offset() + tokenSequence2.token().length() < this.startOffset) {
                            tokenSequence2.move(this.startOffset);
                            if (!tokenSequence2.moveNext()) {
                                this.state = 3;
                                break;
                            }
                        } else if (tokenSequence2.offset() > tokenSequence.offset()) {
                            this.state = 2;
                            break;
                        }
                        tokenSequence = tokenSequence2;
                        tokenSequence2 = tokenSequence.embedded();
                    }
                } else if (this.state == 4) {
                    SyntaxHighlighting.this.attribsCache.clear();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (this.state != 4) {
                        ++this.logHelper.tokenCount;
                    } else {
                        LOG.fine("SyntaxHighlighting for " + this.scanner.inputSource() + ":\n-> returned " + this.logHelper.tokenCount + " token highlights for <" + this.startOffset + "," + this.endOffset + "> in " + (System.currentTimeMillis() - this.logHelper.startTime) + " ms.\n");
                    }
                }
                return this.state != 4;
            }
        }

        @Override
        public int getStartOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        return Math.max(tokenSequence.offset(), this.startOffset);
                    }
                    case 2: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 2);
                        return Math.max(tokenSequence.offset(), this.startOffset);
                    }
                    case 3: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveEnd();
                        if (tokenSequence.movePrevious()) {
                            return Math.max(tokenSequence.offset() + tokenSequence.token().length(), this.startOffset);
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public int getEndOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        return Math.min(tokenSequence.offset() + tokenSequence.token().length(), this.endOffset);
                    }
                    case 2: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveStart();
                        if (tokenSequence.moveNext()) {
                            return Math.min(tokenSequence.offset(), this.endOffset);
                        }
                        TokenSequence<?> tokenSequence2 = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(tokenSequence2.offset() + tokenSequence2.token().length(), this.endOffset);
                    }
                    case 3: {
                        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(tokenSequence.offset() + tokenSequence.token().length(), this.endOffset);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public AttributeSet getAttributes() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        return this.findAttribs(this.sequences.size() - 1);
                    }
                    case 2: 
                    case 3: {
                        return this.findAttribs(this.sequences.size() - 2);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        private AttributeSet findAttribs(int n) {
            AttributeSet attributeSet;
            TokenSequence<?> tokenSequence = this.sequences.get(n);
            TokenId tokenId = tokenSequence.token().id();
            String string = SyntaxHighlighting.this.mimeTypeForHack != null ? this.languagePathToMimePathHack(tokenSequence.languagePath()) : tokenSequence.languagePath().mimePath();
            WeakHashMap<TokenId, AttributeSet> weakHashMap = (WeakHashMap<TokenId, AttributeSet>)SyntaxHighlighting.this.attribsCache.get(string);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<TokenId, AttributeSet>();
                SyntaxHighlighting.this.attribsCache.put(string, weakHashMap);
            }
            if ((attributeSet = (AttributeSet)weakHashMap.get(tokenId)) == null) {
                attributeSet = this.findTokenAttribs(tokenId, string, tokenSequence.languagePath().innerLanguage());
                weakHashMap.put(tokenId, attributeSet);
            }
            if (LOG.isLoggable(Level.FINE)) {
                attributeSet = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, "<html><b>Token:</b> " + tokenSequence.token().text() + "<br><b>Id:</b> " + tokenId.name() + "<br><b>Category:</b> " + tokenId.primaryCategory() + "<br><b>Ordinal:</b> " + tokenId.ordinal() + "<br><b>Mimepath:</b> " + string}), attributeSet});
            }
            return attributeSet;
        }

        private AttributeSet findTokenAttribs(TokenId tokenId, String string, Language<?> language) {
            Lookup lookup;
            FontColorSettings fontColorSettings = (FontColorSettings)SyntaxHighlighting.this.fcsCache.get(string);
            if (fontColorSettings == null) {
                lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
                fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
                SyntaxHighlighting.this.fcsCache.put(string, fontColorSettings);
                if (fontColorSettings == null && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("No FontColorSettings for '" + string + "' mime path.");
                }
            }
            AttributeSet attributeSet = lookup = fontColorSettings == null ? null : this.findFontAndColors(fontColorSettings, tokenId, language);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(SyntaxHighlighting.tokenId(tokenId, false) + " -> {" + SyntaxHighlighting.attributeSet((AttributeSet)lookup) + "}");
            }
            return lookup != null ? lookup : SimpleAttributeSet.EMPTY;
        }

        private String languagePathToMimePathHack(LanguagePath languagePath) {
            if (languagePath.size() == 1) {
                return SyntaxHighlighting.this.mimeTypeForHack;
            }
            if (languagePath.size() > 1) {
                return SyntaxHighlighting.this.mimeTypeForHack + "/" + languagePath.subPath(1).mimePath();
            }
            throw new IllegalStateException("LanguagePath should not be empty.");
        }

        private AttributeSet findFontAndColors(FontColorSettings fontColorSettings, TokenId tokenId, Language language) {
            AttributeSet attributeSet;
            block2: {
                String string;
                Object object;
                String string2 = tokenId.name();
                attributeSet = fontColorSettings.getTokenFontColors(string2);
                if (attributeSet == null && (object = tokenId.primaryCategory()) != null) {
                    attributeSet = fontColorSettings.getTokenFontColors((String)object);
                }
                if (attributeSet != null) break block2;
                object = language.nonPrimaryTokenCategories(tokenId);
                Iterator iterator = object.iterator();
                while (iterator.hasNext() && (attributeSet = fontColorSettings.getTokenFontColors(string = (String)iterator.next())) == null) {
                }
            }
            return attributeSet;
        }

        private int moveTheSequence() {
            TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
            if (tokenSequence.moveNext()) {
                if (tokenSequence.offset() < this.endOffset) {
                    return 1;
                }
                return 4;
            }
            if (this.sequences.size() > 1) {
                TokenSequence<?> tokenSequence2 = this.sequences.get(this.sequences.size() - 2);
                tokenSequence.moveEnd();
                if (tokenSequence.movePrevious()) {
                    if (tokenSequence.offset() + tokenSequence.token().length() < tokenSequence2.offset() + tokenSequence2.token().length()) {
                        return 3;
                    }
                    this.sequences.remove(this.sequences.size() - 1);
                    return this.moveTheSequence();
                }
                throw new IllegalStateException("Invalid state");
            }
            this.sequences.clear();
            return 4;
        }

        private boolean checkVersion() {
            return this.version == SyntaxHighlighting.this.version;
        }
    }

    private static final class LogHelper {
        int tokenCount;
        long startTime;

        private LogHelper() {
        }
    }
}

