/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.EditorUtilities;
import org.netbeans.modules.editor.lib2.actions.EditorActionUtilities;
import org.netbeans.modules.editor.lib2.actions.SearchableEditorKit;
import org.openide.awt.Actions;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresenterEditorAction
extends TextAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar,
PropertyChangeListener {
    private static final String SELECTED_KEY = "SwingSelectedKey";
    private static final Logger LOG = Logger.getLogger(PresenterEditorAction.class.getName());
    private static Reference<SearchableEditorKit> activeKitRef;
    private static boolean activeKitLastFocused;
    private static final Set<PresenterEditorAction> presenterActions;
    private static final ChangeListener actionsChangeListener;
    private final String actionName;
    private JMenuItem menuPresenter;
    private JMenuItem popupPresenter;
    private Component toolBarPresenter;
    private Action globalKitAction;
    private Action activeKitAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchableEditorKit activeKit() {
        Class<PresenterEditorAction> clazz = PresenterEditorAction.class;
        synchronized (PresenterEditorAction.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return activeKitRef != null ? activeKitRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerAction(PresenterEditorAction presenterEditorAction) {
        Class<PresenterEditorAction> clazz = PresenterEditorAction.class;
        synchronized (PresenterEditorAction.class) {
            presenterActions.add(presenterEditorAction);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void refreshActiveKitActions(SearchableEditorKit searchableEditorKit, boolean bl) {
        for (PresenterEditorAction presenterEditorAction : presenterActions) {
            presenterEditorAction.refreshActiveKitAction(searchableEditorKit, bl);
        }
    }

    public static Action create(Map<String, ?> map) {
        String string = (String)map.get("Name");
        if (string == null) {
            throw new IllegalArgumentException("Null Action.NAME attribute for attrs: " + map);
        }
        return new PresenterEditorAction(string);
    }

    private PresenterEditorAction(String string) {
        super(string);
        this.actionName = string;
        this.refreshGlobalAction(EditorActionUtilities.getGlobalActionsKit());
        this.refreshActiveKitAction(PresenterEditorAction.activeKit(), true);
        PresenterEditorAction.registerAction(this);
    }

    @Override
    public void putValue(String string, Object object) {
        if (this.actionName != null && "Name".equals(string)) {
            throw new IllegalArgumentException("PresenterEditorAction(\"" + this.actionName + "\"): putValue(Action.NAME,newName) prohibited.");
        }
        super.putValue(string, object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        EditorKit editorKit;
        TextUI textUI;
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent != null && (textUI = jTextComponent.getUI()) != null && (editorKit = textUI.getEditorKit(jTextComponent)) != null) {
            Action action = EditorUtilities.getAction(editorKit, this.actionName);
            if (action != null) {
                action.actionPerformed(actionEvent);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Action '" + this.actionName + "' not found in editor kit " + editorKit + '\n');
            }
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = this.createMenuItem(false);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getMenuPresenter() for action=" + this.actionName + " returns " + this.menuPresenter);
        }
        return this.menuPresenter;
    }

    public JMenuItem getPopupPresenter() {
        if (this.popupPresenter == null) {
            this.popupPresenter = this.createMenuItem(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getPopupPresenter() for action=" + this.actionName + " returns " + this.popupPresenter);
        }
        return this.popupPresenter;
    }

    public Component getToolbarPresenter() {
        if (this.toolBarPresenter == null) {
            this.toolBarPresenter = new JButton(this);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getToolbarPresenter() for action=" + this.actionName + " returns " + this.toolBarPresenter);
        }
        return this.toolBarPresenter;
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && !"instanceCreate".equals(string)) {
            Action action = this.activeKitAction;
            if (action != null) {
                object = action.getValue(string);
            }
            if (object == null && (action = this.globalKitAction) != null) {
                object = action.getValue(string);
            }
        }
        return object;
    }

    @Override
    public boolean isEnabled() {
        return this.activeKitAction != null ? this.activeKitAction.isEnabled() && activeKitLastFocused : false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SELECTED_KEY.equals(string)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("propertyChange() of SELECTED_KEY for action " + this.actionName);
            }
            this.updateSelectedInPresenters();
        }
        this.firePropertyChange(string, null, null);
    }

    void refreshGlobalAction(SearchableEditorKit searchableEditorKit) {
        Action action;
        Action action2 = action = searchableEditorKit != null ? searchableEditorKit.getAction(this.actionName) : null;
        if (action != this.globalKitAction) {
            if (this.globalKitAction != null) {
                this.globalKitAction.removePropertyChangeListener(this);
            }
            ActionPropertyRefresh actionPropertyRefresh = new ActionPropertyRefresh();
            actionPropertyRefresh.before();
            this.globalKitAction = action;
            actionPropertyRefresh.after();
            if (this.globalKitAction != null) {
                this.globalKitAction.addPropertyChangeListener(this);
            }
        }
    }

    void refreshActiveKitAction(SearchableEditorKit searchableEditorKit, boolean bl) {
        boolean bl2;
        if (bl) {
            Action action;
            Action action2 = action = searchableEditorKit != null ? searchableEditorKit.getAction(this.actionName) : null;
            if (action != this.activeKitAction) {
                if (this.activeKitAction != null) {
                    this.activeKitAction.removePropertyChangeListener(this);
                }
                ActionPropertyRefresh actionPropertyRefresh = new ActionPropertyRefresh();
                actionPropertyRefresh.before();
                this.activeKitAction = action;
                actionPropertyRefresh.after();
                if (this.activeKitAction != null) {
                    this.activeKitAction.addPropertyChangeListener(this);
                }
            }
        }
        this.firePropertyChange("enabled", !(bl2 = this.isEnabled()), bl2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("\"" + this.actionName + "\".refreshActiveKitAction(): activeKitFocused=" + activeKitLastFocused + ", newEnabled=" + bl2 + ", kitChanged=" + bl + '\n');
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "", new Exception());
            }
        }
    }

    private void updateSelectedInPresenters() {
        if (this.isCheckBox()) {
            boolean bl = this.isSelected();
            if (this.menuPresenter instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)this.menuPresenter).setSelected(bl);
            }
            if (this.popupPresenter instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)this.popupPresenter).setSelected(bl);
            }
        }
    }

    private boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue(SELECTED_KEY));
    }

    private JMenuItem createMenuItem(boolean bl) {
        JMenuItem jMenuItem;
        if (this.isCheckBox()) {
            jMenuItem = new JCheckBoxMenuItem();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Create checkbox menu item for action " + this.actionName + ", selected=" + this.isSelected());
            }
            jMenuItem.setSelected(this.isSelected());
            jMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl;
                    boolean bl2 = ((JCheckBoxMenuItem)itemEvent.getSource()).isSelected();
                    if (bl2 != (bl = PresenterEditorAction.this.isSelected())) {
                        Action action = PresenterEditorAction.this.activeKitAction;
                        if (action != null) {
                            action.putValue(PresenterEditorAction.SELECTED_KEY, bl2);
                        } else {
                            action = PresenterEditorAction.this.globalKitAction;
                            if (action != null) {
                                action.putValue(PresenterEditorAction.SELECTED_KEY, bl2);
                            }
                        }
                    }
                }
            });
        } else {
            jMenuItem = new JMenuItem();
        }
        Actions.connect((JMenuItem)jMenuItem, (Action)this, (boolean)bl);
        return jMenuItem;
    }

    private boolean isCheckBox() {
        String string = (String)this.getValue("PresenterType");
        return "CheckBox".equals(string);
    }

    static {
        presenterActions = new WeakSet();
        actionsChangeListener = new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent changeEvent) {
                Class<PresenterEditorAction> clazz = PresenterEditorAction.class;
                synchronized (PresenterEditorAction.class) {
                    PresenterEditorAction.refreshActiveKitActions(PresenterEditorAction.activeKit(), true);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        EditorRegistry.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("focusGained".equals(propertyChangeEvent.getPropertyName())) {
                    Object object;
                    JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                    SearchableEditorKit searchableEditorKit = PresenterEditorAction.activeKit();
                    EditorKit editorKit = null;
                    if (jTextComponent != null && (object = jTextComponent.getUI()) != null) {
                        editorKit = ((TextUI)object).getEditorKit(jTextComponent);
                    }
                    object = PresenterEditorAction.class;
                    synchronized (PresenterEditorAction.class) {
                        boolean bl;
                        SearchableEditorKit searchableEditorKit2;
                        SearchableEditorKit searchableEditorKit3 = searchableEditorKit2 = editorKit != null ? EditorActionUtilities.getSearchableKit(editorKit) : null;
                        if (searchableEditorKit2 != searchableEditorKit) {
                            if (searchableEditorKit != null) {
                                searchableEditorKit.removeActionsChangeListener(actionsChangeListener);
                            }
                            activeKitRef = searchableEditorKit2 != null ? new WeakReference<SearchableEditorKit>(searchableEditorKit2) : null;
                            if (searchableEditorKit2 != null) {
                                searchableEditorKit2.addActionsChangeListener(actionsChangeListener);
                            }
                            bl = true;
                        } else {
                            bl = false;
                        }
                        boolean bl2 = !activeKitLastFocused;
                        activeKitLastFocused = true;
                        if (!bl2 && !bl) return;
                        PresenterEditorAction.refreshActiveKitActions(searchableEditorKit2, bl);
                        // ** MonitorExit[var5_8] (shouldn't be in output)
                        return;
                    }
                }
                if (!"focusLost".equals(propertyChangeEvent.getPropertyName())) return;
                Class<PresenterEditorAction> clazz = PresenterEditorAction.class;
                synchronized (PresenterEditorAction.class) {
                    boolean bl;
                    boolean bl3 = bl = EditorRegistry.lastFocusedComponent() != null;
                    if (bl == activeKitLastFocused) return;
                    activeKitLastFocused = bl;
                    for (PresenterEditorAction presenterEditorAction : presenterActions) {
                        presenterEditorAction.refreshActiveKitAction(null, false);
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        });
        EditorActionUtilities.getGlobalActionsKit().addActionsChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent changeEvent) {
                SearchableEditorKit searchableEditorKit = EditorActionUtilities.getGlobalActionsKit();
                Class<PresenterEditorAction> clazz = PresenterEditorAction.class;
                synchronized (PresenterEditorAction.class) {
                    for (PresenterEditorAction presenterEditorAction : presenterActions) {
                        presenterEditorAction.refreshGlobalAction(searchableEditorKit);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private final class ActionPropertyRefresh {
        private boolean checkBox;
        private boolean selected;

        ActionPropertyRefresh() {
            this.checkBox = PresenterEditorAction.this.isCheckBox();
        }

        void before() {
            if (this.checkBox) {
                this.selected = PresenterEditorAction.this.isSelected();
            }
        }

        void after() {
            if (this.checkBox && this.selected != PresenterEditorAction.this.isSelected()) {
                PresenterEditorAction.this.firePropertyChange(PresenterEditorAction.SELECTED_KEY, this.selected, !this.selected);
            }
        }
    }
}

