/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import org.netbeans.modules.editor.lib2.Acceptor;

public class AcceptorFactory {
    public static final Acceptor TRUE = new Fixed(true);
    public static final Acceptor FALSE = new Fixed(false);
    public static final Acceptor NL = new Char('\n');
    public static final Acceptor SPACE_NL = new TwoChar(' ', '\n');
    public static final Acceptor WHITESPACE = new Acceptor(){

        public final boolean accept(char c) {
            return Character.isWhitespace(c);
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.WHITESPACE";
        }
    };
    public static final Acceptor LETTER_DIGIT = new Acceptor(){

        public final boolean accept(char c) {
            return Character.isLetterOrDigit(c);
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.LETTER_DIGIT";
        }
    };
    public static final Acceptor UNICODE_IDENTIFIER = new Acceptor(){

        public final boolean accept(char c) {
            return Character.isUnicodeIdentifierPart(c);
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.UNICODE_IDENTIFIER";
        }
    };
    public static final Acceptor JAVA_IDENTIFIER = new Acceptor(){

        public final boolean accept(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.JAVA_IDENTIFIER";
        }
    };
    public static final Acceptor NON_JAVA_IDENTIFIER = new Acceptor(){

        public final boolean accept(char c) {
            return !Character.isJavaIdentifierPart(c);
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.NON_JAVA_IDENTIFIER";
        }
    };

    private static final class Char
    implements Acceptor {
        private char hit;

        public Char(char c) {
            this.hit = c;
        }

        public final boolean accept(char c) {
            return c == this.hit;
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.Char@" + Integer.toHexString(System.identityHashCode(this)) + " : hit = " + this.hit;
        }
    }

    private static final class Fixed
    implements Acceptor {
        private boolean state;

        public Fixed(boolean bl) {
            this.state = bl;
        }

        public final boolean accept(char c) {
            return this.state;
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.Fixed@" + Integer.toHexString(System.identityHashCode(this)) + " : state = " + this.state;
        }
    }

    private static final class TwoChar
    implements Acceptor {
        private char hit1;
        private char hit2;

        public TwoChar(char c, char c2) {
            this.hit1 = c;
            this.hit2 = c2;
        }

        public final boolean accept(char c) {
            return c == this.hit1 || c == this.hit2;
        }

        public String toString() {
            return "o.n.m.e.lib2.AcceptorFactory.TwoChar@" + Integer.toHexString(System.identityHashCode(this)) + " : hit1 = " + this.hit1 + ", hit2 = " + this.hit2;
        }
    }
}

