/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes.properties;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.designer.sheet.properties.IntegerProperty;
import com.jaspersoft.ireport.designer.undo.PropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.NbBundle;

public final class RowSpanProperty
extends IntegerProperty {
    private final DesignCell cell;
    private final StandardTable table;
    private final JasperDesign jd;

    public RowSpanProperty(DesignCell cell, StandardTable table, JasperDesign jd) {
        super((Object)cell);
        this.cell = cell;
        this.table = table;
        this.jd = jd;
    }

    public String getName() {
        return "rowSpan";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TableElementNode.class, (String)"cell.rowSpan.property");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TableElementNode.class, (String)"cell.rowSpan.property.description");
    }

    public Integer getInteger() {
        return this.getOwnInteger();
    }

    public Integer getOwnInteger() {
        return this.cell.getRowSpan() == null ? this.getDefaultInteger() : this.cell.getRowSpan();
    }

    public Integer getDefaultInteger() {
        return 1;
    }

    public void setInteger(Integer span) {
        TableMatrix matrix = TableModelUtils.createTableMatrix(this.table, this.jd);
        TableCell tableCell = matrix.getTableCell(this.cell);
        int oldSpan = tableCell.getRowSpan();
        int changedHLine = -1;
        ArrayList<Integer> hlines = new ArrayList<Integer>(matrix.getHorizontalSeparators());
        if (span != oldSpan) {
            this.cell.setHeight(Integer.valueOf(matrix.getHorizontalSeparators().get(tableCell.getRow() + span) - matrix.getHorizontalSeparators().get(tableCell.getRow())));
        }
        this.cell.setRowSpan(span);
        TableModelUtils.fixTableLayout(this.table, this.jd);
        matrix.processMatrix();
        for (int i = 0; i < hlines.size(); ++i) {
            if (((Integer)hlines.get(i)).intValue() == matrix.getHorizontalSeparators().get(i).intValue()) continue;
            int delta = matrix.getHorizontalSeparators().get(i) - (Integer)hlines.get(i);
            System.out.println("Fixing cells on the changed line: " + i + "Delta: " + delta);
            System.out.flush();
            List<TableCell> cells = matrix.getCells();
            for (TableCell cell : cells) {
                if (cell.getRow() + cell.getRowSpan() != i || cell.getCell() == null) continue;
                cell.getCell().setHeight(Integer.valueOf(cell.getCell().getHeight() - delta));
            }
            break;
        }
        this.cell.getEventSupport().firePropertyChange("ROW_HEIGHT", null, (Object)span);
    }

    public void setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object oldValue = this.getOwnPropertyValue();
        this.validate(newValue);
        this.setPropertyValue(newValue);
        PropertyUndoableEdit undo = new PropertyUndoableEdit((AbstractProperty)this, oldValue, newValue);
        IReportManager.getInstance().addUndoableEdit((UndoableEdit)undo);
    }

    public void validateInteger(Integer span) {
        if (span < 1) {
            throw this.annotateException(NbBundle.getMessage(TableElementNode.class, (String)"cell.rowSpan.validationError"));
        }
        TableMatrix matrix = TableModelUtils.createTableMatrix(this.table, this.jd);
        TableCell tableCell = matrix.getTableCell(this.cell);
        int maxSpan = matrix.getMaxRowSpan(this.cell);
        if (span > maxSpan) {
            throw this.annotateException(NbBundle.getMessage(TableElementNode.class, (String)"cell.rowSpan.maxSpan", (Object)maxSpan));
        }
    }
}

