/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.widgets.IndicatorWidget;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public class TableSceneClickAction
extends WidgetAction.Adapter {
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (widget instanceof TableObjectScene) {
            TableObjectScene scene = (TableObjectScene)widget.getScene();
            Node tableNode = this.findNode(scene.getTableElement(), OutlineTopComponent.getDefault().getExplorerManager().getRootContext());
            if (tableNode == null) {
                return WidgetAction.State.REJECTED;
            }
            TableCell cell = ((TableObjectScene)widget).getTableMatrix().getCellAt(event.getPoint());
            Node cellNode = null;
            if (cell != null) {
                cellNode = this.findNode(cell, tableNode);
            }
            Node node = cellNode == null ? tableNode : cellNode;
            try {
                ExplorerManager manager = ExplorerManager.find((Component)((TableObjectScene)widget).getJComponent());
                manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
            if (cellNode == null) {
                Rectangle r;
                Point p = event.getPoint();
                BaseColumn column = scene.getTableMatrix().getColumnAt(p);
                if (column != null && (r = scene.getTableMatrix().getColumnBounds(column)) != null) {
                    scene.getIndicatorsLayer().removeChildren();
                    IndicatorWidget cw = new IndicatorWidget(scene, column, 0);
                    cw.setPreferredLocation(new Point(r.x, -10));
                    cw.setPreferredBounds(new Rectangle(0, 0, r.width, 8));
                    cw.revalidate(true);
                    scene.getIndicatorsLayer().addChild((Widget)cw);
                    cw.revalidate();
                    scene.validate();
                }
            }
        }
        return WidgetAction.State.REJECTED;
    }

    public Node findNode(JRDesignComponentElement element, Node root) {
        Node[] nodes;
        if (root instanceof TableElementNode && ((TableElementNode)root).getElement() == element) {
            return root;
        }
        for (Node node : nodes = root.getChildren().getNodes()) {
            Node res = this.findNode(element, node);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Node findNode(TableCell tc, Node root) {
        Node[] nodes;
        TableNullCellNode nullNode;
        DesignCell cell = tc.getCell();
        BaseColumn column = tc.getColumn();
        int section = tc.getType();
        String groupName = tc.getGroupName();
        if (root instanceof TableCellNode && ((TableCellNode)root).getCell() == cell) {
            return root;
        }
        if (root instanceof TableNullCellNode && (nullNode = (TableNullCellNode)root).getSection() == section && nullNode.getColumn() == column && (groupName == null && nullNode.getGroup() == null || nullNode.getGroup() != null && nullNode.getGroup().getName().equals(groupName))) {
            return root;
        }
        for (Node node : nodes = root.getChildren().getNodes()) {
            Node res = this.findNode(tc, node);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

