/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.actions.TableColumnMoveProvider;
import com.jaspersoft.ireport.components.table.actions.TableColumnMoveStrategy;
import com.jaspersoft.ireport.components.table.widgets.IndicatorWidget;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public class TableColumnMoveAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy strategy = new TableColumnMoveStrategy();
    private MoveProvider provider = new TableColumnMoveProvider();
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.movingWidget = widget;
            ((AbstractReportObjectScene)this.movingWidget.getScene()).getJComponent().setCursor(IndicatorWidget.getClosedHandCursor());
            ((IndicatorWidget)this.movingWidget).setMovingColumnMode(true);
            this.originalSceneLocation = this.provider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
            this.provider.movementStarted(widget);
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.move(widget, event.getPoint());
        if (state) {
            ((AbstractReportObjectScene)this.movingWidget.getScene()).getJComponent().setCursor(IndicatorWidget.getOpenHandCursor());
            ((IndicatorWidget)this.movingWidget).setMovingColumnMode(false);
            this.movingWidget = null;
            this.provider.movementFinished(widget);
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return false;
        }
        newLocation = widget.convertLocalToScene(newLocation);
        Point location = new Point(this.originalSceneLocation.x + newLocation.x - this.dragSceneLocation.x, this.originalSceneLocation.y + newLocation.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, location));
        return true;
    }
}

