/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;

public class PrintAXITreeVisitor
extends DeepAXITreeVisitor {
    private int depth = 0;
    private static boolean PRINT_TO_CONSOLE = false;

    protected void visitChildren(AXIComponent aXIComponent) {
        if (PRINT_TO_CONSOLE) {
            this.printModel(aXIComponent);
        }
        ++this.depth;
        super.visitChildren(aXIComponent);
        --this.depth;
    }

    private void printModel(AXIComponent aXIComponent) {
        AXIComponent aXIComponent2;
        StringBuffer stringBuffer = new StringBuffer();
        if (aXIComponent instanceof Compositor) {
            aXIComponent2 = (Compositor)aXIComponent;
            stringBuffer.append(this.getTab() == null ? aXIComponent2 : this.getTab() + aXIComponent2);
            stringBuffer.append("<min=" + ((Compositor)aXIComponent2).getMinOccurs() + ":max=" + ((Compositor)aXIComponent2).getMaxOccurs() + ">");
        }
        if (aXIComponent instanceof Element) {
            aXIComponent2 = (Element)aXIComponent;
            stringBuffer.append(this.getTab() == null ? ((AXIContainer)aXIComponent2).getName() : this.getTab() + ((AXIContainer)aXIComponent2).getName());
            if (((AXIContainer)aXIComponent2).getAttributes().size() != 0) {
                stringBuffer.append("<" + this.getAttributes((Element)aXIComponent2) + ">");
            }
            stringBuffer.append("<min=" + ((AbstractElement)aXIComponent2).getMinOccurs() + ":max=" + ((AbstractElement)aXIComponent2).getMaxOccurs() + ">");
        }
        if (aXIComponent instanceof AnyElement) {
            aXIComponent2 = (AnyElement)aXIComponent;
            stringBuffer.append(this.getTab() == null ? aXIComponent2 : this.getTab() + aXIComponent2);
        }
        System.out.println(stringBuffer.toString());
    }

    private String getAttributes(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AbstractAttribute abstractAttribute : element.getAttributes()) {
            stringBuffer.append(abstractAttribute + ":");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private String getTab() {
        String string = "++++";
        if (this.depth == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

