/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.axi.impl.DefaultSchemaGenerator;
import org.netbeans.modules.xml.axi.impl.GardenOfEden;
import org.netbeans.modules.xml.axi.impl.MixedPattern;
import org.netbeans.modules.xml.axi.impl.RussianDoll;
import org.netbeans.modules.xml.axi.impl.SalamiSlice;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.impl.VenetianBlind;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGeneratorFactoryImpl
extends SchemaGeneratorFactory {
    @Override
    public SchemaGenerator.Pattern inferDesignPattern(AXIModel aXIModel) {
        return SchemaGeneratorUtil.inferDesignPattern(aXIModel);
    }

    @Override
    public void updateSchema(SchemaModel schemaModel, SchemaGenerator.Pattern pattern) throws BadLocationException, IOException {
        DefaultSchemaGenerator defaultSchemaGenerator = null;
        if (pattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            defaultSchemaGenerator = new GardenOfEden(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            defaultSchemaGenerator = new VenetianBlind(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            defaultSchemaGenerator = new SalamiSlice(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            defaultSchemaGenerator = new RussianDoll(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.MIXED) {
            defaultSchemaGenerator = new MixedPattern(SchemaGenerator.Mode.UPDATE);
        }
        if (defaultSchemaGenerator != null) {
            ((SchemaGenerator)defaultSchemaGenerator).updateSchema(schemaModel);
        }
    }

    @Override
    public List<Element> findMasterGlobalElements(AXIModel aXIModel) {
        return SchemaGeneratorUtil.findMasterGlobalElements(aXIModel);
    }

    @Override
    public SchemaGeneratorFactory.TransformHint canTransformSchema(SchemaModel schemaModel, SchemaGenerator.Pattern pattern, SchemaGenerator.Pattern pattern2) {
        return this.canTransformSchema(schemaModel, pattern, pattern2, this.findMasterGlobalElements(AXIModelFactory.getDefault().getModel(schemaModel)));
    }

    @Override
    public SchemaGeneratorFactory.TransformHint canTransformSchema(SchemaModel schemaModel, SchemaGenerator.Pattern pattern, SchemaGenerator.Pattern pattern2, List<Element> list) {
        if (schemaModel == null) {
            return SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
        if (aXIModel == null || aXIModel.getState() != Model.State.VALID || aXIModel.getState() == Model.State.NOT_WELL_FORMED) {
            return SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA;
        }
        if (pattern == pattern2) {
            return SchemaGeneratorFactory.TransformHint.SAME_DESIGN_PATTERN;
        }
        if (pattern != null && pattern2 != null) {
            boolean bl;
            if (list.size() == 0) {
                return SchemaGeneratorFactory.TransformHint.NO_GLOBAL_ELEMENTS;
            }
            if (list.size() > 1 && (pattern2 == SchemaGenerator.Pattern.RUSSIAN_DOLL || pattern2 == SchemaGenerator.Pattern.VENITIAN_BLIND)) {
                return SchemaGeneratorFactory.TransformHint.CANNOT_REMOVE_GLOBAL_ELEMENTS;
            }
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            int n3 = aXIModel.getRoot().getElements().size();
            block0: for (Element element : aXIModel.getRoot().getElements()) {
                ArrayList<AbstractElement> arrayList = new ArrayList<AbstractElement>(element.getChildElements());
                this.filterOtherModelComponents(arrayList, aXIModel);
                ArrayList<AbstractAttribute> arrayList2 = new ArrayList<AbstractAttribute>(element.getAttributes());
                this.filterOtherModelComponents(arrayList2, aXIModel);
                if (arrayList.size() == 0) {
                    ++n;
                }
                if (arrayList2.size() == 0) {
                    ++n2;
                }
                if (bl2) continue;
                for (AbstractElement abstractElement : arrayList) {
                    ArrayList<AbstractElement> arrayList3 = new ArrayList<AbstractElement>(abstractElement.getChildElements());
                    this.filterOtherModelComponents(arrayList3, aXIModel);
                    ArrayList<AbstractAttribute> arrayList4 = new ArrayList<AbstractAttribute>(abstractElement.getAttributes());
                    this.filterOtherModelComponents(arrayList4, aXIModel);
                    if (arrayList3.size() <= 0 && arrayList4.size() <= 0) continue;
                    bl2 = true;
                    continue block0;
                }
            }
            boolean bl3 = n > 0 && n == n3;
            boolean bl4 = bl = n2 > 0 && n2 == n3;
            if (bl3 && pattern2 == SchemaGenerator.Pattern.SALAMI_SLICE) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS;
            }
            if (bl && bl3 && (pattern2 == SchemaGenerator.Pattern.GARDEN_OF_EDEN || pattern2 == SchemaGenerator.Pattern.RUSSIAN_DOLL)) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS_AND_ATTRIBUTES;
            }
            if (!bl2 && pattern2 == SchemaGenerator.Pattern.VENITIAN_BLIND) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_GRAND_CHILDREN;
            }
            if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE || pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
                return SchemaGeneratorFactory.TransformHint.WILL_REMOVE_GLOBAL_ELEMENTS;
            }
            return SchemaGeneratorFactory.TransformHint.WILL_REMOVE_GLOBAL_ELEMENTS_AND_TYPES;
        }
        return SchemaGeneratorFactory.TransformHint.OK;
    }

    private void filterOtherModelComponents(List list, AXIModel aXIModel) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < list.size(); ++n) {
            AXIComponent aXIComponent = (AXIComponent)list.get(n);
            if (SchemaGeneratorUtil.fromSameSchemaModel(aXIComponent.getPeer(), aXIModel.getSchemaModel())) continue;
            arrayList.add(new Integer(n));
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            list.remove((Integer)arrayList.get(n));
        }
    }

    @Override
    public void transformSchema(SchemaModel schemaModel, SchemaGenerator.Pattern pattern) throws IOException {
        DefaultSchemaGenerator defaultSchemaGenerator = null;
        if (pattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            defaultSchemaGenerator = new GardenOfEden(SchemaGenerator.Mode.TRANSFORM);
        } else if (pattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            defaultSchemaGenerator = new VenetianBlind(SchemaGenerator.Mode.TRANSFORM);
        } else if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            defaultSchemaGenerator = new SalamiSlice(SchemaGenerator.Mode.TRANSFORM);
        } else if (pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            defaultSchemaGenerator = new RussianDoll(SchemaGenerator.Mode.TRANSFORM);
        } else if (pattern == SchemaGenerator.Pattern.MIXED) {
            defaultSchemaGenerator = new MixedPattern(SchemaGenerator.Mode.TRANSFORM);
        }
        if (defaultSchemaGenerator != null) {
            ((SchemaGenerator)defaultSchemaGenerator).transformSchema(schemaModel);
        }
    }
}

