/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.util.ArrayList;
import nickyb.sqleonardo.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class QueryModel
implements Cloneable {
    private QueryExpression queryExpression;
    private ArrayList orderClause;
    private String schema;

    public QueryModel() {
        this(null);
    }

    public QueryModel(String schema) {
        this.schema = schema;
        this.queryExpression = new QueryExpression();
        this.orderClause = new ArrayList();
    }

    public Object clone() throws CloneNotSupportedException {
        QueryModel qm = (QueryModel)super.clone();
        qm.queryExpression = (QueryExpression)this.queryExpression.clone();
        qm.orderClause = (ArrayList)this.orderClause.clone();
        return qm;
    }

    public String getSchema() {
        return this.schema == null ? null : new String(this.schema);
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void addOrderByClause(QueryTokens.Sort token) {
        this.orderClause.add(token);
    }

    public QueryTokens.Sort[] getOrderByClause() {
        QueryTokens.Sort[] a = new QueryTokens.Sort[this.orderClause.size()];
        return this.orderClause.toArray(a);
    }

    public void removeOrderByClause(QueryTokens.Sort token) {
        this.orderClause.remove(token);
    }

    public QueryExpression getQueryExpression() {
        return this.queryExpression;
    }

    public void setQueryExpression(QueryExpression qe) {
        this.queryExpression = qe;
    }

    public String toString(boolean wrap) {
        String syntax = this.queryExpression.toString(wrap);
        if (this.orderClause.size() > 0) {
            syntax = syntax + (wrap ? (char)'\n' : ' ') + "ORDER BY" + (wrap ? (char)'\n' : ' ') + SQLFormatter.concat(this.getOrderByClause(), wrap);
        }
        return syntax;
    }

    public String toString() {
        return this.toString(false);
    }
}

