/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.DialogFilters;
import nickyb.sqleonardo.environment.ctrl.content.DialogFindReplace;
import nickyb.sqleonardo.environment.ctrl.content.DialogPreview;
import nickyb.sqleonardo.environment.ctrl.content.DialogStream;
import nickyb.sqleonardo.environment.ctrl.content.DialogUpdateCriteria;
import nickyb.sqleonardo.environment.ctrl.content.UpdateModel;
import nickyb.sqleonardo.environment.ctrl.define.TableMetaData;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;
import nickyb.sqleonardo.querybuilder.QueryModel;

public class ClientContent
extends MDIClient {
    public static final String DEFAULT_TITLE = "content";
    private ContentPane control;
    private JMenuItem[] m_actions;
    private Toolbar toolbar;
    private DialogFindReplace dlg;

    public ClientContent(TableMetaData tmd, boolean retrieve) {
        this(tmd.getHandlerKey(), tmd.createQueryModel(), tmd.createUpdateModel(), retrieve);
        if (!retrieve) {
            int i;
            for (i = 0; i < tmd.getColumns().size(); ++i) {
                String name = tmd.getColumnProperty(i, 3);
                String type = tmd.getColumnProperty(i, 4);
                this.control.getView().addColumn(name, Integer.valueOf(type));
            }
            this.control.getView().onTableChanged(false);
            for (i = 0; i < tmd.getColumns().size(); ++i) {
                String t = tmd.getColumnProperty(i, 3) + " : " + tmd.getColumnProperty(i, 5);
                t = t + (Integer.valueOf(tmd.getColumnProperty(i, 10)) == 1 ? "(null)" : "(not null)");
                this.control.getView().setToolTipText(i, t);
            }
            this.control.doRefreshStatus();
        }
    }

    public ClientContent(String keycah, QueryModel qmodel, UpdateModel umodel) {
        this(keycah, qmodel, umodel, true);
    }

    private ClientContent(String keycah, QueryModel qmodel, UpdateModel umodel, boolean retrieve) {
        super(DEFAULT_TITLE);
        this.setMaximizable(true);
        this.setResizable(true);
        this.control = new ContentPane(keycah, qmodel, umodel);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setDefaultCloseOperation(0);
        InternalFrameAdapter ifl = new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (ClientContent.this.dlg != null) {
                    ClientContent.this.dlg.setVisible(false);
                }
            }

            public void internalFrameClosing(InternalFrameEvent evt) {
                if (!ClientContent.this.control.isBusy() && !ClientContent.this.control.isReadOnly() && ClientContent.this.control.getView().getChanges().count() > 0) {
                    int option = JOptionPane.showConfirmDialog(Application.window, "do you want save changes?", "SQLeonardo", 1);
                    if (option == 0) {
                        ClientContent.this.control.getActionMap().get("changes-save").actionPerformed(null);
                    } else if (option != 1) {
                        return;
                    }
                }
                ClientContent.this.control.doStop();
                ClientContent.this.dispose();
            }
        };
        this.addInternalFrameListener(ifl);
        this.createToolbar();
        this.initMenuActions();
        if (retrieve) {
            this.control.doRetrieve();
        } else {
            this.control.doStop();
        }
    }

    private void createToolbar() {
        this.toolbar = new Toolbar(0);
        this.toolbar.add(this.control.getActionMap().get("changes-save"));
        this.toolbar.add(this.control.getActionMap().get("task-stop"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.control.getActionMap().get("record-insert"));
        this.toolbar.add(this.control.getActionMap().get("record-delete"));
        this.toolbar.addSeparator();
        this.toolbar.add(new ActionShowFilter());
        this.toolbar.add(new ActionShowFindReplace());
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        Action a = this.control.getActionMap().get("task-go");
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        this.m_actions = new JMenuItem[]{MDIMenubar.createItem(new ActionShowUpdateCriteria()), MDIMenubar.createItem(new ActionShowChanges()), null, MDIMenubar.createItem(new ActionShowExport()), MDIMenubar.createItem(new ActionShowImport()), null, MDIMenubar.createItem(this.control.getActionMap().get("task-go"))};
    }

    public final void dispose() {
        if (this.dlg != null) {
            this.dlg.dispose();
        }
        super.dispose();
    }

    public final ContentPane getControl() {
        return this.control;
    }

    protected String getMessage() {
        int rows = this.control.getView().getRowCount();
        if (rows == 0) {
            return null;
        }
        String first = this.control.getView().getValueAt(0, 0).toString();
        String last = this.control.getView().getValueAt(rows - 1, 0).toString();
        return "block " + this.control.getView().getBlock() + " of " + this.control.getView().getBlockCount() + " - record(s) " + first + " to " + last + " of " + this.control.getView().getFlatRowCount();
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    protected void setPreferences() {
    }

    private class ActionShowFindReplace
    extends AbstractAction {
        ActionShowFindReplace() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.012"));
            this.putValue("ShortDescription", "find/replace...");
            this.putValue("Name", "find/replace...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            if (ClientContent.this.dlg == null) {
                ClientContent.this.dlg = new DialogFindReplace(ClientContent.this.control);
            }
            ClientContent.this.dlg.setVisible(true);
        }
    }

    private class ActionShowFilter
    extends AbstractAction {
        ActionShowFilter() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.013"));
            this.putValue("ShortDescription", "filter");
            this.putValue("Name", "filter...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            new DialogFilters(ClientContent.this.control).setVisible(true);
        }
    }

    private class ActionShowExport
    extends AbstractAction {
        ActionShowExport() {
            this.putValue("Name", "export data...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            DialogStream.showExport(ClientContent.this.control);
        }
    }

    private class ActionShowImport
    extends AbstractAction {
        ActionShowImport() {
            this.putValue("Name", "import data...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            DialogStream.showImport(ClientContent.this.control);
        }
    }

    private class ActionShowChanges
    extends AbstractAction {
        ActionShowChanges() {
            super("show changes...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            if (ClientContent.this.control.getUpdateModel() != null && ClientContent.this.control.getUpdateModel().getRowIdentifierCount() > 0) {
                new DialogPreview(ClientContent.this.control).setVisible(true);
            } else {
                Application.alert("SQLeonardo", "No update criteria defined!");
            }
        }
    }

    private class ActionShowUpdateCriteria
    extends AbstractAction {
        ActionShowUpdateCriteria() {
            super("update criteria...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientContent.this.control.isBusy()) {
                return;
            }
            new DialogUpdateCriteria(ClientContent.this.control).setVisible(true);
        }
    }
}

