/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.define.TableMetaData;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public abstract class AbstractActionContent
extends AbstractAction {
    protected abstract void onActionPerformed(int var1, int var2);

    protected abstract TableMetaData getTableMetaData();

    protected final String getDefaultMessage(int records) {
        return this.getTableMetaData().getType() + " : '" + this.getTableMetaData() + "' contains " + NumberFormat.getInstance().format(records) + " record(s)";
    }

    protected int showConfirmDialog(int records) {
        String message = this.getDefaultMessage(records) + "\ndo you want continue?";
        return JOptionPane.showConfirmDialog(Application.window, message, this.getValue("Name").toString(), 0);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getTableMetaData() == null || this.getTableMetaData().getHandlerKey() == null) {
            return;
        }
        try {
            ConnectionHandler ch = ConnectionAssistant.getHandler(this.getTableMetaData().getHandlerKey());
            String identifierQuoteString = ConnectionAssistant.getHandler(this.getTableMetaData().getHandlerKey()).getObject("$identifierQuoteString").toString();
            Statement stmt = ch.get().createStatement();
            ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + SQLFormatter.ensureQuotes(this.getTableMetaData().toString(), identifierQuoteString, true));
            int records = rs.next() ? rs.getInt(1) : 0;
            rs.close();
            stmt.close();
            this.onActionPerformed(records, this.showConfirmDialog(records));
        }
        catch (SQLException sqle) {
            Application.println(sqle, true);
        }
    }
}

