/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.impl.DynamicDatasourceXmlaServlet;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDatasourceXmlaServletTest
extends TestCase {
    private static final String CATALOG_0_NAME = "FoodMart0";
    private static final String CATALOG_1_NAME = "FoodMart1";
    private static final String CATALOG_2_NAME = "FoodMart2";
    private static final String CATALOG_0_DEFINITION = "<Catalog name='FoodMart0'><Definition>Provider=mondrian;Jdbc=jdbc:odbc:MondrianFoodMart0;JdbcDrivers=sun.jdbc.odbc.JdbcOdbcDriver</Definition></Catalog>";
    private static final String CATALOG_0_UPDATED_DEFINITION = "<Catalog name='FoodMart0'><Definition>Provider=mondrian;Jdbc=jdbc:odbc:MondrianFoodMart0.0;JdbcDrivers=sun.jdbc.odbc.JdbcOdbcDriver</Definition></Catalog>";
    private static final String CATALOG_1_DEFINITION = "<Catalog name='FoodMart1'><Definition>Provider=mondrian;Jdbc=jdbc:odbc:MondrianFoodMart1;JdbcDrivers=sun.jdbc.odbc.JdbcOdbcDriver</Definition></Catalog>";
    private static final String CATALOG_2_DEFINITION = "<Catalog name='FoodMart2'><Definition>Provider=mondrian;Jdbc=jdbc:odbc:MondrianFoodMart2;JdbcDrivers=sun.jdbc.odbc.JdbcOdbcDriver</Definition></Catalog>";
    private static final String DATASOURCE_1_NAME = "DATASOURCENAME1";
    private static final String DATASOURCE_2_NAME = "DATASOURCENAME2";

    public void testFlushObsoleteCatalogsForNewCatalog() throws Exception {
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(CATALOG_0_DEFINITION, CATALOG_1_DEFINITION);
        xmlaServlet.flushObsoleteCatalogs(newDataSources);
        DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.flushCatalogList().isEmpty());
    }

    public void testFlushObsoleteCatalogsForUpdateCatalog() throws Exception {
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(CATALOG_0_UPDATED_DEFINITION);
        xmlaServlet.flushObsoleteCatalogs(newDataSources);
        DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.flushCatalogList().contains(CATALOG_0_NAME));
    }

    public void testFlushObsoleteCatalogsForUnchangedCatalog() throws Exception {
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(CATALOG_0_DEFINITION, CATALOG_1_DEFINITION);
        xmlaServlet.flushObsoleteCatalogs(newDataSources);
        DynamicDatasourceXmlaServletTest.assertFalse((boolean)xmlaServlet.flushCatalogList().contains(CATALOG_0_NAME));
    }

    public void testFlushObsoleteCatalogsForDeletedCatalog() throws Exception {
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(CATALOG_1_DEFINITION);
        xmlaServlet.flushObsoleteCatalogs(newDataSources);
        DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.flushCatalogList().contains(CATALOG_0_NAME));
    }

    public void testMergeDataSourcesForAlteringCatalogAcrossDataSources() throws Exception {
        HashMap<String, String[]> dsCatalog = new HashMap<String, String[]>();
        dsCatalog.put(DATASOURCE_1_NAME, new String[]{CATALOG_0_UPDATED_DEFINITION, CATALOG_1_DEFINITION});
        dsCatalog.put(DATASOURCE_2_NAME, new String[]{CATALOG_2_DEFINITION});
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(dsCatalog);
        xmlaServlet.flushObsoleteCatalogs(newDataSources);
        DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.flushCatalogList().contains(CATALOG_0_NAME));
    }

    public void testAreCatalogsEqual() throws Exception {
        DataSourcesConfig.DataSources newDataSources = this.getDataSources(CATALOG_0_DEFINITION, CATALOG_0_UPDATED_DEFINITION, CATALOG_1_DEFINITION, CATALOG_2_DEFINITION);
        DataSourcesConfig.DataSource datasource = newDataSources.dataSources[0];
        DataSourcesConfig.Catalog catalog0 = datasource.catalogs.catalogs[0];
        DataSourcesConfig.Catalog catalog0Updated = datasource.catalogs.catalogs[1];
        DataSourcesConfig.Catalog catalog1 = datasource.catalogs.catalogs[2];
        DataSourcesConfig.Catalog catalog2 = datasource.catalogs.catalogs[3];
        DynamicDatasourceXmlaServlet xmlaServlet = new DynamicDatasourceXmlaServlet();
        DynamicDatasourceXmlaServletTest.assertFalse((boolean)xmlaServlet.areCatalogsEqual(catalog0, catalog0Updated));
        DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.areCatalogsEqual(catalog0, catalog0));
        DynamicDatasourceXmlaServletTest.assertFalse((boolean)xmlaServlet.areCatalogsEqual(catalog1, catalog2));
    }

    private DataSourcesConfig.DataSources getDataSources(String ... catalogs) throws XOMException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put(DATASOURCE_1_NAME, catalogs);
        return this.getDataSources(hashMap);
    }

    private DataSourcesConfig.DataSources getDataSources(Map<String, String[]> dsCatalog) throws XOMException {
        StringBuilder ds = new StringBuilder();
        ds.append("<?xml version=\"1.0\"?>");
        ds.append("<DataSources>");
        for (Map.Entry<String, String[]> entry : dsCatalog.entrySet()) {
            String[] catalogs;
            String dsName = entry.getKey();
            ds.append("<DataSource> ");
            ds.append("  <DataSourceName>").append(dsName).append("</DataSourceName>");
            ds.append("       <DataSourceDescription>DATASOURCE_DESCRIPTION</DataSourceDescription>");
            ds.append("       <URL>http://localhost:8080/mondrian/xmla</URL>");
            ds.append("       <DataSourceInfo>Provider=mondrian;Jdbc=jdbc:oracle:thin:foodmart/foodmart@//marmalade.hydromatic.net:1521/XE;JdbcUser=foodmart;JdbcPassword=foodmart;JdbcDrivers=oracle.jdbc.OracleDriver;Catalog=/WEB-INF/queries/FoodMart.xml</DataSourceInfo>");
            ds.append("       <ProviderName>Mondrian</ProviderName>");
            ds.append("       <ProviderType>MDP</ProviderType>");
            ds.append("       <AuthenticationMode>Unauthenticated</AuthenticationMode>");
            ds.append("       <Catalogs>");
            for (String catalog : catalogs = entry.getValue()) {
                ds.append(catalog);
            }
            ds.append("       </Catalogs>");
            ds.append("</DataSource>");
        }
        ds.append("</DataSources>");
        Parser xmlParser = XOMUtil.createDefaultParser();
        DOMWrapper def = xmlParser.parse(ds.toString());
        return new DataSourcesConfig.DataSources(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReloadDataSources() throws Exception {
        MockDynamicDatasourceXmlaServlet xmlaServlet = new MockDynamicDatasourceXmlaServlet();
        DataSourcesConfig.DataSources ds1 = this.getDataSources(CATALOG_0_DEFINITION, CATALOG_1_DEFINITION);
        DataSourcesConfig.DataSources ds2 = this.getDataSources(CATALOG_1_DEFINITION, CATALOG_2_DEFINITION);
        File dsFile = null;
        try {
            dsFile = File.createTempFile(Long.toString(System.currentTimeMillis()), null);
            FileOutputStream out = new FileOutputStream(dsFile);
            ((OutputStream)out).write(ds1.toXML().getBytes());
            out.flush();
            xmlaServlet.parseDataSourcesUrl(dsFile.toURL());
            out = new FileOutputStream(dsFile);
            ((OutputStream)out).write(ds2.toXML().getBytes());
            out.flush();
            xmlaServlet.reloadDataSources();
            DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_1_NAME));
            DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_2_NAME));
            DynamicDatasourceXmlaServletTest.assertFalse((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_0_NAME));
            out = new FileOutputStream(dsFile);
            ((OutputStream)out).write(ds1.toXML().getBytes());
            out.flush();
            xmlaServlet.reloadDataSources();
            DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_0_NAME));
            DynamicDatasourceXmlaServletTest.assertTrue((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_1_NAME));
            DynamicDatasourceXmlaServletTest.assertFalse((boolean)xmlaServlet.containsCatalog(DATASOURCE_1_NAME, CATALOG_2_NAME));
        }
        finally {
            if (dsFile != null) {
                dsFile.delete();
            }
        }
    }

    class MockDynamicDatasourceXmlaServlet
    extends DynamicDatasourceXmlaServlet {
        private List<String> flushCatalogList = new Vector<String>();

        public MockDynamicDatasourceXmlaServlet() throws XOMException {
            this.dataSources = DynamicDatasourceXmlaServletTest.this.getDataSources(new String[]{DynamicDatasourceXmlaServletTest.CATALOG_0_DEFINITION});
        }

        public boolean containsCatalog(String datasourceName, String catalogName) {
            return this.locateCatalog(datasourceName, catalogName) != null;
        }

        public DataSourcesConfig.Catalog locateCatalog(String datasourceName, String catalogName) {
            for (DataSourcesConfig.DataSource ds : this.dataSources.dataSources) {
                if (!ds.name.equals(datasourceName)) continue;
                for (DataSourcesConfig.Catalog catalog : ds.catalogs.catalogs) {
                    if (!catalog.name.equals(catalogName)) continue;
                    return catalog;
                }
            }
            return null;
        }

        void flushCatalog(String catalogName) {
            this.flushCatalogList.add(catalogName);
        }

        public List flushCatalogList() {
            return this.flushCatalogList;
        }
    }
}

