/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import mondrian.test.TestContext;
import mondrian.util.PrimeFinder;

public class PrimeFinderTest
extends TestCase {
    private void assertStatistics(int from, int to, String expected) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        PrimeFinder.statistics(from, to, pw);
        pw.flush();
        TestContext.assertEqualsVerbose(expected, sw.toString());
    }

    public void testOne() {
        this.assertStatistics(1000, 1000, TestContext.fold("new maxdev @1000@dev=0.039\nStatistics for [1000,1000] are as follows\nmeanDeviation = 3.9 %\nmaxDeviation = 3.9 %\n"));
    }

    public void testTwo() {
        this.assertStatistics(200, 1000, TestContext.fold("new maxdev @200@dev=0.385\nStatistics for [200,1000] are as follows\nmeanDeviation = 6.589286 %\nmaxDeviation = 38.5 %\n"));
    }

    public void testThree() {
        this.assertStatistics(16, 1000, TestContext.fold("new maxdev @16@dev=0.0625\nnew maxdev @18@dev=0.2777777777777778\nnew maxdev @24@dev=0.2916666666666667\nnew maxdev @48@dev=0.3958333333333333\nnew maxdev @98@dev=0.3979591836734694\nnew maxdev @198@dev=0.398989898989899\nStatistics for [16,1000] are as follows\nmeanDeviation = 7.374975 %\nmaxDeviation = 39.898987 %\n"));
    }

    public void _testFour() {
        this.assertStatistics(1000, Integer.MAX_VALUE, "");
    }
}

