/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.comp;

import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Assert;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Cell;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.test.TestContext;
import mondrian.test.comp.XMLUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultComparator {
    private final Element xmlRoot;
    private final Result result;

    public ResultComparator(Element xmlRoot, Result result) {
        this.xmlRoot = xmlRoot;
        this.result = result;
    }

    public void compareResults() {
        this.compareSlicers();
        this.compareColumns();
        this.compareRows();
        this.compareData();
    }

    private void compareSlicers() {
        NodeList slicerList = this.xmlRoot.getElementsByTagName("slicer");
        Cube cube = this.result.getQuery().getCube();
        Dimension[] dims = cube.getDimensions();
        HashSet<String> defaultDimMembers = new HashSet<String>();
        for (Dimension dim : dims) {
            String uniqueName = dim.getHierarchies()[0].getDefaultMember().getUniqueName();
            defaultDimMembers.add(uniqueName);
        }
        Axis slicerAxis = this.result.getSlicerAxis();
        List members = slicerAxis.getPositions().get(0);
        Element slicerTuple = (Element)slicerList.item(0);
        if (slicerTuple == null) {
            this._assertEquals("Expected no slicers", 0, members.size());
            return;
        }
        Element tuples = (Element)slicerTuple.getElementsByTagName("tuples").item(0);
        Element tuple = (Element)tuples.getElementsByTagName("tuple").item(0);
        NodeList expectedTuple = tuple.getElementsByTagName("member");
        int numMembers = expectedTuple.getLength();
        int seenMembers = 0;
        for (int idx = 0; idx < numMembers; ++idx) {
            String expectedMemberName = expectedTuple.item(idx).getFirstChild().getNodeValue();
            if (this.resultMembersContainsExpected(expectedMemberName, members)) {
                ++seenMembers;
                continue;
            }
            if (defaultDimMembers.contains(expectedMemberName)) continue;
            Assert.fail((String)("Missing slicer: " + expectedMemberName));
        }
        this._assertEquals("The query returned more slicer members than were expected", members.size(), seenMembers);
    }

    private boolean resultMembersContainsExpected(String expectedMemberName, List<Member> members) {
        for (Member member : members) {
            if (!member.getUniqueName().equals(expectedMemberName)) continue;
            return true;
        }
        return false;
    }

    private void compareColumns() {
        Axis[] axes = this.result.getAxes();
        NodeList columnList = this.xmlRoot.getElementsByTagName("columns");
        if (axes.length >= 1) {
            this.compareTuples("Column", columnList, axes[0].getPositions());
        } else {
            Assert.assertTrue((String)"Must be no columns", (columnList.getLength() == 0 ? 1 : 0) != 0);
        }
    }

    private void compareRows() {
        Axis[] axes = this.result.getAxes();
        NodeList rowList = this.xmlRoot.getElementsByTagName("rows");
        switch (axes.length) {
            case 0: 
            case 1: {
                Assert.assertTrue((String)"Must be no rows", (rowList.getLength() == 0 ? 1 : 0) != 0);
                break;
            }
            case 2: {
                this.compareTuples("Row", rowList, axes[1].getPositions());
                break;
            }
            default: {
                Assert.fail((String)("Too many axes returned. Expected 0, 1 or 2 but got " + axes.length));
            }
        }
    }

    private void _failNotEquals(String message, Object expected, Object actual) {
        message = message != null ? message + "; " : "";
        message = message + "; expected=" + expected + "; actual=" + actual + Util.nl + "Query: " + Util.unparse(this.result.getQuery()) + Util.nl;
        TestContext.assertEqualsVerbose(XMLUtility.toString(this.xmlRoot), this.toString(this.result), false, message);
    }

    private String toString(Result result) {
        Element element = this.toXml(result);
        return XMLUtility.toString(element);
    }

    private Element toXml(Result result) {
        DocumentBuilder db = XMLUtility.createDomParser(false, true, false, new XMLUtility.UtilityErrorHandler());
        Document document = db.newDocument();
        Element dataResultXml = document.createElement("dataResult");
        this.slicerAxisToXml(document, dataResultXml, result);
        Axis[] axes = result.getAxes();
        for (int i = 0; i < axes.length; ++i) {
            Axis axis = axes[i];
            String axisName = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(i).name().toLowerCase();
            this.axisToXml(document, dataResultXml, axis, axisName);
        }
        Element dataXml = document.createElement("data");
        dataResultXml.appendChild(dataXml);
        int axisCount = result.getAxes().length;
        int[] pos = new int[axisCount];
        this.cellsToXml(document, result, dataXml, pos, axisCount - 1);
        return dataResultXml;
    }

    private void cellsToXml(Document document, Result result, Element parentXml, int[] pos, int axisOrdinal) {
        Axis axis = result.getAxes()[axisOrdinal];
        for (int i = 0; i < axis.getPositions().size(); ++i) {
            pos[axisOrdinal] = i;
            if (axisOrdinal == 0) {
                Cell cell = result.getCell(pos);
                Element cellXml = document.createElement("cell");
                parentXml.appendChild(cellXml);
                Text textXml = document.createTextNode(String.valueOf(cell.getValue()));
                cellXml.appendChild(textXml);
                continue;
            }
            Element drowXml = document.createElement("drow");
            parentXml.appendChild(drowXml);
            this.cellsToXml(document, result, drowXml, pos, axisOrdinal - 1);
        }
    }

    private void slicerAxisToXml(Document document, Element dataResultXml, Result result) {
        Dimension[] dimensions = result.getQuery().getCube().getDimensions();
        String axisName = "slicer";
        Axis slicerAxis = result.getSlicerAxis();
        Element axisXml = document.createElement(axisName);
        dataResultXml.appendChild(axisXml);
        Element dimensionsXml = document.createElement("dimensions");
        axisXml.appendChild(dimensionsXml);
        Element tuplesXml = document.createElement("tuples");
        axisXml.appendChild(tuplesXml);
        Element tupleXml = document.createElement("tuple");
        tuplesXml.appendChild(tupleXml);
        for (Dimension dimension : dimensions) {
            Member member = this.findSlicerAxisMember(result, dimension);
            if (member == null) continue;
            Element dimXml = document.createElement("dim");
            dimensionsXml.appendChild(dimXml);
            Text textXml = document.createTextNode(member.getDimension().getUniqueName());
            dimXml.appendChild(textXml);
            Element memberXml = document.createElement("member");
            tupleXml.appendChild(memberXml);
            Text memberTextXml = document.createTextNode(member.getUniqueName());
            memberXml.appendChild(memberTextXml);
        }
    }

    private Member findSlicerAxisMember(Result result, Dimension dimension) {
        Axis[] axes;
        Axis slicerAxis = result.getSlicerAxis();
        if (slicerAxis != null && slicerAxis.getPositions().size() == 1) {
            List members = slicerAxis.getPositions().get(0);
            for (Member member : members) {
                if (member.getDimension() != dimension) continue;
                return member;
            }
        }
        for (Axis axis : axes = result.getAxes()) {
            if (axis.getPositions().size() <= 0) continue;
            List members = axis.getPositions().get(0);
            for (Member member : members) {
                if (member.getDimension() != dimension) continue;
                return null;
            }
        }
        return dimension.getHierarchies()[0].getDefaultMember();
    }

    private void axisToXml(Document document, Element dataResultXml, Axis axis, String axisName) {
        Element axisXml = document.createElement(axisName);
        dataResultXml.appendChild(axisXml);
        if (axis.getPositions().size() > 0) {
            Element dimensionsXml = document.createElement("dimensions");
            axisXml.appendChild(dimensionsXml);
            Position position0 = axis.getPositions().get(0);
            for (Member member : position0) {
                Element dimXml = document.createElement("dim");
                dimensionsXml.appendChild(dimXml);
                Text textXml = document.createTextNode(member.getDimension().getUniqueName());
                dimXml.appendChild(textXml);
            }
            Element tuplesXml = document.createElement("tuples");
            axisXml.appendChild(tuplesXml);
            for (Position position : axis.getPositions()) {
                Element tupleXml = document.createElement("tuple");
                tuplesXml.appendChild(tupleXml);
                for (Member member : position) {
                    Element memberXml = document.createElement("member");
                    tupleXml.appendChild(memberXml);
                    Text textXml = document.createTextNode(member.getUniqueName());
                    memberXml.appendChild(textXml);
                }
            }
        }
    }

    private void _assertEquals(String message, int expected, int actual) {
        if (expected != actual) {
            this._failNotEquals(message, expected, actual);
        }
    }

    private void _assertEquals(String message, Object expected, Object actual) {
        if (expected == null ? actual == null : expected.equals(actual)) {
            return;
        }
        this._failNotEquals(message, expected, actual);
    }

    private void _assertEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                this._failNotEquals(message, expected, actual);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            this._failNotEquals(message, expected, actual);
        }
    }

    private void compareTuples(String message, NodeList axisValues, List<Position> resultTuples) {
        NodeList expectedTuples = null;
        NodeList expectedDims = null;
        if (axisValues.getLength() != 0) {
            Element axisNode = (Element)axisValues.item(0);
            Element dims = (Element)axisNode.getElementsByTagName("dimensions").item(0);
            expectedDims = dims.getElementsByTagName("dim");
            Element tuples = (Element)axisNode.getElementsByTagName("tuples").item(0);
            expectedTuples = tuples.getElementsByTagName("tuple");
        }
        int numExpectedTuples = expectedTuples == null ? 0 : expectedTuples.getLength();
        this._assertEquals(message + " number of tuples", numExpectedTuples, resultTuples.size());
        if (numExpectedTuples != 0) {
            this._assertEquals("Invalid test case. Number of dimensions does not match tuple lengths", expectedDims.getLength(), ((Element)expectedTuples.item(0)).getElementsByTagName("member").getLength());
        }
        for (int idx = 0; idx < numExpectedTuples; ++idx) {
            this.compareTuple(message + " tuple " + idx, (Element)expectedTuples.item(idx), resultTuples.get(idx));
        }
    }

    private void compareTuple(String message, Element expectedTuple, Position resultTuple) {
        NodeList expectedMembers = expectedTuple.getElementsByTagName("member");
        int numExpectedMembers = expectedMembers.getLength();
        this._assertEquals(message + " number of members", numExpectedMembers, resultTuple.size());
        for (int idx = 0; idx < numExpectedMembers; ++idx) {
            String resultName = ((Member)resultTuple.get(idx)).getUniqueName();
            String expectedName = expectedMembers.item(idx).getFirstChild().getNodeValue();
            this._assertEquals(message + " member " + idx, expectedName, resultName);
        }
    }

    private void compareData() {
        Element dataElement = (Element)this.xmlRoot.getElementsByTagName("data").item(0);
        NodeList expectedRows = dataElement.getElementsByTagName("drow");
        Axis[] axes = this.result.getAxes();
        int numAxes = axes.length;
        switch (numAxes) {
            case 0: {
                this.compareZeroAxes(expectedRows);
                break;
            }
            case 1: {
                this.compareColumnsOnly(expectedRows, axes);
                break;
            }
            case 2: {
                this.compareRowsAndColumns(expectedRows, axes);
            }
        }
    }

    private void compareZeroAxes(NodeList expectedRow) {
        int numRows = expectedRow.getLength();
        this._assertEquals("Unexpected number of rows", 1, numRows);
        NodeList cellList = ((Element)expectedRow.item(0)).getElementsByTagName("cell");
        int numColumns = cellList.getLength();
        this._assertEquals("Unexpected number of columns", numColumns, 1);
        int[] coord = new int[]{};
        Cell cell = this.result.getCell(coord);
        String expectedValue = cellList.item(0).getFirstChild().getNodeValue();
        this.compareCell(coord, expectedValue, cell);
    }

    private void compareColumnsOnly(NodeList expectedRow, Axis[] axes) {
        int numRows = expectedRow.getLength();
        this._assertEquals("Unexpected number of rows", 1, numRows);
        NodeList cellList = ((Element)expectedRow.item(0)).getElementsByTagName("cell");
        int numColumns = cellList.getLength();
        this._assertEquals("Unexpected number of columns", numColumns, axes[0].getPositions().size());
        int[] coord = new int[1];
        for (int colIdx = 0; colIdx < numColumns; ++colIdx) {
            coord[0] = colIdx;
            Cell cell = this.result.getCell(coord);
            String expectedValue = cellList.item(colIdx).getFirstChild().getNodeValue();
            this.compareCell(coord, expectedValue, cell);
        }
    }

    private void compareRowsAndColumns(NodeList expectedRows, Axis[] axes) {
        int numRows = expectedRows.getLength();
        int[] coord = new int[2];
        this._assertEquals("Number of row tuples must match", numRows, axes[1].getPositions().size());
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            Element drow = (Element)expectedRows.item(rowIdx);
            NodeList cellList = drow.getElementsByTagName("cell");
            if (rowIdx == 0) {
                this._assertEquals("Number of data columns: ", cellList.getLength(), axes[0].getPositions().size());
            }
            coord[1] = rowIdx;
            for (int colIdx = 0; colIdx < axes[0].getPositions().size(); ++colIdx) {
                coord[0] = colIdx;
                Cell cell = this.result.getCell(coord);
                String expectedValue = cellList.item(colIdx).getFirstChild().getNodeValue();
                this.compareCell(coord, expectedValue, cell);
            }
        }
    }

    private void compareCell(int[] coord, String expectedValue, Cell cell) {
        if (expectedValue.equalsIgnoreCase("#Missing")) {
            if (!cell.isNull()) {
                this._failNotEquals(this.getErrorMessage("Expected missing value but got " + cell.getValue() + " at ", coord), null, null);
            }
        } else if (cell.getValue() instanceof Number) {
            Number cellValue = (Number)cell.getValue();
            double expectedDouble = Double.parseDouble(expectedValue);
            this._assertEquals(this.getErrorMessage("Values don't match at ", coord), expectedDouble, cellValue.doubleValue(), 0.001);
        } else {
            this._assertEquals(this.getErrorMessage("Values don't match at ", coord), expectedValue, cell.getValue());
        }
    }

    private String getErrorMessage(String s, int[] coord) {
        StringBuilder errorAddr = new StringBuilder();
        errorAddr.append(s);
        errorAddr.append(" (");
        for (int idx = 0; idx < coord.length; ++idx) {
            if (idx != 0) {
                errorAddr.append(", ");
            }
            errorAddr.append(coord[idx]);
        }
        errorAddr.append(')');
        return errorAddr.toString();
    }
}

