/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Date;
import java.util.regex.Pattern;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Result;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class UdfTest
extends FoodMartTestCase {
    private final TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"PlusOne\" className=\"" + PlusOneUdf.class.getName() + "\"/>" + nl, null);

    public UdfTest() {
    }

    public UdfTest(String name) {
        super(name);
    }

    public TestContext getTestContext() {
        return this.tc;
    }

    public void testSanity() {
        this.assertQueryReturns("SELECT {[Measures].[Store Sqft]} ON COLUMNS, {[Store Type]} ON ROWS FROM [Store]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Store Sqft]}" + nl + "Axis #2:" + nl + "{[Store Type].[All Store Types]}" + nl + "Row #0: 571,596" + nl);
    }

    public void testFun() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Sqft Plus One] AS 'PlusOne([Measures].[Store Sqft])'" + nl + "SELECT {[Measures].[Sqft Plus One]} ON COLUMNS, " + nl + "  {[Store Type].children} ON ROWS " + nl + "FROM [Store]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Sqft Plus One]}" + nl + "Axis #2:" + nl + "{[Store Type].[All Store Types].[Deluxe Supermarket]}" + nl + "{[Store Type].[All Store Types].[Gourmet Supermarket]}" + nl + "{[Store Type].[All Store Types].[HeadQuarters]}" + nl + "{[Store Type].[All Store Types].[Mid-Size Grocery]}" + nl + "{[Store Type].[All Store Types].[Small Grocery]}" + nl + "{[Store Type].[All Store Types].[Supermarket]}" + nl + "Row #0: 146,046" + nl + "Row #1: 47,448" + nl + "Row #2: " + nl + "Row #3: 109,344" + nl + "Row #4: 75,282" + nl + "Row #5: 193,481" + nl);
    }

    public void testLastNonEmpty() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Last Unit Sales] AS " + nl + " '([Measures].[Unit Sales], " + nl + "   LastNonEmpty(Descendants([Time]), [Measures].[Unit Sales]))'" + nl + "SELECT {[Measures].[Last Unit Sales]} ON COLUMNS," + nl + " CrossJoin(" + nl + "  {[Time].[1997], [Time].[1997].[Q1], [Time].[1997].[Q1].Children}," + nl + "  {[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].children}) ON ROWS" + nl + "FROM [Sales]" + nl + "WHERE ([Store].[All Stores].[USA].[OR].[Portland].[Store 11])", UdfTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\nAxis #1:\n{[Measures].[Last Unit Sales]}\nAxis #2:\n{[Time].[1997], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Time].[1997], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Time].[1997], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Time].[1997], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Time].[1997], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\n{[Time].[1997].[Q1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Time].[1997].[Q1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Time].[1997].[Q1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Time].[1997].[Q1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Time].[1997].[Q1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\n{[Time].[1997].[Q1].[1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Time].[1997].[Q1].[1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Time].[1997].[Q1].[1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Time].[1997].[Q1].[1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Time].[1997].[Q1].[1], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\n{[Time].[1997].[Q1].[2], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Time].[1997].[Q1].[2], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Time].[1997].[Q1].[2], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Time].[1997].[Q1].[2], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Time].[1997].[Q1].[2], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\n{[Time].[1997].[Q1].[3], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Time].[1997].[Q1].[3], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Time].[1997].[Q1].[3], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Time].[1997].[Q1].[3], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Time].[1997].[Q1].[3], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\nRow #0: 2\nRow #1: 7\nRow #2: 6\nRow #3: 7\nRow #4: 4\nRow #5: 3\nRow #6: 4\nRow #7: 3\nRow #8: 4\nRow #9: 2\nRow #10: \nRow #11: 4\nRow #12: \nRow #13: 2\nRow #14: \nRow #15: \nRow #16: 2\nRow #17: \nRow #18: 4\nRow #19: \nRow #20: 3\nRow #21: 4\nRow #22: 3\nRow #23: 4\nRow #24: 2\n"));
    }

    public void testLastNonEmptyBig() {
        this.assertQueryReturns("with\n     member\n     [Measures].[Last Sale] as ([Measures].[Unit Sales],\n         LastNonEmpty(Descendants([Time].CurrentMember, [Time].[Month]),\n         [Measures].[Unit Sales]))\nselect\n     NON EMPTY {[Measures].[Last Sale]} ON columns,\n     NON EMPTY Order([Store].[All Stores].Children,\n         [Measures].[Last Sale], DESC) ON rows\nfrom [Sales]\nwhere [Time].LastSibling", UdfTest.fold("Axis #0:\n{[Time].[1998]}\nAxis #1:\nAxis #2:\n"));
    }

    public void testBadFun() {
        TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"BadPlusOne\" className=\"" + BadPlusOneUdf.class.getName() + "\"/>" + nl, null);
        try {
            tc.executeQuery("SELECT {} ON COLUMNS FROM [Sales]");
            UdfTest.fail((String)"Expected exception");
        }
        catch (Exception e) {
            String s = e.getMessage();
            UdfTest.assertEquals((String)"Mondrian Error:Internal error: Invalid user-defined function 'BadPlusOne': return type is null", (String)s);
        }
    }

    public void testComplexFun() {
        this.assertQueryReturns("WITH MEMBER [Measures].[InverseNormal] AS 'InverseNormal([Measures].[Grocery Sqft] / [Measures].[Store Sqft])', FORMAT_STRING = \"0.000\"" + nl + "SELECT {[Measures].[InverseNormal]} ON COLUMNS, " + nl + "  {[Store Type].children} ON ROWS " + nl + "FROM [Store]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[InverseNormal]}" + nl + "Axis #2:" + nl + "{[Store Type].[All Store Types].[Deluxe Supermarket]}" + nl + "{[Store Type].[All Store Types].[Gourmet Supermarket]}" + nl + "{[Store Type].[All Store Types].[HeadQuarters]}" + nl + "{[Store Type].[All Store Types].[Mid-Size Grocery]}" + nl + "{[Store Type].[All Store Types].[Small Grocery]}" + nl + "{[Store Type].[All Store Types].[Supermarket]}" + nl + "Row #0: 0.467" + nl + "Row #1: 0.463" + nl + "Row #2: " + nl + "Row #3: 0.625" + nl + "Row #4: 0.521" + nl + "Row #5: 0.504" + nl);
    }

    public void testException() {
        Result result = this.executeQuery("WITH MEMBER [Measures].[InverseNormal]  AS 'InverseNormal([Measures].[Store Sqft] / [Measures].[Grocery Sqft])', FORMAT_STRING = \"0.000000\"" + nl + "SELECT {[Measures].[InverseNormal]} ON COLUMNS, " + nl + "  {[Store Type].children} ON ROWS " + nl + "FROM [Store]");
        Axis rowAxis = result.getAxes()[0];
        UdfTest.assertTrue((rowAxis.getPositions().size() == 1 ? 1 : 0) != 0);
        Axis colAxis = result.getAxes()[1];
        UdfTest.assertTrue((colAxis.getPositions().size() == 6 ? 1 : 0) != 0);
        Cell cell = result.getCell(new int[]{0, 0});
        UdfTest.assertTrue((boolean)cell.isError());
        this.getTestContext().assertMatchesVerbose(Pattern.compile(".*Invalid value for inverse normal distribution: 1.4708.*"), cell.getValue().toString());
        cell = result.getCell(new int[]{0, 5});
        UdfTest.assertTrue((boolean)cell.isError());
        this.getTestContext().assertMatchesVerbose(Pattern.compile(".*Invalid value for inverse normal distribution: 1.4435.*"), cell.getValue().toString());
    }

    public void testCurrentDateString() {
        String actual = this.executeExpr("CurrentDateString(\"Ddd mmm dd yyyy\")");
        Date currDate = new Date();
        String dateString = currDate.toString();
        String expected = dateString.substring(0, 11) + dateString.substring(dateString.length() - 4);
        UdfTest.assertEquals((String)expected, (String)actual);
    }

    public void testCurrentDateMemberBefore() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\", BEFORE)} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1998].[Q4].[12]}\nRow #0: \n"));
    }

    public void testCurrentDateMemberBeforeUsingQuotes() {
        this.assertAxisReturns("CurrentDateMember([Time], '\"[Time].[\"yyyy\"].[Q\"q\"].[\"m\"]\"', BEFORE)", "[Time].[1998].[Q4].[12]");
    }

    public void testCurrentDateMemberAfter() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\", AFTER)} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testCurrentDateMemberExact() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\", EXACT).lag(1)} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testCurrentDateMemberNoFindArg() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\")} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testCurrentDateMemberHierarchy() {
        String query = MondrianProperties.instance().SsasCompatibleNaming.get() ? "SELECT { CurrentDateMember([Time.Weekly], \"[Ti\\me\\.Weekl\\y]\\.[All Weekl\\y\\s]\\.[yyyy]\\.[ww]\", BEFORE)} ON COLUMNS FROM [Sales]" : "SELECT { CurrentDateMember([Time.Weekly], \"[Ti\\me\\.Weekl\\y]\\.[All Ti\\me\\.Weekl\\y\\s]\\.[yyyy]\\.[ww]\", BEFORE)} ON COLUMNS FROM [Sales]";
        this.assertQueryReturns(query, UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[Weekly].[All Weeklys].[1998].[52]}\nRow #0: \n"));
    }

    public void testCurrentDateMemberHierarchyNullReturn() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time.Weekly], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\")} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testCurrentDateMemberRealAfter() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[1996]\\.[Q4]\", after)} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1]}\nRow #0: 66,291\n"));
    }

    public void testCurrentDateMemberRealExact1() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[1997]\")} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\nRow #0: 266,773\n"));
    }

    public void testCurrentDateMemberRealExact2() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[1997]\\.[Q2]\\.[5]\")} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q2].[5]}\nRow #0: 21,081\n"));
    }

    public void testCurrentDateMemberPrev() {
        this.assertQueryReturns("SELECT { CurrentDateMember([Time], \"[Ti\\me]\\.[yyyy]\\.[Qq]\\.[m]\", BEFORE).PrevMember} ON COLUMNS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1998].[Q4].[11]}\nRow #0: \n"));
    }

    public void testCurrentDateLag() {
        this.assertQueryReturns("SELECT\n    { [Measures].[Unit Sales] } ON COLUMNS,\n    { CurrentDateMember([Time], '[\"Time\"]\\.[yyyy]\\.[\"Q\"q]\\.[m]', BEFORE).Lag(3) :       CurrentDateMember([Time], '[\"Time\"]\\.[yyyy]\\.[\"Q\"q]\\.[m]', BEFORE) } ON ROWS\nFROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1998].[Q3].[9]}\n{[Time].[1998].[Q4].[10]}\n{[Time].[1998].[Q4].[11]}\n{[Time].[1998].[Q4].[12]}\nRow #0: \nRow #1: \nRow #2: \nRow #3: \n"));
    }

    public void testMatches() {
        this.assertQueryReturns("SELECT {[Measures].[Org Salary]} ON COLUMNS, Filter({[Employees].MEMBERS}, [Employees].CurrentMember.Name MATCHES '(?i)sam.*') ON ROWS FROM [HR]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck].[Samuel Johnson]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Jose Bernard].[Mary Hunt].[Bonnie Bruno].[Sam Warren]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Charles Macaluso].[Barbara Wallin].[Michael Suggs].[Sam Adair]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lois Wood].[Dell Gras].[Kristine Aldred].[Sam Zeller]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Cody Goldey].[Shanay Steelman].[Neal Hasty].[Sam Wheeler]}\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Brenda Blumberg].[Wayne Banack].[Samuel Agcaoili]}\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Jonathan Murraiin].[James Thompson].[Samantha Weller]}\nRow #0: $40.62\nRow #1: $40.31\nRow #2: $75.60\nRow #3: $40.35\nRow #4: $47.52\nRow #5: \nRow #6: \n"));
    }

    public void testNotMatches() {
        this.assertQueryReturns("SELECT {[Measures].[Store Sales]} ON COLUMNS, Filter({[Store Type].MEMBERS}, [Store Type].CurrentMember.Name NOT MATCHES '.*Grocery.*') ON ROWS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[HeadQuarters]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 565,238.13\nRow #1: 162,062.24\nRow #2: 45,750.24\nRow #3: \nRow #4: 319,210.04\n"));
    }

    public void testIn() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS, FILTER([Product].[Product Family].MEMBERS, [Product].[Product Family].CurrentMember IN {[Product].[All Products].firstChild, [Product].[All Products].lastChild}) ON ROWS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 24,597\nRow #1: 50,236\n"));
    }

    public void testNotIn() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS, FILTER([Product].[Product Family].MEMBERS, [Product].[Product Family].CurrentMember NOT IN {[Product].[All Products].firstChild, [Product].[All Products].lastChild}) ON ROWS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food]}\nRow #0: 191,940\n"));
    }

    public void testChildMemberIn() {
        this.assertQueryReturns("SELECT {[Measures].[Store Sales]} ON COLUMNS, {[Store].[Store Name].MEMBERS} ON ROWS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[Canada].[BC].[Vancouver].[Store 19]}\n{[Store].[All Stores].[Canada].[BC].[Victoria].[Store 20]}\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]}\n{[Store].[All Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]}\n{[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]}\n{[Store].[All Stores].[Mexico].[Veracruz].[Orizaba].[Store 10]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 12]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 18]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: \nRow #1: \nRow #2: \nRow #3: \nRow #4: \nRow #5: \nRow #6: \nRow #7: \nRow #8: \nRow #9: \nRow #10: \nRow #11: \nRow #12: 45,750.24\nRow #13: 54,545.28\nRow #14: 54,431.14\nRow #15: 4,441.18\nRow #16: 55,058.79\nRow #17: 87,218.28\nRow #18: 4,739.23\nRow #19: 52,896.30\nRow #20: 52,644.07\nRow #21: 49,634.46\nRow #22: 74,843.96\nRow #23: 4,705.97\nRow #24: 24,329.23\n"));
        this.assertQueryReturns("SELECT {[Measures].[Store Sales]} ON COLUMNS, Filter({[Store].[Store Name].MEMBERS}, [Store].[Store Name].CurrentMember IN {[Store].[All Stores].[Mexico], [Store].[All Stores].[USA]}) ON ROWS FROM [Sales]", UdfTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n"));
    }

    public void testNonGuessableReturnType() {
        TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"StringMult\" className=\"" + StringMultUdf.class.getName() + "\"/>" + nl, null);
        tc.assertExprReturns("StringMult(5, 'foo') || 'bar'", "foofoofoofoofoobar");
    }

    public void testAnotherMemberFun() {
        TestContext tc = TestContext.create(null, null, null, null, "<UserDefinedFunction name=\"PlusOne\" className=\"" + PlusOneUdf.class.getName() + "\"/>" + nl + "<UserDefinedFunction name=\"AnotherMemberError\" className=\"" + AnotherMemberErrorUdf.class.getName() + "\"/>", null);
        tc.assertQueryReturns("WITH MEMBER [Measures].[Test] AS '([Measures].[Store Sales],[Product].[Food],AnotherMemberError([Product].[Drink],[Time]))'" + nl + "SELECT {[Measures].[Test]} ON COLUMNS, " + nl + "  {[Customers].DefaultMember} ON ROWS " + nl + "FROM [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Test]}" + nl + "Axis #2:" + nl + "{[Customers].[All Customers]}" + nl + "Row #0: 409,035.59" + nl);
    }

    public void testCachingCurrentDate() {
        this.assertQueryReturns("SELECT {filter([Time].[Month].Members, [Time].CurrentMember in {CurrentDateMember([Time], '[\"Time\"]\\.[yyyy]\\.[\"Q\"q]\\.[m]', BEFORE)})} ON COLUMNS from [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Time].[1998].[Q4].[12]}" + nl + "Row #0: " + nl);
    }

    public static class AnotherMemberErrorUdf
    implements UserDefinedFunction {
        public String getName() {
            return "AnotherMemberError";
        }

        public String getDescription() {
            return "Returns default member from hierarchy, specified as a second parameter. First parameter - any member from any hierarchy";
        }

        public Syntax getSyntax() {
            return Syntax.Function;
        }

        public Type getReturnType(Type[] parameterTypes) {
            HierarchyType hierType = (HierarchyType)parameterTypes[1];
            return MemberType.forType(hierType);
        }

        public Type[] getParameterTypes() {
            return new Type[]{MemberType.Unknown, HierarchyType.Unknown};
        }

        public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
            Member member = (Member)arguments[0].evaluate(evaluator);
            Util.discard((Object)member);
            Hierarchy hierarchy = (Hierarchy)arguments[1].evaluate(evaluator);
            return hierarchy.getDefaultMember();
        }

        public String[] getReservedWords() {
            return null;
        }
    }

    public static class StringMultUdf
    implements UserDefinedFunction {
        public String getName() {
            return "StringMult";
        }

        public String getDescription() {
            return "Returns N copies of its string argument";
        }

        public Syntax getSyntax() {
            return Syntax.Function;
        }

        public Type getReturnType(Type[] parameterTypes) {
            return new StringType();
        }

        public Type[] getParameterTypes() {
            return new Type[]{new NumericType(), new StringType()};
        }

        public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
            Object argValue = arguments[0].evaluateScalar(evaluator);
            if (!(argValue instanceof Number)) {
                return null;
            }
            int n = ((Number)argValue).intValue();
            Object argValue2 = arguments[1].evaluateScalar(evaluator);
            if (!(argValue2 instanceof String)) {
                return null;
            }
            String s = (String)argValue2;
            if (n < 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder(s.length() * n);
            for (int i = 0; i < n; ++i) {
                buf.append(s);
            }
            return buf.toString();
        }

        public String[] getReservedWords() {
            return null;
        }
    }

    public static class BadPlusOneUdf
    extends PlusOneUdf {
        private final String name;

        public BadPlusOneUdf(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Type getReturnType(Type[] parameterTypes) {
            return null;
        }
    }

    public static class PlusOneUdf
    implements UserDefinedFunction {
        public String getName() {
            return "PlusOne";
        }

        public String getDescription() {
            return "Returns its argument plus one";
        }

        public Syntax getSyntax() {
            return Syntax.Function;
        }

        public Type getReturnType(Type[] parameterTypes) {
            return new NumericType();
        }

        public Type[] getParameterTypes() {
            return new Type[]{new NumericType()};
        }

        public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
            Object argValue = arguments[0].evaluateScalar(evaluator);
            if (argValue instanceof Number) {
                return ((Number)argValue).doubleValue() + 1.0;
            }
            return null;
        }

        public String[] getReservedWords() {
            return null;
        }
    }
}

