/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.sql.SQLException;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;

public class ParserTest
extends FoodMartTestCase {
    private static final Logger LOGGER = Logger.getLogger(ParserTest.class);
    private static final String DIRECTORY = "testsrc";
    private static final String TEST_SCHEMA_XML = "FoodMart-3.1.xml";
    Connection foodMartConnection = null;

    public ParserTest() {
    }

    public ParserTest(String name) {
        super(name);
    }

    public synchronized void clearConnection() {
        if (this.foodMartConnection != null) {
            try {
                this.foodMartConnection.getDataSource().getConnection().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.foodMartConnection = null;
        }
    }

    public void tearDown() {
        this.clearConnection();
    }

    public void testBadSchema() throws Exception {
        File file = new File(DIRECTORY, TEST_SCHEMA_XML);
        ParserTest.assertTrue((boolean)file.exists());
        FileReader reader = new FileReader(file);
        Parser xmlParser = XOMUtil.createDefaultParser();
        LOGGER.debug((Object)("XOMUtil.createDefaultParser class: " + xmlParser.getClass().getName()));
        DOMWrapper domWrapper = xmlParser.parse((Reader)reader);
        URL catalogURL = Util.toURL(file);
        Util.PropertyList connectProperties = this.getTestContext().getFoodMartConnectionProperties();
        connectProperties.put("catalog", catalogURL.toString());
        Connection foodMartConnection = DriverManager.getConnection(connectProperties, null);
    }
}

