/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import junit.framework.Assert;
import mondrian.olap.Cell;
import mondrian.olap.Member;
import mondrian.olap.Result;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class ParentChildHierarchyTest
extends FoodMartTestCase {
    public ParentChildHierarchyTest(String name) {
        super(name);
    }

    private TestContext getEmpClosureTestContext() {
        return TestContext.createSubstitutingCube("HR", "  <Dimension name=\"EmployeesClosure\" foreignKey=\"employee_id\">\n      <Hierarchy hasAll=\"true\" allMemberName=\"All Employees\"\n          primaryKey=\"employee_id\" primaryKeyTable=\"employee_closure\">\n        <Join leftKey=\"supervisor_id\" rightKey=\"employee_id\">\n          <Table name=\"employee_closure\"/>\n          <Table name=\"employee\" alias=\"employee2\" />\n        </Join>\n        <Level name=\"Closure\"  type=\"Numeric\" uniqueMembers=\"false\"\n            table=\"employee_closure\" column=\"supervisor_id\"/>\n        <Level name=\"Employee\" type=\"Numeric\" uniqueMembers=\"true\"\n            table=\"employee_closure\" column=\"employee_id\"/>\n      </Hierarchy>\n  </Dimension>");
    }

    private TestContext getEmpSnowFlakeClosureTestContext() {
        return TestContext.createSubstitutingCube("HR", "<Dimension name=\"EmployeeSnowFlake\" foreignKey=\"employee_id\"><Hierarchy hasAll=\"true\" allMemberName=\"All Employees\"    primaryKey=\"employee_id\" primaryKeyTable=\"employee\">  <Join leftKey=\"store_id\"    rightAlias=\"store\" rightKey=\"store_id\">    <Table name=\"employee\"/>    <Table name=\"store\"/>  </Join>  <Level name=\"Employee Stores\" table=\"store\"      column=\"store_id\" uniqueMembers=\"true\"/>  <Level name=\"Employee Id\" type=\"Numeric\" table=\"employee\" uniqueMembers=\"true\"      column=\"employee_id\" parentColumn=\"supervisor_id\"      nameColumn=\"full_name\" nullParentValue=\"0\">    <Closure parentColumn=\"supervisor_id\" childColumn=\"employee_id\">      <Table name=\"employee_closure\"/>    </Closure>    <Property name=\"Marital Status\" column=\"marital_status\"/>    <Property name=\"Position Title\" column=\"position_title\"/>    <Property name=\"Gender\" column=\"gender\"/>    <Property name=\"Salary\" column=\"salary\"/>    <Property name=\"Education Level\" column=\"education_level\"/>    <Property name=\"Management Role\" column=\"management_role\"/>  </Level></Hierarchy></Dimension>");
    }

    private TestContext getEmpSharedClosureTestContext() {
        String sharedClosureDimension = "<Dimension name=\"SharedEmployee\"><Hierarchy hasAll=\"true\"    primaryKey=\"employee_id\" primaryKeyTable=\"employee\">  <Join leftKey=\"store_id\"    rightAlias=\"store\" rightKey=\"store_id\">    <Table name=\"employee\"/>    <Table name=\"store\"/>  </Join>  <Level name=\"Employee Id\" type=\"Numeric\" table=\"employee\" uniqueMembers=\"true\"      column=\"employee_id\" parentColumn=\"supervisor_id\"      nameColumn=\"full_name\" nullParentValue=\"0\">    <Closure parentColumn=\"supervisor_id\" childColumn=\"employee_id\">      <Table name=\"employee_closure\"/>    </Closure>    <Property name=\"Marital Status\" column=\"marital_status\"/>    <Property name=\"Position Title\" column=\"position_title\"/>    <Property name=\"Gender\" column=\"gender\"/>    <Property name=\"Salary\" column=\"salary\"/>    <Property name=\"Education Level\" column=\"education_level\"/>    <Property name=\"Management Role\" column=\"management_role\"/>  </Level></Hierarchy></Dimension>";
        String cube = "<Cube name=\"EmployeeSharedClosureCube\">\n  <Table name=\"salary\" alias=\"salary_closure\" />\n  <DimensionUsage name=\"SharedEmployee\" source=\"SharedEmployee\" foreignKey=\"employee_id\" />\n  <Dimension name=\"Department\" foreignKey=\"department_id\">    <Hierarchy hasAll=\"true\" primaryKey=\"department_id\">      <Table name=\"department\"/>        <Level name=\"Department Description\" uniqueMembers=\"true\"          column=\"department_id\"/>    </Hierarchy>  </Dimension>  <DimensionUsage name=\"Store Type\" source=\"Store Type\" foreignKey=\"warehouse_id\" />\n  <Measure name=\"Org Salary\" column=\"salary_paid\" aggregator=\"sum\"      formatString=\"Currency\"/>   <Measure name=\"Count\" column=\"employee_id\" aggregator=\"count\"    formatString=\"#,#\"/></Cube>";
        return TestContext.create(sharedClosureDimension, cube, null, null, null, null);
    }

    private TestContext getEmpNonClosureTestContext() {
        return TestContext.createSubstitutingCube("HR", "<Dimension name=\"EmployeesNonClosure\" foreignKey=\"employee_id\"><Hierarchy hasAll=\"true\" allMemberName=\"All Employees\"    primaryKey=\"employee_id\">  <Table name=\"employee\"/>  <Level name=\"Employee Id\" type=\"Numeric\" uniqueMembers=\"true\"      column=\"employee_id\" parentColumn=\"supervisor_id\"      nameColumn=\"full_name\" nullParentValue=\"0\">    <Property name=\"Marital Status\" column=\"marital_status\"/>    <Property name=\"Position Title\" column=\"position_title\"/>    <Property name=\"Gender\" column=\"gender\"/>    <Property name=\"Salary\" column=\"salary\"/>    <Property name=\"Education Level\" column=\"education_level\"/>    <Property name=\"Management Role\" column=\"management_role\"/>  </Level></Hierarchy></Dimension>", null);
    }

    public void testSnowflakeClosure() {
        this.getEmpSnowFlakeClosureTestContext().assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[EmployeeSnowFlake]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[EmployeeSnowFlake].[All Employees]}\nRow #0: 7,392\nRow #0: $39,431.67\nRow #0: 616\nRow #0: $64.01\n"));
    }

    public void testSharedClosureParentChildHierarchy() {
        TestContext context = this.getEmpSharedClosureTestContext();
        context.assertQueryReturns("Select {[SharedEmployee].[All SharedEmployees].[Sheri Nowmer].[Derrick Whelply].children} on columns from EmployeeSharedClosureCube", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[SharedEmployee].[All SharedEmployees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker]}\n{[SharedEmployee].[All SharedEmployees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo]}\n{[SharedEmployee].[All SharedEmployees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges]}\nRow #0: $10,256.30\nRow #0: $29,121.55\nRow #0: $35,487.69\n"));
    }

    public void _testNonClosureParentChildHierarchy() {
        this.getEmpNonClosureTestContext().assertQueryReturns("Select {[EmployeesNonClosure].[Sheri Nowmer].children} on columns,{[Time].[1997]} ON rows from HR", "Axis #0:\n{}\nAxis #1:\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Derrick Whelply]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Michael Spence]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Maya Gutierrez]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Roberta Damstra]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Darren Stanz]}\n{[EmployeesNonClosure].[All Employees].[Sheri Nowmer].[Donna Arnold]}\nAxis #2:\n{[Time].[1997]}\nRow #0: $36,494.07\nRow #0: \nRow #0: \nRow #0: $428.76\nRow #0: $234.36\nRow #0: $832.68\nRow #0: $577.80\n");
    }

    public void testAll() {
        this.assertQueryReturns("select {[Measures].[Org Salary], [Measures].[Count]} on columns,\n {[Employees]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\n{[Measures].[Count]}\nAxis #2:\n{[Employees].[All Employees]}\nRow #0: $39,431.67\nRow #0: 7,392\n"));
    }

    public void testChildrenOfAll() {
        this.assertQueryReturns("select {[Measures].[Org Salary], [Measures].[Count]} on columns,\n {[Employees].children} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\n{[Measures].[Count]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer]}\nRow #0: $39,431.67\nRow #0: 7,392\n"));
    }

    public void testDistinctAll() {
        this.assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[Employees]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[Employees].[All Employees]}\nRow #0: 7,392\nRow #0: $39,431.67\nRow #0: 616\nRow #0: $64.01\n"));
    }

    public void testDistinctChildrenOfAll() {
        this.assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[Employees].children} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer]}\nRow #0: 7,392\nRow #0: $39,431.67\nRow #0: 616\nRow #0: $64.01\n"));
    }

    public void testDistinctSubtree() {
        this.assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]}\nRow #0: 24\nRow #0: $234.36\nRow #0: 2\nRow #0: $117.18\n"));
    }

    public void testDistinctAllExplicitClosure() {
        this.getEmpClosureTestContext().assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[EmployeesClosure]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[EmployeesClosure].[All Employees]}\nRow #0: 7,392\nRow #0: $39,431.67\nRow #0: 616\nRow #0: $64.01\n"));
    }

    public void testDistinctChildrenOfAllExplicitClosure() {
        this.getEmpClosureTestContext().assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[EmployeesClosure].FirstChild} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[EmployeesClosure].[All Employees].[1]}\nRow #0: 7,392\nRow #0: $39,431.67\nRow #0: 616\nRow #0: $64.01\n"));
    }

    public void testDistinctSubtreeExplicitClosure() {
        this.getEmpClosureTestContext().assertQueryReturns("select {[Measures].[Count], [Measures].[Org Salary], \n[Measures].[Number Of Employees], [Measures].[Avg Salary]} on columns,\n{[EmployeesClosure].[All Employees].[7]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count]}\n{[Measures].[Org Salary]}\n{[Measures].[Number of Employees]}\n{[Measures].[Avg Salary]}\nAxis #2:\n{[EmployeesClosure].[All Employees].[7]}\nRow #0: 24\nRow #0: $234.36\nRow #0: 2\nRow #0: $117.18\n"));
    }

    public void testLeaf() {
        this.assertQueryReturns("select {[Measures].[Org Salary], [Measures].[Count]} on columns,\n {[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\n{[Measures].[Count]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]}\nRow #0: $72.36\nRow #0: 12\n"));
    }

    public void testOneAboveLeaf() {
        this.assertQueryReturns("select {[Measures].[Org Salary], [Measures].[Count]} on columns,\n {[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\n{[Measures].[Count]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]}\nRow #0: $234.36\nRow #0: 24\n"));
    }

    public void testParentChildDescendantsLeavesBottom() {
        this.assertQueryReturns("WITH SET [NonEmptyEmployees] AS 'FILTER(DESCENDANTS([Employees].[All Employees], 10, LEAVES),\n  NOT ISEMPTY([Measures].[Employee Salary]))'\nSELECT { [Measures].[Employee Salary], [Measures].[Number of Employees] } ON COLUMNS,\n  BOTTOMCOUNT([NonEmptyEmployees], 10, [Measures].[Employee Salary]) ON ROWS\nFROM HR\nWHERE ([Pay Type].[Hourly])", ParentChildHierarchyTest.fold("Axis #0:\n{[Pay Type].[All Pay Types].[Hourly]}\nAxis #1:\n{[Measures].[Employee Salary]}\n{[Measures].[Number of Employees]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Eric Long].[Adam Reynolds].[William Hapke].[Marie Richmeier]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Jose Bernard].[Mary Hunt].[Bonnie Bruno].[Ellen Gray]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Paula Nickell].[Kristine Cleary].[Carla Zubaty].[Hattie Haemon]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lois Wood].[Dell Gras].[Christopher Solano].[Sarah Amole]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Charles Macaluso].[Barbara Wallin].[Kenneth Turner].[Shirley Head]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lois Wood].[Dell Gras].[Christopher Solano].[Mary Hall]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Pat Chin].[Yasmina Brown]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Eric Long].[Adam Reynolds].[Joshua Huff].[Teanna Cobb]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lois Wood].[Dell Gras].[Kristine Aldred].[Kenton Forham]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Mary Solimena].[Matthew Hunter].[Eddie Holmes].[Donald Thompson]}\nRow #0: $39.44\nRow #0: 1\nRow #1: $39.52\nRow #1: 1\nRow #2: $39.52\nRow #2: 1\nRow #3: $39.60\nRow #3: 1\nRow #4: $39.62\nRow #4: 1\nRow #5: $39.62\nRow #5: 1\nRow #6: $39.66\nRow #6: 1\nRow #7: $39.67\nRow #7: 1\nRow #8: $39.75\nRow #8: 1\nRow #9: $39.75\nRow #9: 1\n"));
    }

    public void testParentChildDescendantsLeavesTop() {
        this.assertQueryReturns("with set [Leaves] as 'Descendants([Employees].[All Employees], 15, LEAVES)'\n set [Parents] as 'Generate([Leaves], {[Employees].CurrentMember.Parent})'\n set [FirstParents] as 'Filter([Parents], \nCount(Descendants( [Employees].CurrentMember, 2)) = 0 )'\nselect {[Measures].[Number of Employees]} on Columns,\n  TopCount([FirstParents], 10, [Measures].[Number of Employees]) on Rows\nfrom HR", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Number of Employees]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Joy Sincich]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Bertha Jameson]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Mary Solimena].[Matthew Hunter].[Florence Vonholt]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Mary Solimena].[Matthew Hunter].[Eddie Holmes]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Laurie Borges].[Mary Solimena].[Matthew Hunter].[Gerald Drury]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Jose Bernard].[Mary Hunt].[Libby Allen]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Jose Bernard].[Mary Hunt].[Bonnie Bruno]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Jose Bernard].[Mary Hunt].[Angela Bowers]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Charles Macaluso].[Barbara Wallin].[Michael Bruha]}\nRow #0: 23\nRow #1: 23\nRow #2: 23\nRow #3: 23\nRow #4: 23\nRow #5: 23\nRow #6: 19\nRow #7: 19\nRow #8: 19\nRow #9: 19\n"));
    }

    public void testAllMembersParent() {
        String expected = ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Parent]}\nAxis #2:\n{[Employees].[All Employees]}\n{[Employees].[All Employees].[Sheri Nowmer]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Shauna Wyro]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Shauna Wyro].[Bunny McCown]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Shauna Wyro].[Bunny McCown].[Nancy Miller]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Shauna Wyro].[Bunny McCown].[Wanda Hollar]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck].[Corinne Zugschwert]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck].[Michelle Adams]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck].[Donahue Steen]}\n{[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Anne Tuck].[John Baker]}\nRow #0: #null\nRow #1: All Employees\nRow #2: Sheri Nowmer\nRow #3: Derrick Whelply\nRow #4: Beverly Baker\nRow #5: Shauna Wyro\nRow #6: Bunny McCown\nRow #7: Bunny McCown\nRow #8: Beverly Baker\nRow #9: Jacqueline Wyllie\nRow #10: Ralph Mccoy\nRow #11: Anne Tuck\nRow #12: Anne Tuck\nRow #13: Anne Tuck\nRow #14: Anne Tuck\n");
        this.assertQueryReturns("with member [Measures].[Parent] as '[Employees].CurrentMember.Parent.Name'\nselect {[Measures].[Parent]}\nON COLUMNS,\nHead([Employees].Members, 15)\nON ROWS from [HR]", expected);
        this.assertQueryReturns("with member [Measures].[Parent] as '[Employees].CurrentMember.Parent.Name'\nselect {[Measures].[Parent]}\nON COLUMNS,\nHead([Employees].AllMembers, 15)\nON ROWS from [HR]", expected);
        this.assertQueryReturns("with member [Measures].[Parent] as '[Employees].CurrentMember.Parent.Name'\nselect {[Measures].[Parent]}\nON COLUMNS,\n{[Employees], Head([Employees].[Employee Id].Members, 14)}\nON ROWS from [HR]", expected);
    }

    public void testHierarchyFalseCycle() {
        this.assertQueryReturns("SELECT {[Employees].[All Employees].Children} on columns,\n {[Measures].[Org Salary]} on rows\nFROM [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Employees].[All Employees].[Sheri Nowmer]}\nAxis #2:\n{[Measures].[Org Salary]}\nRow #0: $39,431.67\n"));
        TestContext testContext = TestContext.create(null, "<Cube name='HR-fewer-dims'>\n    <Table name='salary'/>\n    <Dimension name='Department' foreignKey='department_id'>\n        <Hierarchy hasAll='true' primaryKey='department_id'>\n            <Table name='department'/>\n            <Level name='Department Description' uniqueMembers='true' column='department_id'/>\n        </Hierarchy>\n    </Dimension>\n    <Dimension name='Employees' foreignKey='employee_id'>\n        <Hierarchy hasAll='true' allMemberName='All Employees' primaryKey='employee_id'>\n            <Table name='employee'/>\n            <Level name='Employee Id' type='Numeric' uniqueMembers='true' column='employee_id' parentColumn='supervisor_id' nameColumn='full_name' nullParentValue='0'>\n                <Property name='Marital Status' column='marital_status'/>\n                <Property name='Position Title' column='position_title'/>\n                <Property name='Gender' column='gender'/>\n                <Property name='Salary' column='salary'/>\n                <Property name='Education Level' column='education_level'/>\n                <Property name='Management Role' column='management_role'/>\n            </Level>\n        </Hierarchy>\n    </Dimension>\n    <Measure name='Org Salary' column='salary_paid' aggregator='sum' formatString='Currency' />\n    <Measure name='Count' column='employee_id' aggregator='count' formatString='#,#'/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("SELECT {[Employees].[All Employees].Children} on columns,\n {[Measures].[Org Salary]} on rows\nFROM [HR-fewer-dims]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Employees].[All Employees].[Sheri Nowmer]}\nAxis #2:\n{[Measures].[Org Salary]}\nRow #0: $271,552.44\n"));
    }

    public void testGenuineCycle() {
        Result result = this.executeQuery("with member [Measures].[Foo] as \n  '([Measures].[Foo], OpeningPeriod([Time].[Month]))'\nselect\n {[Measures].[Unit Sales], [Measures].[Foo]} on Columns,\n { [Time].[1997].[Q2]} on rows\nfrom [Sales]");
        String resultString = TestContext.toString(result);
        String expectedPattern = "(?s).*Row #0: #ERR: mondrian.olap.fun.MondrianEvaluationException.*: Infinite loop while evaluating calculated member \\'\\[Measures\\].\\[Foo\\]\\'; context stack is.*";
        if (!resultString.matches("(?s).*Row #0: #ERR: mondrian.olap.fun.MondrianEvaluationException.*: Infinite loop while evaluating calculated member \\'\\[Measures\\].\\[Foo\\]\\'; context stack is.*")) {
            System.out.println(resultString);
            Assert.assertEquals((String)"(?s).*Row #0: #ERR: mondrian.olap.fun.MondrianEvaluationException.*: Infinite loop while evaluating calculated member \\'\\[Measures\\].\\[Foo\\]\\'; context stack is.*", (String)resultString);
        }
    }

    public void testParentChildDrillThrough() throws Exception {
        Result result = this.executeQuery("select {[Measures].Members} ON columns,\n  {[Employees].Members} ON rows\nfrom [HR]");
        boolean extendedContext = false;
        this.checkDrillThroughSql(result, 0, false, "[Employees].[All Employees]", "$39,431.67", "select `time_by_day`.`the_year` as `Year`, `salary`.`salary_paid` as `Org Salary` from `time_by_day` =as= `time_by_day`, `salary` =as= `salary` where `salary`.`pay_date` = `time_by_day`.`the_date` and `time_by_day`.`the_year` = 1997 order by `time_by_day`.`the_year` ASC", 7392);
        this.checkDrillThroughSql(result, 1, false, "[Employees].[All Employees].[Sheri Nowmer]", "$39,431.67", "select `time_by_day`.`the_year` as `Year`, `employee`.`employee_id` as `Employee Id (Key)`, `salary`.`salary_paid` as `Org Salary` from `time_by_day` =as= `time_by_day`, `salary` =as= `salary`, `employee` =as= `employee` where `salary`.`pay_date` = `time_by_day`.`the_date` and `time_by_day`.`the_year` = 1997 and `salary`.`employee_id` = `employee`.`employee_id` and `employee`.`employee_id` = 1 order by `time_by_day`.`the_year` ASC, `employee`.`employee_id` ASC", 12);
        this.checkDrillThroughSql(result, 2, false, "[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]", "$36,494.07", "select `time_by_day`.`the_year` as `Year`, `employee`.`employee_id` as `Employee Id (Key)`, `salary`.`salary_paid` as `Org Salary` from `time_by_day` =as= `time_by_day`, `salary` =as= `salary`, `employee` =as= `employee` where `salary`.`pay_date` = `time_by_day`.`the_date` and `time_by_day`.`the_year` = 1997 and `salary`.`employee_id` = `employee`.`employee_id` and `employee`.`employee_id` = 2 order by `time_by_day`.`the_year` ASC, `employee`.`employee_id` ASC", 12);
    }

    public void testParentChildDrillThroughWithContext() throws Exception {
        Result result = this.executeQuery("select {[Measures].Members} ON columns,\n  {[Employees].Members} ON rows\nfrom [HR]");
        boolean extendedContext = true;
        this.checkDrillThroughSql(result, 2, true, "[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]", "$36,494.07", "select `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.`the_month` as `Month`, `time_by_day`.`month_of_year` as `Month (Key)`, `store`.`store_country` as `Store Country`, `store`.`store_state` as `Store State`, `store`.`store_city` as `Store City`, `store`.`store_name` as `Store Name`, `position`.`pay_type` as `Pay Type`, `store`.`store_type` as `Store Type`, `employee`.`management_role` as `Management Role`, `employee`.`position_title` as `Position Title`, `department`.`department_id` as `Department Description`, `employee`.`full_name` as `Employee Id`, `employee`.`employee_id` as `Employee Id (Key)`, `salary`.`salary_paid` as `Org Salary` from `time_by_day` =as= `time_by_day`, `salary` =as= `salary`, `store` =as= `store`, `employee` =as= `employee`, `position` =as= `position`, `department` =as= `department` where `salary`.`pay_date` = `time_by_day`.`the_date` and `time_by_day`.`the_year` = 1997 and `salary`.`employee_id` = `employee`.`employee_id` and `employee`.`store_id` = `store`.`store_id` and `employee`.`position_id` = `position`.`position_id` and `salary`.`department_id` = `department`.`department_id` and `employee`.`employee_id` = 2 order by `time_by_day`.`the_year` ASC, `time_by_day`.`quarter` ASC, `time_by_day`.`the_month` ASC, `time_by_day`.`month_of_year` ASC, `store`.`store_country` ASC, `store`.`store_state` ASC, `store`.`store_city` ASC, `store`.`store_name` ASC, `position`.`pay_type` ASC, `store`.`store_type` ASC, `employee`.`management_role` ASC, `employee`.`position_title` ASC, `department`.`department_id` ASC, `employee`.`full_name` ASC, `employee`.`employee_id` ASC", 12);
    }

    private void checkDrillThroughSql(Result result, int row, boolean extendedContext, String expectedMember, String expectedCell, String expectedSql, int expectedRows) throws Exception {
        Member empMember = (Member)result.getAxes()[1].getPositions().get(row).get(0);
        ParentChildHierarchyTest.assertEquals((String)expectedMember, (String)empMember.getUniqueName());
        Cell cell = result.getCell(new int[]{0, row});
        ParentChildHierarchyTest.assertEquals((String)expectedCell, (String)cell.getFormattedValue());
        String sql = cell.getDrillThroughSQL(extendedContext);
        this.getTestContext().assertSqlEquals(expectedSql, sql, expectedRows);
    }

    public void testBug1459995() {
        this.assertQueryReturns("select \n     {[Employee Salary]} on columns, \n     {[Employees]} on rows \nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Employee Salary]}\nAxis #2:\n{[Employees].[All Employees]}\nRow #0: \n"));
        this.assertQueryReturns("select \n     {[Position]} on columns,\n     {[Employee Salary]} on rows\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Position].[All Position]}\nAxis #2:\n{[Measures].[Employee Salary]}\nRow #0: \n"));
    }

    public void testParentChildOrdinal() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"HR-ordered\">\n  <Table name=\"salary\"/>\n  <Dimension name=\"Employees\" foreignKey=\"employee_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Employees\"\n        primaryKey=\"employee_id\">\n      <Table name=\"employee\"/>\n      <Level name=\"Employee Id\" type=\"Numeric\" uniqueMembers=\"true\"\n          column=\"employee_id\" parentColumn=\"supervisor_id\"\n          nameColumn=\"full_name\" nullParentValue=\"0\"          ordinalColumn=\"last_name\" >\n        <Closure parentColumn=\"supervisor_id\" childColumn=\"employee_id\">\n          <Table name=\"employee_closure\"/>\n        </Closure>\n        <Property name=\"First Name\" column=\"first_name\"/>\n      </Level>\n    </Hierarchy>\n  </Dimension>\n\n  <Measure name=\"Org Salary\" column=\"salary_paid\" aggregator=\"sum\"\n      formatString=\"Currency\"/>\n  <Measure name=\"Count\" column=\"employee_id\" aggregator=\"count\"\n      formatString=\"#,#\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("with member [Measures].[First Name] as  'Iif([Employees].Level.Name = \"Employee Id\", [Employees].CurrentMember.Properties(\"First Name\"), Cast(NULL AS STRING)) '\nselect {[Measures].[Org Salary], [Measures].[First Name]} on columns,\n {Tail(Head([Employees].Members, 15), 4)} on rows\nfrom [HR-ordered]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\n{[Measures].[First Name]}\nAxis #2:\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Brenda Blumberg]}\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Brenda Blumberg].[Wayne Banack]}\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Brenda Blumberg].[Wayne Banack].[Samuel Agcaoili]}\n{[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez].[Brenda Blumberg].[Wayne Banack].[Megan Davis]}\nRow #0: $29,762.88\nRow #0: Brenda\nRow #1: $27,908.33\nRow #1: Wayne\nRow #2: $981.82\nRow #2: Samuel\nRow #3: $927.27\nRow #3: Megan\n"));
        testContext.assertQueryReturns("select {[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].Children} on columns from [HR-ordered]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Sandra Brunner]}\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]}\nRow #0: $60.00\nRow #0: $152.76\n"));
        testContext.assertQueryReturns("select {HEAD(DESCENDANTS([Employees].[Sheri Nowmer], [Employees].[Employee Id], LEAVES), 6)} on columns from [HR-ordered]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard]}\n{[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Doris Carter]}\n{[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Phyllis Burchett]}\n{[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jennifer Cooper]}\n{[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jessica Olguin]}\n{[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Peggy Petty]}\nRow #0: $193.80\nRow #0: $60.00\nRow #0: $120.00\nRow #0: $152.76\nRow #0: $120.00\nRow #0: $182.40\n"));
    }

    public void testLevelMembers() {
        TestContext testContext = new TestContext(){

            public String getDefaultCubeName() {
                return "HR";
            }
        };
        testContext.assertExprReturns("[Employees].Members.Count", "1,156");
        testContext.assertExprReturns("[Employees].[Employee Id].Members.Count", "1,155");
        testContext.assertExprReturns("[Employees].[Sheri Nowmer].Children.Count", "7");
        testContext.assertQueryReturns("with member [Employees].[Foo] as ' Sum([Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].Children) '\nmember [Measures].[Count1] AS [Employees].MEMBERS.Count\nmember [Measures].[Count2] AS [Employees].ALLMEMBERS.COUNT\nselect {[Measures].[Count1], [Measures].[Count2]} ON COLUMNS\nfrom [HR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Count1]}\n{[Measures].[Count2]}\nRow #0: 1,156\nRow #0: 1,157\n"));
    }

    public void testClosureTableInVirtualCube() {
        TestContext testContext = TestContext.create("<Dimension name=\"Employees\" >   <Hierarchy hasAll=\"true\" allMemberName=\"All Employees\"      primaryKey=\"employee_id\" primaryKeyTable=\"employee\">      <Table name=\"employee\"/>      <Level name=\"Employee Name\" type=\"Numeric\" uniqueMembers=\"true\"         column=\"employee_id\" parentColumn=\"supervisor_id\"         nameColumn=\"full_name\" nullParentValue=\"0\">         <Closure parentColumn=\"supervisor_id\" childColumn=\"employee_id\">            <Table name=\"employee_closure\"/>         </Closure>      </Level>   </Hierarchy></Dimension>", null, "<Cube name=\"CustomSales\">   <Table name=\"sales_fact_1997\"/>   <DimensionUsage name=\"Employees\" source=\"Employees\" foreignKey=\"time_id\"/>   <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"/></Cube><Cube name=\"CustomHR\">   <Table name=\"salary\"/>   <DimensionUsage name=\"Employees\" source=\"Employees\" foreignKey=\"employee_id\"/>   <Measure name=\"Org Salary\" column=\"salary_paid\" aggregator=\"sum\"/></Cube><VirtualCube name=\"CustomSalesAndHR\" ><VirtualCubeDimension name=\"Employees\"/><VirtualCubeMeasure cubeName=\"CustomSales\" name=\"[Measures].[Store Sales]\"/><VirtualCubeMeasure cubeName=\"CustomHR\" name=\"[Measures].[Org Salary]\"/><CalculatedMember name=\"HR Cost per Sale\" dimension=\"Measures\"><Formula>[Measures].[Store Sales] / [Measures].[Org Salary]</Formula></CalculatedMember></VirtualCube>", null, null, null);
        testContext.assertQueryReturns("select [Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].Children ON COLUMNS, {[Measures].[Org Salary]} ON ROWS from [CustomSalesAndHR]", ParentChildHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]}\n{[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Sandra Brunner]}\nAxis #2:\n{[Measures].[Org Salary]}\nRow #0: 152.76\nRow #0: 60\n"));
    }
}

