/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import mondrian.calc.impl.ConstantCalcTest;
import mondrian.olap.CellPropertyTest;
import mondrian.olap.CustomizedParserTest;
import mondrian.olap.HierarchyBugTest;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NullMemberRepresentationTest;
import mondrian.olap.QueryTest;
import mondrian.olap.Util;
import mondrian.olap.UtilTestCase;
import mondrian.olap.fun.CrossJoinTest;
import mondrian.olap.fun.FunctionTest;
import mondrian.olap.fun.MemberHelperTest;
import mondrian.olap.fun.PartialSortTest;
import mondrian.olap.fun.SetFunDefTest;
import mondrian.olap.fun.SortTest;
import mondrian.olap.fun.vba.VbaTest;
import mondrian.olap.type.TypeTest;
import mondrian.rolap.BitKeyTest;
import mondrian.rolap.CacheControlTest;
import mondrian.rolap.CellKeyTest;
import mondrian.rolap.DataSourceChangeListenerTest;
import mondrian.rolap.FastBatchingCellReaderTest;
import mondrian.rolap.GroupingSetQueryTest;
import mondrian.rolap.HighDimensionsTest;
import mondrian.rolap.IndexedValuesTest;
import mondrian.rolap.MemberCacheControlTest;
import mondrian.rolap.ModulosTest;
import mondrian.rolap.NonEmptyPropertyForAllAxisTest;
import mondrian.rolap.NonEmptyTest;
import mondrian.rolap.RolapAxisTest;
import mondrian.rolap.RolapConnectionTest;
import mondrian.rolap.RolapCubeTest;
import mondrian.rolap.RolapSchemaReaderTest;
import mondrian.rolap.SharedDimensionTest;
import mondrian.rolap.TestAggregationManager;
import mondrian.rolap.VirtualCubeTest;
import mondrian.rolap.agg.AggregationOnDistinctCountMeasuresTest;
import mondrian.rolap.sql.SqlQueryTest;
import mondrian.test.AccessControlTest;
import mondrian.test.BasicQueryTest;
import mondrian.test.CaptionTest;
import mondrian.test.CmdRunnerTest;
import mondrian.test.CompatibilityTest;
import mondrian.test.DialectTest;
import mondrian.test.DrillThroughTest;
import mondrian.test.I18nTest;
import mondrian.test.IgnoreMeasureForNonJoiningDimensionInAggregationTest;
import mondrian.test.IgnoreUnrelatedDimensionsTest;
import mondrian.test.InlineTableTest;
import mondrian.test.MondrianTestRunner;
import mondrian.test.MultipleHierarchyTest;
import mondrian.test.NamedSetTest;
import mondrian.test.ParallelTest;
import mondrian.test.ParameterTest;
import mondrian.test.ParentChildHierarchyTest;
import mondrian.test.ParserTest;
import mondrian.test.PropertiesTest;
import mondrian.test.RaggedHierarchyTest;
import mondrian.test.SchemaTest;
import mondrian.test.Ssas2005CompatibilityTest;
import mondrian.test.SteelWheelsTestCase;
import mondrian.test.TestCalculatedMembers;
import mondrian.test.UdfTest;
import mondrian.test.clearview.BatchedFillTest;
import mondrian.test.clearview.CVBasicTest;
import mondrian.test.clearview.GrandTotalTest;
import mondrian.test.clearview.HangerDimensionTest;
import mondrian.test.clearview.MetricFilterTest;
import mondrian.test.clearview.MiscTest;
import mondrian.test.clearview.OrderTest;
import mondrian.test.clearview.PredicateFilterTest;
import mondrian.test.clearview.SubTotalTest;
import mondrian.test.clearview.SummaryMetricPercentTest;
import mondrian.test.clearview.SummaryTest;
import mondrian.test.clearview.TopBottomTest;
import mondrian.test.comp.ResultComparatorTest;
import mondrian.udf.NullValueTest;
import mondrian.util.FilteredIterableTest;
import mondrian.util.FormatTest;
import mondrian.util.MemoryMonitorTest;
import mondrian.util.ObjectPoolTest;
import mondrian.util.PrimeFinderTest;
import mondrian.util.ScheduleTest;
import mondrian.xmla.XmlaBasicTest;
import mondrian.xmla.XmlaCognosTest;
import mondrian.xmla.XmlaErrorTest;
import mondrian.xmla.XmlaExcel2000Test;
import mondrian.xmla.XmlaExcelXPTest;
import mondrian.xmla.XmlaTabularTest;
import mondrian.xmla.XmlaTests;
import mondrian.xmla.impl.DynamicDatasourceXmlaServletTest;
import mondrian.xmla.test.XmlaTest;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends TestSuite {
    private static final Logger logger = Logger.getLogger(Main.class);
    private static Map<TestSuite, String> testSuiteInfo = new HashMap<TestSuite, String>();

    public static void main(String[] args) {
        new Main().runSafe(args);
    }

    private void runSafe(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception e) {
            String[] errors;
            PrintWriter pw = new PrintWriter(System.out);
            pw.println("mondrian.test.Main received exception:");
            for (String error : errors = Util.convertStackToString(e)) {
                pw.println(error);
            }
            pw.flush();
            System.exit(1);
        }
    }

    private void run(String[] args) throws Exception {
        TestResult tres;
        MondrianTestRunner runner;
        MondrianProperties properties = MondrianProperties.instance();
        Test test = Main.suite();
        if (args.length == 1 && args[0].equals("-l")) {
            return;
        }
        if (properties.Warmup.get()) {
            System.out.println("Starting warmup run...");
            runner = new MondrianTestRunner();
            tres = runner.doRun(test);
            if (!tres.wasSuccessful()) {
                System.out.println("Warmup run failed. Regular tests will not be run.");
                System.exit(1);
            }
            System.out.println("Warmup run complete. Starting regular run...");
        }
        runner = new MondrianTestRunner();
        runner.setIterations(properties.Iterations.get());
        System.out.println("Iterations=" + properties.Iterations.get());
        runner.setVUsers(properties.VUsers.get());
        runner.setTimeLimit(properties.TimeLimit.get());
        tres = runner.doRun(test);
        if (!tres.wasSuccessful()) {
            System.exit(1);
        }
    }

    public static Test suite() throws Exception {
        String testInfo;
        MondrianProperties properties = MondrianProperties.instance();
        String testName = properties.TestName.get();
        String testClass = properties.TestClass.get();
        System.out.println("testName: " + testName);
        System.out.println("testClass: " + testClass);
        System.out.println("java.version: " + System.getProperty("java.version"));
        TestSuite suite = new TestSuite();
        if (testClass != null && !testClass.equals("")) {
            Class<?> clazz = Class.forName(testClass);
            boolean matchTestMethods = false;
            if (Test.class.isAssignableFrom(clazz)) {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length && !matchTestMethods; ++i) {
                    matchTestMethods = methods[i].getName().startsWith("test");
                }
            }
            if (matchTestMethods) {
                Main.addTest(suite, clazz);
            } else {
                Method method = clazz.getMethod("suite", new Class[0]);
                TestCase target = Modifier.isStatic(method.getModifiers()) ? null : (TestCase)clazz.newInstance();
                Object o = method.invoke((Object)target, new Object[0]);
                Main.addTest(suite, (Test)o, clazz.getName() + method.getName());
            }
        } else {
            Main.addTest(suite, RolapConnectionTest.class);
            Main.addTest(suite, FilteredIterableTest.class);
            Main.addTest(suite, HighDimensionsTest.class);
            Main.addTest(suite, IndexedValuesTest.class);
            Main.addTest(suite, MemoryMonitorTest.class);
            Main.addTest(suite, ObjectPoolTest.class);
            Main.addTest(suite, Ssas2005CompatibilityTest.OldBehaviorTest.class);
            Main.addTest(suite, DialectTest.class);
            Main.addTest(suite, ResultComparatorTest.class, "suite");
            Main.addTest(suite, DrillThroughTest.class);
            Main.addTest(suite, BasicQueryTest.class);
            Main.addTest(suite, CVBasicTest.class, "suite");
            Main.addTest(suite, GrandTotalTest.class, "suite");
            Main.addTest(suite, HangerDimensionTest.class, "suite");
            Main.addTest(suite, MetricFilterTest.class, "suite");
            Main.addTest(suite, MiscTest.class, "suite");
            Main.addTest(suite, PredicateFilterTest.class, "suite");
            Main.addTest(suite, SubTotalTest.class, "suite");
            Main.addTest(suite, SummaryMetricPercentTest.class, "suite");
            Main.addTest(suite, SummaryTest.class, "suite");
            Main.addTest(suite, TopBottomTest.class, "suite");
            Main.addTest(suite, OrderTest.class, "suite");
            Main.addTest(suite, CacheControlTest.class);
            Main.addTest(suite, MemberCacheControlTest.class);
            Main.addTest(suite, FunctionTest.class);
            Main.addTest(suite, PartialSortTest.class);
            Main.addTest(suite, VbaTest.class);
            Main.addTest(suite, HierarchyBugTest.class);
            Main.addTest(suite, ScheduleTest.class);
            Main.addTest(suite, UtilTestCase.class);
            Main.addTest(suite, SortTest.class);
            if (Main.isRunOnce()) {
                Main.addTest(suite, TestAggregationManager.class);
            }
            Main.addTest(suite, VirtualCubeTest.class);
            Main.addTest(suite, ParameterTest.class);
            Main.addTest(suite, AccessControlTest.class);
            Main.addTest(suite, ParserTest.class);
            Main.addTest(suite, CustomizedParserTest.class);
            Main.addTest(suite, ParentChildHierarchyTest.class);
            Main.addTest(suite, XmlaBasicTest.class);
            Main.addTest(suite, XmlaErrorTest.class);
            Main.addTest(suite, XmlaExcel2000Test.class);
            Main.addTest(suite, XmlaExcelXPTest.class);
            Main.addTest(suite, XmlaCognosTest.class);
            Main.addTest(suite, XmlaTabularTest.class);
            Main.addTest(suite, XmlaTests.class);
            Main.addTest(suite, DynamicDatasourceXmlaServletTest.class);
            Main.addTest(suite, XmlaTest.class, "suite");
            if (Main.isRunOnce()) {
                Main.addTest(suite, TestCalculatedMembers.class);
            }
            Main.addTest(suite, RaggedHierarchyTest.class);
            Main.addTest(suite, NonEmptyPropertyForAllAxisTest.class);
            Main.addTest(suite, InlineTableTest.class);
            Main.addTest(suite, CompatibilityTest.class);
            Main.addTest(suite, CaptionTest.class);
            Main.addTest(suite, UdfTest.class);
            Main.addTest(suite, NullValueTest.class);
            Main.addTest(suite, NamedSetTest.class);
            Main.addTest(suite, PropertiesTest.class);
            Main.addTest(suite, MultipleHierarchyTest.class);
            Main.addTest(suite, I18nTest.class);
            Main.addTest(suite, FormatTest.class);
            Main.addTest(suite, ParallelTest.class);
            Main.addTest(suite, SchemaTest.class);
            Main.addTest(suite, GroupingSetQueryTest.class);
            Main.addTest(suite, CmdRunnerTest.class);
            Main.addTest(suite, DataSourceChangeListenerTest.class);
            Main.addTest(suite, ModulosTest.class);
            Main.addTest(suite, PrimeFinderTest.class);
            Main.addTest(suite, CellKeyTest.class);
            Main.addTest(suite, RolapAxisTest.class);
            Main.addTest(suite, MemberHelperTest.class);
            Main.addTest(suite, CrossJoinTest.class);
            Main.addTest(suite, ConstantCalcTest.class);
            Main.addTest(suite, SharedDimensionTest.class);
            Main.addTest(suite, CellPropertyTest.class);
            Main.addTest(suite, QueryTest.class);
            Main.addTest(suite, RolapSchemaReaderTest.class);
            Main.addTest(suite, RolapCubeTest.class);
            Main.addTest(suite, NullMemberRepresentationTest.class);
            Main.addTest(suite, IgnoreUnrelatedDimensionsTest.class);
            Main.addTest(suite, IgnoreMeasureForNonJoiningDimensionInAggregationTest.class);
            Main.addTest(suite, SetFunDefTest.class);
            Main.addTest(suite, AggregationOnDistinctCountMeasuresTest.class);
            Main.addTest(suite, BitKeyTest.class);
            Main.addTest(suite, TypeTest.class);
            Main.addTest(suite, SteelWheelsTestCase.class);
            boolean testNonEmpty = Main.isRunOnce();
            if (!MondrianProperties.instance().EnableNativeNonEmpty.get()) {
                testNonEmpty = false;
            }
            if (!MondrianProperties.instance().EnableNativeCrossJoin.get()) {
                testNonEmpty = false;
            }
            if (testNonEmpty) {
                Main.addTest(suite, NonEmptyTest.class);
            } else {
                logger.warn((Object)"skipping NonEmptyTests");
            }
            Main.addTest(suite, FastBatchingCellReaderTest.class);
            Main.addTest(suite, SqlQueryTest.class);
            if (MondrianProperties.instance().EnableNativeCrossJoin.get()) {
                Main.addTest(suite, BatchedFillTest.class, "suite");
            } else {
                logger.warn((Object)"skipping BatchedFillTests");
            }
        }
        if (testName != null && !testName.equals("")) {
            Pattern testPattern = Pattern.compile(testName);
            suite = Main.copySuite(suite, testPattern);
        }
        if ((testInfo = testSuiteInfo.get(suite)) != null && testInfo.length() > 0) {
            System.out.println(testInfo);
        } else {
            System.out.println("No tests to run. Check mondrian.properties setting.");
        }
        System.out.flush();
        return suite;
    }

    private static boolean isRunOnce() {
        MondrianProperties properties = MondrianProperties.instance();
        return !properties.Warmup.get() && properties.VUsers.get() == 1 && properties.Iterations.get() == 1;
    }

    private static TestSuite copySuite(TestSuite suite, Pattern testPattern) throws Exception {
        TestSuite newSuite = new TestSuite(suite.getName());
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (test instanceof TestCase) {
                TestCase testCase = (TestCase)test;
                String testName = testCase.getName();
                if (testPattern != null && !testPattern.matcher(testName).matches()) continue;
                Main.addTest(newSuite, test, suite.getName() + testName);
                continue;
            }
            if (test instanceof TestSuite) {
                TestSuite subSuite = Main.copySuite((TestSuite)test, testPattern);
                if (subSuite.countTestCases() <= 0) continue;
                Main.addTest(newSuite, (Test)subSuite, subSuite.getName());
                continue;
            }
            Main.addTest(newSuite, test, " ");
        }
        return newSuite;
    }

    private static void addTest(TestSuite suite, Class<? extends TestCase> testClass) throws Exception {
        int startTestCount = suite.countTestCases();
        suite.addTestSuite(testClass);
        int endTestCount = suite.countTestCases();
        Main.printTestInfo(suite, testClass.getName(), startTestCount, endTestCount);
    }

    private static void addTest(TestSuite suite, Class<? extends TestCase> testClass, String testMethod) throws Exception {
        Method method = testClass.getMethod(testMethod, new Class[0]);
        Object o = method.invoke(null, new Object[0]);
        int startTestCount = suite.countTestCases();
        suite.addTest((Test)o);
        int endTestCount = suite.countTestCases();
        Main.printTestInfo(suite, testClass.getName(), startTestCount, endTestCount);
    }

    private static void addTest(TestSuite suite, Test tests, String testClassName) throws Exception {
        int startTestCount = suite.countTestCases();
        suite.addTest(tests);
        int endTestCount = suite.countTestCases();
        Main.printTestInfo(suite, testClassName, startTestCount, endTestCount);
    }

    private static void printTestInfo(TestSuite suite, String testClassName, int startCount, int endCount) {
        String testInfo = testSuiteInfo.get(suite);
        String newTestInfo = "[" + startCount + " - " + endCount + "] : " + testClassName + "\n";
        testInfo = testInfo == null ? newTestInfo : testInfo + newTestInfo;
        testSuiteInfo.put(suite, testInfo);
    }
}

