/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.MondrianProperties;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class IgnoreUnrelatedDimensionsTest
extends FoodMartTestCase {
    boolean originalNonEmptyFlag;
    private final MondrianProperties prop = MondrianProperties.instance();
    private String cubeSales3 = "<Cube name=\"Sales 3\">\n   <Table name=\"sales_fact_1997\"/>\n   <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n   <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n   <Dimension name=\"Gender\" foreignKey=\"customer_id\">\n     <Hierarchy hasAll=\"true\" defaultMember=\"[Gender].[F]\" allMemberName=\"All Gender\" primaryKey=\"customer_id\">\n       <Table name=\"customer\"/>\n       <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\"/>\n     </Hierarchy>\n   </Dimension>\n   <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\">\n     <CalculatedMemberProperty name=\"MEMBER_ORDINAL\" value=\"2\"/>\n   </Measure>\n</Cube>";
    private String cubeWarehouseAndSales3 = "<VirtualCube name=\"Warehouse and Sales 3\" defaultMeasure=\"Store Invoice\">\n  <CubeUsages>\n   <CubeUsage cubeName=\"Sales 3\" ignoreUnrelatedDimensions=\"true\"/>\n   <CubeUsage cubeName=\"Warehouse\" ignoreUnrelatedDimensions=\"true\"/></CubeUsages>\n  <VirtualCubeDimension cubeName=\"Sales 3\" name=\"Gender\"/>\n  <VirtualCubeDimension name=\"Product\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Store Invoice]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n</VirtualCube>";

    protected void setUp() throws Exception {
        this.originalNonEmptyFlag = this.prop.EnableNonEmptyOnAllAxis.get();
        this.prop.EnableNonEmptyOnAllAxis.set(true);
    }

    protected void tearDown() throws Exception {
        this.prop.EnableNonEmptyOnAllAxis.set(this.originalNonEmptyFlag);
    }

    public TestContext getTestContext() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Warehouse and Sales2\" defaultMeasure=\"Store Sales\">\n  <CubeUsages>   <CubeUsage cubeName=\"Sales\" ignoreUnrelatedDimensions=\"true\"/>\n   <CubeUsage cubeName=\"Warehouse\" ignoreUnrelatedDimensions=\"true\"/>\n  </CubeUsages>  <VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Education Level\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Gender\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Marital Status\"/>\n  <VirtualCubeDimension name=\"Product\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Promotion Media\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Promotions\"/>\n  <VirtualCubeDimension name=\"Store\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Yearly Income\"/>\n  <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Sales Count]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit Growth]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Store Invoice]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Supply Time]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Units Ordered]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Units Shipped]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Profit]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Average Warehouse Sale]\"/>\n  <CalculatedMember name=\"Profit Per Unit Shipped\" dimension=\"Measures\">\n    <Formula>[Measures].[Profit] / [Measures].[Units Shipped]</Formula>\n  </CalculatedMember>\n</VirtualCube>", null, null, null);
        return testContext;
    }

    public void testTotalingOnCrossJoinOfJoiningAndNonJoiningDimensions() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Unit Sales VM] AS 'ValidMeasure([Measures].[Unit Sales])', SOLVE_ORDER = 3000 MEMBER Gender.G AS 'AGGREGATE(CROSSJOIN({[Gender].[Gender].MEMBERS},[WAREHOUSE].[STATE PROVINCE].MEMBERS))'SELECT {[MEASURES].[Unit Sales VM]} ON 0,{Gender.G} ON 1 FROM [WAREHOUSE AND SALES2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales VM]}\nAxis #2:\n{[Gender].[G]}\nRow #0: 266,773\n"));
    }

    public void testVMShouldNotPushUpAggregateMemberDefinedOnNonJoiningDimension() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Total Sales] AS 'ValidMeasure(Measures.[Warehouse Sales]) + [Measures].[Unit Sales]',SOLVE_ORDER = 3000 MEMBER Gender.G AS 'AGGREGATE(CROSSJOIN({GENDER.[M]},{[Product].[All Products].[Drink]}))',SOLVE_ORDER = 4 SELECT {[MEASURES].[Total Sales]} ON 0,{Gender.G} ON 1 FROM [WAREHOUSE AND SALES2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Gender].[G]}\nRow #0: 30,405.602\n"));
    }

    public void testAggregateMemberDefinedOnNonJoiningDimensionWithNonAllDefaultMember() {
        TestContext context = TestContext.create(null, this.cubeSales3, this.cubeWarehouseAndSales3, null, null, null);
        context.assertQueryReturns("WITH MEMBER [Measures].[Total Sales] AS 'ValidMeasure(Measures.[Warehouse Sales]) + [Measures].[Unit Sales]',SOLVE_ORDER = 3000 MEMBER Gender.G AS 'AGGREGATE(CROSSJOIN({GENDER.[M]},{[Product].[All Products].[Drink]}))',SOLVE_ORDER = 4 SELECT {[MEASURES].[Total Sales]} ON 0,{Gender.G} ON 1 FROM [WAREHOUSE AND SALES 3]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Gender].[G]}\nRow #0: 30,405.602\n"));
    }

    public void testTotalingForValidAndNonValidMeasuresWithJoiningDimensions() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Unit Sales VM] AS 'ValidMeasure([Measures].[Unit Sales])',SOLVE_ORDER = 3000 MEMBER PRODUCT.G AS 'AGGREGATE(CROSSJOIN({PRODUCT.[PRODUCT NAME].MEMBERS},[STORE].[STORE NAME].MEMBERS))'SELECT {[MEASURES].[Unit Sales VM], [MEASURES].[STORE COST]} ON 0,{PRODUCT.G} ON 1 FROM [WAREHOUSE AND SALES2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales VM]}\n{[Measures].[Store Cost]}\nAxis #2:\n{[Product].[G]}\nRow #0: 266,773\nRow #0: 225,627.23\n"));
    }

    public void testTotalingWhenIgnoreUnrelatedDimensionsPropertyIsTrue() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Unit Sales VM] AS 'ValidMeasure([Measures].[Unit Sales])', SOLVE_ORDER = 3000 MEMBER [Gender].[COG_OQP_USR_Aggregate(Gender SET)] AS 'IIF([Measures].CURRENTMEMBER IS [Measures].[Unit Sales VM], ([Gender].[COG_OQP_INT_m2], [Measures].[Unit Sales VM]), AGGREGATE([COG_OQP_INT_s1]))', SOLVE_ORDER = 4 MEMBER [Gender].[COG_OQP_INT_m2] AS 'AGGREGATE([COG_OQP_INT_s1])', SOLVE_ORDER = 4 MEMBER [WAREHOUSE].[COG_OQP_USR_Aggregate(WAREHOUSE SET)] AS 'IIF([Measures].CURRENTMEMBER IS [Measures].[Unit Sales VM], ([WAREHOUSE].[COG_OQP_INT_m1], [Measures].[Unit Sales VM]), AGGREGATE({[Warehouse].[State Province].&[DF].[Mexico City].[Freeman And Co], [Warehouse].[State Province].&[BC].[Vancouver].[Bellmont Distributing]}))', SOLVE_ORDER = 8 MEMBER [WAREHOUSE].[COG_OQP_INT_m1] AS 'AGGREGATE({[Warehouse].[State Province].&[DF].[Mexico City].[Freeman And Co], [Warehouse].[State Province].&[BC].[Vancouver].[Bellmont Distributing]})', SOLVE_ORDER = 8 SET [COG_OQP_INT_s2] AS 'CROSSJOIN({[Gender].[All Gender].[M], [Gender].[All Gender].[F]}, {{[Warehouse].[State Province].&[DF].[Mexico City].[Freeman And Co], [Warehouse].[State Province].&[BC].[Vancouver].[Bellmont Distributing]}, {([Warehouse].[COG_OQP_USR_Aggregate(Warehouse SET)])}})' SET [COG_OQP_INT_s1] AS 'CROSSJOIN({[Gender].[All Gender].[M], [Gender].[All Gender].[F]}, {[Warehouse].[State Province].&[DF].[Mexico City].[Freeman And Co], [Warehouse].[State Province].&[BC].[Vancouver].[Bellmont Distributing]})' SELECT {[Measures].[Unit Sales VM]} ON AXIS(0), {[COG_OQP_INT_s2], HEAD({([Gender].[COG_OQP_USR_Aggregate(Gender SET)], [WAREHOUSE].DEFAULTMEMBER)}, IIF(COUNT([COG_OQP_INT_s1], INCLUDEEMPTY) > 0, 1, 0))} ON AXIS(1) FROM [WAREHOUSE AND SALES2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales VM]}\nAxis #2:\n{[Gender].[All Gender].[M], [Warehouse].[All Warehouses].[Mexico].[DF].[Mexico City].[Freeman And Co]}\n{[Gender].[All Gender].[M], [Warehouse].[All Warehouses].[Canada].[BC].[Vancouver].[Bellmont Distributing]}\n{[Gender].[All Gender].[M], [Warehouse].[COG_OQP_USR_Aggregate(WAREHOUSE SET)]}\n{[Gender].[All Gender].[F], [Warehouse].[All Warehouses].[Mexico].[DF].[Mexico City].[Freeman And Co]}\n{[Gender].[All Gender].[F], [Warehouse].[All Warehouses].[Canada].[BC].[Vancouver].[Bellmont Distributing]}\n{[Gender].[All Gender].[F], [Warehouse].[COG_OQP_USR_Aggregate(WAREHOUSE SET)]}\n{[Gender].[COG_OQP_USR_Aggregate(Gender SET)], [Warehouse].[All Warehouses]}\nRow #0: 135,215\nRow #1: 135,215\nRow #2: 135,215\nRow #3: 131,558\nRow #4: 131,558\nRow #5: 131,558\nRow #6: 266,773\n"));
    }

    public void testTotalingOnNonJoiningDimension() {
        this.assertQueryReturns("WITH MEMBER [Measures].[Unit Sales VM] AS 'ValidMeasure([Measures].[Unit Sales])', SOLVE_ORDER =3000MEMBER MEASURES.[VirtualMeasure] AS '[Measures].[Store Invoice]/[Measures].[Unit Sales VM]', SOLVE_ORDER=3000 MEMBER [Warehouse].[COG_OQP_USR_Aggregate(Warehouse set)] AS 'IIF([Measures].CURRENTMEMBER IS [Measures].[VirtualMeasure], ([Warehouse].[COG_OQP_INT_m1], [Measures].[VirtualMeasure]), AGGREGATE({[Warehouse].[All Warehouses].[USA].[OR],[Warehouse].[All Warehouses].[USA].[WA]}))', SOLVE_ORDER = 8 MEMBER [Warehouse].[COG_OQP_INT_m1] AS 'AGGREGATE({[Warehouse].[All Warehouses].[USA].[OR],[Warehouse].[All Warehouses].[USA].[WA]})', SOLVE_ORDER = 8 MEMBER [Product].[COG_OQP_USR_Aggregate(Product Set)1] AS 'IIF([Measures].CURRENTMEMBER IS [Measures].[VirtualMeasure], ([Product].[COG_OQP_INT_m2], [Measures].[VirtualMeasure]), AGGREGATE([COG_OQP_INT_s3]))', SOLVE_ORDER = 4 MEMBER [Product].[COG_OQP_INT_m2] AS 'AGGREGATE([COG_OQP_INT_s3])', SOLVE_ORDER = 4 SET [COG_OQP_INT_s4] AS 'CROSSJOIN({[Product].[All Products].[Drink],[Product].[All Products].[Food]}, {{[Warehouse].[All Warehouses].[USA].[OR],[Warehouse].[All Warehouses].[USA].[WA]}, {([Warehouse].[COG_OQP_USR_Aggregate(Warehouse set)])}})' SET [COG_OQP_INT_s3] AS 'CROSSJOIN({[Product].[All Products].[Drink],[Product].[All Products].[Food]},{{[Warehouse].[All Warehouses].[USA].[OR],[Warehouse].[All Warehouses].[USA].[WA]}})' SET [COG_OQP_INT_s2] AS '{[Measures].[Store Invoice],[Measures].[Unit Sales VM],[Measures].[VirtualMeasure]}' SELECT [COG_OQP_INT_s2] DIMENSION PROPERTIES PARENT_LEVEL, PARENT_UNIQUE_NAME ON AXIS(0), {[COG_OQP_INT_s4], HEAD({([Product].[COG_OQP_USR_Aggregate(Product Set)1], [Warehouse].DEFAULTMEMBER)}, IIF(COUNT([COG_OQP_INT_s3], INCLUDEEMPTY) > 0, 1, 0))} DIMENSION PROPERTIES PARENT_LEVEL, PARENT_UNIQUE_NAME ON AXIS(1) FROM [WAREHOUSE AND SALES2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Invoice]}\n{[Measures].[Unit Sales VM]}\n{[Measures].[VirtualMeasure]}\nAxis #2:\n{[Product].[All Products].[Drink], [Warehouse].[All Warehouses].[USA].[OR]}\n{[Product].[All Products].[Drink], [Warehouse].[All Warehouses].[USA].[WA]}\n{[Product].[All Products].[Drink], [Warehouse].[COG_OQP_USR_Aggregate(Warehouse set)]}\n{[Product].[All Products].[Food], [Warehouse].[All Warehouses].[USA].[OR]}\n{[Product].[All Products].[Food], [Warehouse].[All Warehouses].[USA].[WA]}\n{[Product].[All Products].[Food], [Warehouse].[COG_OQP_USR_Aggregate(Warehouse set)]}\n{[Product].[COG_OQP_USR_Aggregate(Product Set)1], [Warehouse].[All Warehouses]}\nRow #0: 2,057.232\nRow #0: 24,597\nRow #0: 0.084\nRow #1: 4,868.471\nRow #1: 24,597\nRow #1: 0.198\nRow #2: 6,925.702\nRow #2: 24,597\nRow #2: 0.282\nRow #3: 13,726.825\nRow #3: 191,940\nRow #3: 0.072\nRow #4: 37,712.692\nRow #4: 191,940\nRow #4: 0.196\nRow #5: 51,439.517\nRow #5: 191,940\nRow #5: 0.268\nRow #6: 58,365.22\nRow #6: 216,537\nRow #6: 0.27\n"));
    }

    public void testUnrelatedDimPropOverridesIgnoreMeasure() {
        boolean origIgnoreMeasure = this.prop.IgnoreMeasureForNonJoiningDimension.get();
        this.prop.IgnoreMeasureForNonJoiningDimension.set(true);
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Total Sales] AS '[Measures].[Store Sales] + [Measures].[Warehouse Sales]'\nMEMBER [Product].[AggSP1_1] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n[Warehouse].[All Warehouses],\n[Warehouse].[All Warehouses])'\nMEMBER [Product].[AggSP1_2] AS\n'IIF([Measures].CURRENTMEMBER IS [Measures].[Total Sales],\n([Warehouse].[All Warehouses]),\n([Warehouse].[All Warehouses]))'\n\nSELECT\n{[Measures].[Total Sales]} ON AXIS(0),\n{[Product].[AggSP1_1], [Product].[AggSP1_2]} ON AXIS(1)\nFROM\n[Warehouse and Sales2]", IgnoreUnrelatedDimensionsTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Total Sales]}\nAxis #2:\n{[Product].[AggSP1_1]}\n{[Product].[AggSP1_2]}\nRow #0: 762,009.02\nRow #1: 762,009.02\n"));
        this.prop.IgnoreMeasureForNonJoiningDimension.set(origIgnoreMeasure);
    }
}

