/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import mondrian.olap.MondrianProperties;
import mondrian.olap.Result;
import mondrian.test.TestContext;
import mondrian.test.loader.CsvDBTestCase;

public class Checkin_7634
extends CsvDBTestCase {
    private static final String DIRECTORY = "testsrc/main/mondrian/rolap/aggmatcher";
    private static final String CHECKIN_7634 = "Checkin_7634.csv";
    private int crossJoinSize;

    public Checkin_7634() {
    }

    public Checkin_7634(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.crossJoinSize = MondrianProperties.instance().CrossJoinOptimizerSize.get();
    }

    protected void tearDown() throws Exception {
        MondrianProperties.instance().CrossJoinOptimizerSize.set(this.crossJoinSize);
        super.tearDown();
    }

    public void testCrossJoin() throws Exception {
        String mdx = "select {[Measures].[Requested Value]} ON COLUMNS, NON EMPTY Crossjoin( {[Geography].[All Regions].Children}, {[Product].[All Products].Children}) ON ROWS from [Checkin_7634]";
        MondrianProperties.instance().CrossJoinOptimizerSize.set(Integer.MAX_VALUE);
        Result result1 = this.getCubeTestContext().executeQuery(mdx);
        String resultString1 = TestContext.toString(result1);
        MondrianProperties.instance().CrossJoinOptimizerSize.set(0);
        Result result2 = this.getCubeTestContext().executeQuery(mdx);
        String resultString2 = TestContext.toString(result2);
        Checkin_7634.assertEquals((String)resultString1, (String)resultString2);
    }

    protected String getDirectoryName() {
        return DIRECTORY;
    }

    protected String getFileName() {
        return CHECKIN_7634;
    }

    protected String getCubeDescription() {
        return "<Cube name='Checkin_7634'>\n<Table name='table7634'/>\n<Dimension name='Geography' foreignKey='cust_loc_id'>\n<Hierarchy hasAll='true' allMemberName='All Regions' defaultMember='' primaryKey='cust_loc_id'>\n<Table name='geography7631'/>\n<Level column='state_cd' name='State' type='String' uniqueMembers='true'/>\n<Level column='city_nm' name='City' type='String' uniqueMembers='true'/>\n<Level column='zip_cd' name='Zip Code' type='String' uniqueMembers='true'/>\n</Hierarchy>\n</Dimension>\n<Dimension name='Product' foreignKey='prod_id'>\n<Hierarchy hasAll='true' allMemberName='All Products' defaultMember='' primaryKey='prod_id'>\n<Table name='prod7631'/>\n<Level column='class' name='Class' type='String' uniqueMembers='true'/>\n<Level column='brand' name='Brand' type='String' uniqueMembers='true'/>\n<Level column='item' name='Item' type='String' uniqueMembers='true'/>\n</Hierarchy>\n</Dimension>\n<Measure name='First Measure' \n    column='first' aggregator='sum'\n   formatString='#,###'/>\n<Measure name='Requested Value' \n    column='request_value' aggregator='sum'\n   formatString='#,###'/>\n<Measure name='Shipped Value' \n    column='shipped_value' aggregator='sum'\n   formatString='#,###'/>\n</Cube>";
    }
}

