/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import mondrian.olap.fun.FunUtil;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ReverseComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialSortTest
extends TestCase {
    final Random random = new Random();

    private Integer[] newRandomIntegers(int length, int minValue, int maxValue) {
        int delta = maxValue - minValue;
        Integer[] vec = new Integer[length];
        for (int i = 0; i < length; ++i) {
            vec[i] = minValue + this.random.nextInt(delta);
        }
        return vec;
    }

    private void doPartialSort(Object[] items, boolean descending, int limit) {
        Comparator comp = ComparatorUtils.naturalComparator();
        if (descending) {
            comp = ComparatorUtils.reversedComparator((Comparator)comp);
        }
        FunUtil.partialSort(items, comp, limit);
    }

    private static boolean isPartiallySorted(int[] vec, int limit, boolean descending) {
        for (int i = 1; i < limit; ++i) {
            int delta = vec[i] - vec[i - 1];
            if (!(descending ? delta > 0 : delta < 0)) continue;
            return false;
        }
        int bound = vec[limit - 1];
        for (int i = limit; i < vec.length; ++i) {
            int delta = vec[i] - bound;
            if (!(descending ? delta > 0 : delta < 0)) continue;
            return false;
        }
        return true;
    }

    private static <T extends Comparable> boolean isPartiallySorted(T[] vec, int limit, boolean descending) {
        return PartialSortTest.isPartiallySorted(vec, limit, ComparatorUtils.naturalComparator(), descending);
    }

    private static <T> boolean isPartiallySorted(T[] vec, int limit, Comparator<? super T> order, boolean descending) {
        return PartialSortTest.isPartiallySorted(vec, limit, order, descending, null);
    }

    private static <T> boolean isPartiallySorted(T[] vec, int limit, Comparator<? super T> order, boolean descending, Comparator<? super T> tieBreaker) {
        for (int i = 1; i < limit; ++i) {
            int delta = order.compare(vec[i], vec[i - 1]);
            if (!(delta == 0 ? tieBreaker != null && tieBreaker.compare(vec[i], vec[i - 1]) < 0 : (descending ? delta > 0 : delta < 0))) continue;
            return false;
        }
        T bound = vec[limit - 1];
        for (int i = limit; i < vec.length; ++i) {
            int delta = order.compare(vec[i], bound);
            if (!(descending ? delta > 0 : delta < 0)) continue;
            return false;
        }
        return true;
    }

    public void testPredicate1() {
        int i;
        int errct = 0;
        int size = 10000;
        int[] vec = new int[size];
        int key = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            vec[i2] = key;
            key += i2 % 3;
        }
        if (PartialSortTest.isPartiallySorted(vec, size, true)) {
            ++errct;
        }
        if (!PartialSortTest.isPartiallySorted(vec, size, false)) {
            ++errct;
        }
        key = 0;
        int limit = 2000;
        for (i = 0; i < limit; ++i) {
            vec[i] = key;
            key += i % 3;
        }
        for (i = limit; i < size; ++i) {
            vec[i] = 2 * key + this.random.nextInt(1000);
        }
        if (PartialSortTest.isPartiallySorted(vec, limit, true)) {
            ++errct;
        }
        if (!PartialSortTest.isPartiallySorted(vec, limit, false)) {
            ++errct;
        }
        key = 2 * size;
        for (i = 0; i < size; ++i) {
            vec[i] = key;
            key -= i % 3;
        }
        if (!PartialSortTest.isPartiallySorted(vec, size, true)) {
            ++errct;
        }
        if (PartialSortTest.isPartiallySorted(vec, size, false)) {
            ++errct;
        }
        key = 2 * size;
        limit = 2000;
        for (i = 0; i < limit; ++i) {
            vec[i] = key;
            key -= i % 3;
        }
        for (i = limit; i < size; ++i) {
            vec[i] = key - this.random.nextInt(size);
        }
        if (!PartialSortTest.isPartiallySorted(vec, limit, true)) {
            ++errct;
        }
        if (PartialSortTest.isPartiallySorted(vec, limit, false)) {
            ++errct;
        }
        PartialSortTest.assertTrue((errct == 0 ? 1 : 0) != 0);
    }

    public void testPredicate2() {
        int i;
        int errct = 0;
        int size = 10000;
        Comparable[] vec = new Integer[size];
        Random random = new Random();
        int key = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            vec[i2] = Integer.valueOf(key);
            key += i2 % 3;
        }
        if (PartialSortTest.isPartiallySorted((Comparable[])vec, (int)size, (boolean)true)) {
            ++errct;
        }
        if (!PartialSortTest.isPartiallySorted((Comparable[])vec, (int)size, (boolean)false)) {
            ++errct;
        }
        key = 0;
        int limit = 2000;
        for (i = 0; i < limit; ++i) {
            vec[i] = Integer.valueOf(key);
            key += i % 3;
        }
        for (i = limit; i < size; ++i) {
            vec[i] = Integer.valueOf(2 * key + random.nextInt(1000));
        }
        if (PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)true)) {
            ++errct;
        }
        if (!PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)false)) {
            ++errct;
        }
        key = 2 * size;
        for (i = 0; i < size; ++i) {
            vec[i] = Integer.valueOf(key);
            key -= i % 3;
        }
        if (!PartialSortTest.isPartiallySorted((Comparable[])vec, (int)size, (boolean)true)) {
            ++errct;
        }
        if (PartialSortTest.isPartiallySorted((Comparable[])vec, (int)size, (boolean)false)) {
            ++errct;
        }
        key = 2 * size;
        limit = 2000;
        for (i = 0; i < limit; ++i) {
            vec[i] = Integer.valueOf(key);
            key -= i % 3;
        }
        for (i = limit; i < size; ++i) {
            vec[i] = Integer.valueOf(key - random.nextInt(size));
        }
        if (!PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)true)) {
            ++errct;
        }
        if (PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)false)) {
            ++errct;
        }
        PartialSortTest.assertTrue((errct == 0 ? 1 : 0) != 0);
    }

    public void testQuick() {
        int length = 40;
        int limit = 4;
        Object[] vec = this.newRandomIntegers(40, 0, 40);
        this.doPartialSort(vec, true, 4);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)4, (boolean)true));
    }

    public void testOnAlreadySorted() {
        int length = 200;
        int limit = 8;
        Object[] vec = new Integer[200];
        for (int i = 0; i < 200; ++i) {
            vec[i] = i;
        }
        this.doPartialSort(vec, false, 8);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)8, (boolean)false));
    }

    public void testOnAlreadyReverseSorted() {
        int length = 200;
        int limit = 8;
        Object[] vec = new Integer[200];
        for (int i = 0; i < 200; ++i) {
            vec[i] = 200 - i;
        }
        this.doPartialSort(vec, false, 8);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)8, (boolean)false));
    }

    private void randomIntegerTests(int length, int limit) {
        Object[] vec = this.newRandomIntegers(length, 0, length);
        this.doPartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)true));
        vec = this.newRandomIntegers(length, 0, length);
        this.doPartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)false));
        vec = this.newRandomIntegers(length, 10, 4 * length);
        this.doPartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)true));
        vec = this.newRandomIntegers(length, 10, 4 * length);
        this.doPartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)false));
        vec = this.newRandomIntegers(length, 0, length / 10);
        this.doPartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)true));
        vec = this.newRandomIntegers(length, 0, length / 10);
        this.doPartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)PartialSortTest.isPartiallySorted((Comparable[])vec, (int)limit, (boolean)false));
    }

    public void testOnRandomIntegers() {
        this.randomIntegerTests(100, 20);
        this.randomIntegerTests(50000, 10);
        this.randomIntegerTests(50000, 500);
        this.randomIntegerTests(50000, 12000);
    }

    public void testOnManyRandomIntegers() {
        this.randomIntegerTests(1000000, 5000);
        this.randomIntegerTests(1000000, 10);
    }

    public void longTest() {
        int count = 128;
        while (count-- > 0) {
            this.testOnRandomIntegers();
        }
    }

    private Item[] newPartlySortedItems(int length, int limit, boolean desc) {
        int i;
        Item[] vec = new Item[length];
        int factor = desc ? -1 : 1;
        int key = desc ? 2 * length : 0;
        for (i = 0; i < limit; ++i) {
            vec[i] = new Item(i, key);
            key += factor * (i % 3);
        }
        while (i < length) {
            vec[i] = new Item(i, key + factor * this.random.nextInt(length));
            ++i;
        }
        return vec;
    }

    private Item[] newRandomItems(int length, int minKey, int maxKey) {
        int delta = maxKey - minKey;
        Item[] vec = new Item[length];
        for (int i = 0; i < length; ++i) {
            vec[i] = new Item(i, minKey + this.random.nextInt(delta));
        }
        return vec;
    }

    private Item[] doStablePartialSort(Item[] vec, boolean desc, int limit) {
        ReverseComparator comp = Item.byKey;
        if (desc) {
            comp = new ReverseComparator(comp);
        }
        List<Item> sorted = FunUtil.stablePartialSort(Arrays.asList(vec), comp, limit);
        return sorted.toArray(new Item[0]);
    }

    public void testPredicateIsStablySorted() {
        Item[] vec = this.newPartlySortedItems(24, 4, false);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 4, false));
        PartialSortTest.assertFalse((boolean)Item.isStablySorted(vec, 4, true));
        vec = this.newPartlySortedItems(24, 8, true);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 4, true));
        PartialSortTest.assertFalse((boolean)Item.isStablySorted(vec, 4, false));
        vec = this.newPartlySortedItems(1000, 100, true);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 100, true));
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 20, true));
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 4, true));
    }

    public void testStableQuick() {
        int length = 40;
        int limit = 4;
        Item[] vec = this.newRandomItems(40, 0, 40);
        vec = this.doStablePartialSort(vec, true, 4);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, 4, true));
    }

    private void randomItemTests(int length, int limit) {
        Item[] vec = this.newRandomItems(length, 0, length);
        vec = this.doStablePartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, true));
        vec = this.newRandomItems(length, 0, length);
        vec = this.doStablePartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, false));
        vec = this.newRandomItems(length, 10, 4 * length);
        vec = this.doStablePartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, true));
        vec = this.newRandomItems(length, 10, 4 * length);
        vec = this.doStablePartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, false));
        vec = this.newRandomItems(length, 0, length / 10);
        vec = this.doStablePartialSort(vec, true, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, true));
        vec = this.newRandomItems(length, 0, length / 10);
        vec = this.doStablePartialSort(vec, false, limit);
        PartialSortTest.assertTrue((boolean)Item.isStablySorted(vec, limit, false));
    }

    public void testStableOnRandomItems() {
        this.randomItemTests(100, 20);
        this.randomItemTests(50000, 10);
        this.randomItemTests(50000, 500);
        this.randomItemTests(50000, 12000);
    }

    private void speedTest(int length, int limit) {
        System.out.println("sorting the max " + limit + " of " + length + " random Integers");
        Object[] vec1 = this.newRandomIntegers(length, 0, length / 5);
        Object[] vec2 = new Integer[length];
        Integer[] vec3 = new Integer[length];
        System.arraycopy(vec1, 0, vec2, 0, length);
        System.arraycopy(vec1, 0, vec3, 0, length);
        long now = System.currentTimeMillis();
        Arrays.sort(vec1);
        long dt = System.currentTimeMillis() - now;
        System.out.println(" full mergesort took " + dt + " msecs");
        now = System.currentTimeMillis();
        this.doPartialSort(vec2, true, limit);
        dt = System.currentTimeMillis() - now;
        System.out.println(" partial quicksort took " + dt + " msecs");
        ReverseComparator comp = new ReverseComparator(ComparatorUtils.naturalComparator());
        List<Integer> vec3List = Arrays.asList(vec3);
        now = System.currentTimeMillis();
        FunUtil.stablePartialSort(vec3List, comp, limit);
        dt = System.currentTimeMillis() - now;
        System.out.println(" stable partial quicksort took " + dt + " msecs");
    }

    public void _testSpeed() {
        this.speedTest(60, 2);
        this.speedTest(600, 12);
        this.speedTest(600, 200);
        this.speedTest(16000, 4);
        this.speedTest(16000, 160);
        this.speedTest(160000, 4);
    }

    static class Item {
        final int index;
        final int key;
        static final Comparator<Item> byIndex = new Comparator<Item>(){

            @Override
            public int compare(Item x, Item y) {
                return x.index - y.index;
            }
        };
        static final Comparator<Item> byKey = new Comparator<Item>(){

            @Override
            public int compare(Item x, Item y) {
                return x.key - y.key;
            }
        };

        Item(int index, int key) {
            this.index = index;
            this.key = key;
        }

        static boolean isStablySorted(Item[] vec, int limit, boolean desc) {
            return PartialSortTest.isPartiallySorted(vec, limit, Item.byKey, desc, Item.byIndex);
        }
    }
}

