/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.macros.storage.ui.MacrosPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class MacrosPanelController
extends OptionsPanelController {
    private static final Map<Lookup, Reference<MacrosPanel>> PANELS = new WeakHashMap<Lookup, Reference<MacrosPanel>>();
    private MacrosPanel lastPanel = null;

    public void update() {
        MacrosModel macrosModel = this.lastPanel.getModel();
        if (!macrosModel.isLoaded()) {
            macrosModel.load();
        }
    }

    public void applyChanges() {
        this.lastPanel.getModel().save();
    }

    public void cancel() {
        this.lastPanel.getModel().load();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.lastPanel.getModel().isChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.editor.macros");
    }

    public JComponent getComponent(Lookup lookup) {
        return this.getMacrosPanel(lookup);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.lastPanel.getModel().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.lastPanel.getModel().removePropertyChangeListener(propertyChangeListener);
    }

    private MacrosPanel getMacrosPanel(Lookup lookup) {
        MacrosPanel macrosPanel;
        Reference<MacrosPanel> reference = PANELS.get(lookup);
        MacrosPanel macrosPanel2 = macrosPanel = reference == null ? null : reference.get();
        if (macrosPanel == null) {
            macrosPanel = new MacrosPanel(lookup);
            PANELS.put(lookup, new WeakReference<MacrosPanel>(macrosPanel));
        }
        this.lastPanel = macrosPanel;
        return macrosPanel;
    }
}

