/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.fontscolors.CompositeFCS;
import org.netbeans.modules.editor.settings.storage.fontscolors.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.keybindings.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.preferences.PreferencesImpl;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SettingsProvider
implements MimeDataProvider {
    private static final Logger LOG = Logger.getLogger(SettingsProvider.class.getName());
    private final Map<MimePath, WeakReference<Lookup>> cache = new WeakHashMap<MimePath, WeakReference<Lookup>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup(MimePath mimePath) {
        if (mimePath.size() > 0 && mimePath.getMimeType(0).contains("text/base")) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Won't provide any settings for text/base It's been deprecated, use MimePath.EMPTY instead.");
            }
            return null;
        }
        Map<MimePath, WeakReference<Lookup>> map = this.cache;
        synchronized (map) {
            Object object;
            WeakReference<Lookup> weakReference = this.cache.get(mimePath);
            Lookup lookup = object = weakReference == null ? null : (Lookup)weakReference.get();
            if (object == null) {
                String string = mimePath.getPath();
                if (string.startsWith("test")) {
                    int n = string.indexOf(95);
                    if (n == -1) {
                        throw new IllegalStateException("Invalid mimePath: " + string);
                    }
                    String string2 = string.substring(0, n);
                    MimePath mimePath2 = MimePath.parse((String)string.substring(n + 1));
                    object = new ProxyLookup(new Lookup[]{new MyLookup(mimePath2, string2), Lookups.exclude((Lookup)MimeLookup.getLookup((MimePath)mimePath2), (Class[])new Class[]{FontColorSettings.class, KeyBindingSettings.class})});
                } else {
                    object = new MyLookup(mimePath, null);
                }
                this.cache.put(mimePath, new WeakReference<Lookup>((Lookup)object));
            }
            return object;
        }
    }

    private static final class MyLookup
    extends AbstractLookup
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private final MimePath mimePath;
        private final boolean specialFcsProfile;
        private String fcsProfile;
        private final InstanceContent ic;
        private CompositeFCS fontColorSettings = null;
        private Object keyBindingSettings = null;
        private PreferencesImpl preferences = null;
        private KeyBindingSettingsImpl kbsi;

        public MyLookup(MimePath mimePath, String string) {
            this(mimePath, string, new InstanceContent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                boolean bl = false;
                boolean bl2 = false;
                if (this.kbsi == propertyChangeEvent.getSource()) {
                    bl2 = true;
                } else if (propertyChangeEvent.getPropertyName() == null) {
                    if (!this.specialFcsProfile) {
                        String string = EditorSettings.getDefault().getCurrentFontColorProfile();
                        this.fcsProfile = FontColorSettingsImpl.get(this.mimePath).getInternalFontColorProfile(string);
                    }
                    bl = true;
                } else if (propertyChangeEvent.getPropertyName().equals("editorFontColors")) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile)) {
                        bl = true;
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("fontColors")) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile)) {
                        MimePath mimePath = (MimePath)propertyChangeEvent.getOldValue();
                        if (this.fontColorSettings != null && this.fontColorSettings.isDerivedFromMimePath(mimePath)) {
                            bl = true;
                        }
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("currentFontColorProfile") && !this.specialFcsProfile) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    this.fcsProfile = FontColorSettingsImpl.get(this.mimePath).getInternalFontColorProfile(string);
                    bl = true;
                }
                this.updateContents(bl2, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || string.equals("textAntialiasing")) {
                MyLookup myLookup = this;
                synchronized (myLookup) {
                    this.updateContents(false, true);
                }
            }
        }

        private MyLookup(MimePath mimePath, String string, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            Object object;
            this.mimePath = mimePath;
            if (string == null) {
                object = EditorSettings.getDefault().getCurrentFontColorProfile();
                this.fcsProfile = FontColorSettingsImpl.get(mimePath).getInternalFontColorProfile((String)object);
                this.specialFcsProfile = false;
            } else {
                this.fcsProfile = string;
                this.specialFcsProfile = true;
            }
            this.ic = instanceContent;
            object = EditorSettings.getDefault();
            ((EditorSettings)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
            this.kbsi = KeyBindingSettingsImpl.get(mimePath);
            this.kbsi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.kbsi));
            if (this.preferences == null) {
                this.preferences = PreferencesImpl.get(mimePath);
                this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.preferences));
            }
            this.fontColorSettings = new CompositeFCS(mimePath, this.fcsProfile, this.preferences);
            this.keyBindingSettings = this.kbsi.createInstanceForLookup();
            instanceContent.set(Arrays.asList(new Object[]{this.fontColorSettings, this.keyBindingSettings, this.preferences}), null);
        }

        private void updateContents(boolean bl, boolean bl2) {
            boolean bl3 = false;
            if (bl2 && this.fontColorSettings != null) {
                this.fontColorSettings = new CompositeFCS(this.mimePath, this.fcsProfile, this.preferences);
                bl3 = true;
            }
            if (bl && this.keyBindingSettings != null) {
                this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                bl3 = true;
            }
            if (bl3) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (this.fontColorSettings != null) {
                    arrayList.add((Object)this.fontColorSettings);
                }
                if (this.keyBindingSettings != null) {
                    arrayList.add(this.keyBindingSettings);
                }
                if (this.preferences != null) {
                    arrayList.add(this.preferences);
                }
                this.ic.set(arrayList, null);
            }
        }
    }
}

