/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.LabelProperties;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.icon.SortArrowIcon;
import org.jdesktop.swingx.plaf.ColumnHeaderRendererAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class ColumnHeaderRenderer
extends JComponent
implements TableCellRenderer,
UIResource {
    public static final String UP_ICON_KEY = "ColumnHeaderRenderer.upIcon";
    public static final String DOWN_ICON_KEY = "ColumnHeaderRenderer.downIcon";
    private static TableCellRenderer sharedInstance;
    private static Icon defaultDownIcon;
    private static Icon defaultUpIcon;
    private Icon downIcon = defaultDownIcon;
    private Icon upIcon = defaultUpIcon;
    private IconBorder iconBorder = new IconBorder();
    private boolean antiAliasedText = false;
    private TableCellRenderer delegateRenderer;
    private LabelProperties label = new LabelProperties();

    public static TableCellRenderer getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ColumnHeaderRenderer();
        }
        return sharedInstance;
    }

    public static ColumnHeaderRenderer createColumnHeaderRenderer() {
        return new ColumnHeaderRenderer();
    }

    public ColumnHeaderRenderer() {
        this.initDelegate();
        this.updateIconUI();
    }

    public ColumnHeaderRenderer(JTableHeader header) {
        this.updateUI(header);
    }

    private void initDelegate() {
        JTableHeader header = new JTableHeader();
        this.delegateRenderer = header.getDefaultRenderer();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component comp = this.configureDelegate(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        if (table instanceof JXTable && comp instanceof JComponent) {
            SortOrder sortOrder = ((JXTable)table).getSortOrder(columnIndex);
            Border border = UIManager.getBorder("TableHeader.cellBorder");
            if (sortOrder.isSorted()) {
                this.iconBorder.setIcon(sortOrder.isAscending() ? this.upIcon : this.downIcon);
                Border origBorder = ((JComponent)comp).getBorder();
                border = new CompoundBorder(origBorder, this.iconBorder);
                ((JComponent)comp).setBorder(border);
            }
        }
        this.adjustComponentOrientation(comp);
        return comp;
    }

    protected void adjustComponentOrientation(Component stamp) {
        if (stamp.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        stamp.applyComponentOrientation(this.getComponentOrientation());
    }

    private Component configureDelegate(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component comp = this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        this.applyLabelProperties(comp);
        return comp;
    }

    private void applyLabelProperties(Component delegateRendererComponent) {
        if (delegateRendererComponent instanceof JLabel) {
            this.label.applyPropertiesTo((JLabel)delegateRendererComponent);
        } else {
            this.label.applyPropertiesTo(this.delegateRenderer);
        }
    }

    public void setAntiAliasedText(boolean antiAlias) {
        this.antiAliasedText = antiAlias;
    }

    public boolean getAntiAliasedText() {
        return this.antiAliasedText;
    }

    public void setBackground(Color background) {
        if (this.label != null) {
            this.label.setBackground(background);
        }
    }

    public void setForeground(Color foreground) {
        if (this.label != null) {
            this.label.setForeground(foreground);
        }
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setDownIcon(Icon icon) {
        this.downIcon = icon;
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setUpIcon(Icon icon) {
        this.upIcon = icon;
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setHorizontalAlignment(int alignment) {
        this.label.setHorizontalAlignment(alignment);
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int textPosition) {
        this.label.setHorizontalTextPosition(textPosition);
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int iconTextGap) {
        this.label.setIconTextGap(iconTextGap);
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setVerticalAlignment(int alignment) {
        this.label.setVerticalAlignment(alignment);
    }

    public int getVerticalAlignment() {
        return this.label.getVerticalAlignment();
    }

    public void setVerticalTextPosition(int textPosition) {
        this.label.setVerticalTextPosition(textPosition);
    }

    public int getVerticalTextPosition() {
        return this.label.getVerticalTextPosition();
    }

    public TableCellRenderer getDelegateRenderer() {
        return this.delegateRenderer;
    }

    public void updateUI() {
        super.updateUI();
        this.initDelegate();
        this.updateIconUI();
    }

    public void updateUI(JTableHeader header) {
        this.updateIconUI();
        if (header.getDefaultRenderer() != this) {
            this.delegateRenderer = header.getDefaultRenderer();
        }
    }

    private void updateIconUI() {
        Icon icon;
        if (this.getUpIcon() instanceof UIResource) {
            icon = UIManager.getIcon(UP_ICON_KEY);
            this.setUpIcon(icon != null ? icon : defaultUpIcon);
        }
        if (this.getDownIcon() instanceof UIResource) {
            icon = UIManager.getIcon(DOWN_ICON_KEY);
            this.setDownIcon(icon != null ? icon : defaultDownIcon);
        }
    }

    static {
        LookAndFeelAddons.contribute(new ColumnHeaderRendererAddon());
        sharedInstance = null;
        defaultDownIcon = new SortArrowIcon(false);
        defaultUpIcon = new SortArrowIcon(true);
    }
}

