/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.EventObject;
import java.util.logging.Level;

public class MessageEvent
extends EventObject {
    private Object value;
    private long when;
    private Level level = Level.INFO;

    public MessageEvent(Object source) {
        super(source);
    }

    public MessageEvent(Object source, Object message) {
        this(source, message, Level.INFO);
    }

    public MessageEvent(Object source, Object value, Level level) {
        this(source, value, level, 0L);
    }

    public MessageEvent(Object source, Object value, Level level, long when) {
        super(source);
        this.value = value;
        this.level = level;
        this.when = when;
    }

    public String getMessage() {
        if (this.value != null) {
            Throwable t = this.getThrowable();
            if (t != null) {
                return t.getMessage();
            }
            return this.value.toString();
        }
        return "";
    }

    public Throwable getThrowable() {
        if (this.value != null && this.value instanceof Throwable) {
            return (Throwable)this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public long getWhen() {
        return this.when;
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = Level.INFO;
        }
        return this.level;
    }

    public String toString() {
        String message = "value=" + this.getMessage();
        message = message + ", level=" + this.getLevel();
        message = message + ", when=" + this.getWhen();
        return message;
    }
}

