/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class PatternPredicate
implements HighlightPredicate {
    public static final int ALL = -1;
    private int highlightColumn;
    private int testColumn;
    private Pattern pattern;

    public PatternPredicate(Pattern pattern, int testColumn) {
        this(pattern, testColumn, -1);
    }

    public PatternPredicate(Pattern pattern, int testColumn, int decorateColumn) {
        this.pattern = pattern;
        this.testColumn = testColumn;
        this.highlightColumn = decorateColumn;
    }

    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
        if (this.isHighlightCandidate(renderer, adapter)) {
            return this.test(renderer, adapter);
        }
        return false;
    }

    private boolean test(Component renderer, ComponentAdapter adapter) {
        if (!adapter.isTestable(this.testColumn)) {
            return false;
        }
        Object value = adapter.getFilteredValueAt(adapter.row, this.testColumn);
        if (value == null) {
            return false;
        }
        return this.pattern.matcher(value.toString()).find();
    }

    private boolean isHighlightCandidate(Component renderer, ComponentAdapter adapter) {
        return this.pattern != null && (this.highlightColumn < 0 || this.highlightColumn == adapter.viewToModel(adapter.column));
    }

    public int getHighlightColumn() {
        return this.highlightColumn;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getTestColumn() {
        return this.testColumn;
    }
}

