/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AutoCompleteDocument
extends PlainDocument {
    boolean selecting = false;
    boolean strictMatching;
    AbstractAutoCompleteAdaptor adaptor;
    ObjectToStringConverter stringConverter;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter) {
        this.adaptor = adaptor;
        this.strictMatching = strictMatching;
        this.stringConverter = stringConverter;
        Object selected = adaptor.getSelectedItem();
        if (selected != null) {
            this.setText(stringConverter.getPreferredStringForItem(selected));
        }
        adaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching) {
        this(adaptor, strictMatching, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(offs, len);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(offs);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        LookupResult lookupResult = this.lookupItem(this.getText(0, this.getLength()));
        if (lookupResult.matchingItem != null) {
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else if (this.strictMatching) {
            lookupResult.matchingItem = this.adaptor.getSelectedItem();
            lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            lookupResult.matchingItem = this.getText(0, this.getLength());
            lookupResult.matchingString = this.getText(0, this.getLength());
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(offs + str.length());
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void setSelectedItem(Object item, String itemAsString) {
        this.selecting = true;
        this.adaptor.setSelectedItem(item);
        this.adaptor.setSelectedItemAsString(itemAsString);
        this.selecting = false;
    }

    private LookupResult lookupItem(String pattern) {
        int j;
        String[] possibleStrings;
        Object currentItem;
        int i;
        Object selectedItem = this.adaptor.getSelectedItem();
        int n = this.adaptor.getItemCount();
        for (i = 0; i < n; ++i) {
            currentItem = this.adaptor.getItem(i);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j = 0; j < possibleStrings.length; ++j) {
                if (!possibleStrings[j].equalsIgnoreCase(pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j]);
            }
        }
        possibleStrings = this.stringConverter.getPossibleStringsForItem(selectedItem);
        if (possibleStrings != null) {
            for (i = 0; i < possibleStrings.length; ++i) {
                if (!this.startsWithIgnoreCase(possibleStrings[i], pattern)) continue;
                return new LookupResult(selectedItem, possibleStrings[i]);
            }
        }
        n = this.adaptor.getItemCount();
        for (i = 0; i < n; ++i) {
            currentItem = this.adaptor.getItem(i);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j = 0; j < possibleStrings.length; ++j) {
                if (!this.startsWithIgnoreCase(possibleStrings[j], pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j]);
            }
        }
        return new LookupResult(null, "");
    }

    private boolean startsWithIgnoreCase(String base, String prefix) {
        if (base.length() < prefix.length()) {
            return false;
        }
        return base.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static class LookupResult {
        Object matchingItem;
        String matchingString;

        public LookupResult(Object matchingItem, String matchingString) {
            this.matchingItem = matchingItem;
            this.matchingString = matchingString;
        }
    }
}

