/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.Searchable;

public class JXFindBar
extends JXFindPanel {
    protected Color previousBackgroundColor;
    protected Color previousForegroundColor;
    protected Color notFoundBackgroundColor = Color.decode("#FF6666");
    protected Color notFoundForegroundColor = Color.white;
    protected JButton findNext;
    protected JButton findPrevious;

    public JXFindBar() {
        this((Searchable)null);
    }

    public JXFindBar(Searchable searchable) {
        super(searchable);
        this.getPatternModel().setIncremental(true);
        this.getPatternModel().setWrapping(true);
    }

    public void setSearchable(Searchable searchable) {
        super.setSearchable(searchable);
        this.match();
    }

    protected void showNotFoundMessage() {
        if (this.searchField == null) {
            return;
        }
        this.searchField.setForeground(this.notFoundForegroundColor);
        this.searchField.setBackground(this.notFoundBackgroundColor);
    }

    protected void showFoundMessage() {
        if (this.searchField == null) {
            return;
        }
        this.searchField.setBackground(this.previousBackgroundColor);
        this.searchField.setForeground(this.previousForegroundColor);
    }

    public void addNotify() {
        super.addNotify();
        if (this.previousBackgroundColor == null) {
            this.previousBackgroundColor = this.searchField.getBackground();
            this.previousForegroundColor = this.searchField.getForeground();
        } else {
            this.searchField.setBackground(this.previousBackgroundColor);
            this.searchField.setForeground(this.previousForegroundColor);
        }
    }

    public void cancel() {
    }

    protected void initExecutables() {
        this.getActionMap().put("close", this.createBoundAction("close", "cancel"));
        super.initExecutables();
    }

    protected void bind() {
        super.bind();
        this.searchField.addActionListener(this.getAction("execute"));
        this.findNext.setAction(this.getAction("findNext"));
        this.findPrevious.setAction(this.getAction("findPrevious"));
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        this.getInputMap(1).put(stroke, "close");
    }

    protected void build() {
        this.setLayout(new FlowLayout(10));
        this.add(this.searchLabel);
        this.add(new JLabel(":"));
        this.add(new JLabel("  "));
        this.add(this.searchField);
        this.add(this.findNext);
        this.add(this.findPrevious);
    }

    protected void initComponents() {
        super.initComponents();
        this.findNext = new JButton();
        this.findPrevious = new JButton();
    }
}

