/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLHistoryPersistenceManager {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history";
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int MODIFY = 2;
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPersistenceManager.class.getName());
    private static SQLHistoryPersistenceManager _instance = null;
    private static Document document;
    private List<SQLHistory> sqlHistoryList;
    private int numElemsToRemove = 0;

    private SQLHistoryPersistenceManager() {
    }

    public static SQLHistoryPersistenceManager getInstance() {
        if (null == _instance) {
            _instance = new SQLHistoryPersistenceManager();
        }
        return _instance;
    }

    public void removeHistoryFile(FileObject fileObject) {
        try {
            FileObject fileObject2 = DataFolder.findFolder((FileObject)fileObject).getPrimaryFile();
            String string = FileUtil.getFileDisplayName((FileObject)fileObject2) + File.separator + SQL_HISTORY_FILE_NAME + ".xml";
            FileObject fileObject3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
            fileObject3.delete();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void create(FileObject fileObject, List<SQLHistory> list) throws SQLHistoryException {
        try {
            this.sqlHistoryList = list;
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            AtomicFileAction atomicFileAction = new AtomicFileAction(dataFolder, null, 1, list);
            dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicFileAction);
        }
        catch (IOException iOException) {
            throw new SQLHistoryException();
        }
    }

    public List<SQLHistory> retrieve(String string, FileObject fileObject) throws ClassNotFoundException, SQLHistoryException {
        Handler handler = null;
        try {
            handler = new Handler(string);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            AtomicFileAction atomicFileAction = new AtomicFileAction(dataFolder, handler, 0, null);
            dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicFileAction);
        }
        catch (IOException iOException) {
            this.sqlHistoryList = handler.getXmlSqlHistoryList();
            throw new SQLHistoryException();
        }
        if (handler != null) {
            return handler.getXmlSqlHistoryList();
        }
        return new ArrayList<SQLHistory>();
    }

    public List<SQLHistory> retrieve() {
        return this.sqlHistoryList;
    }

    public void setNumElemsToRemove(int n) {
        this.numElemsToRemove = n;
    }

    public int getNumElemsToRemove() {
        return this.numElemsToRemove;
    }

    public List<SQLHistory> updateSQLSaved(int n, FileObject fileObject) throws SQLHistoryException {
        String string = null;
        List<SQLHistory> list = null;
        try {
            string = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separator + SQL_HISTORY_FILE_NAME + ".xml";
            if (fileObject == null) {
                return new ArrayList<SQLHistory>();
            }
            list = this.retrieve(string, fileObject);
            if (n < list.size()) {
                this.numElemsToRemove = list.size() - n;
                boolean bl = true;
                boolean bl2 = bl = !list.isEmpty();
                if (bl && (n == 0 || this.numElemsToRemove >= 0)) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    AtomicFileAction atomicFileAction = new AtomicFileAction(dataFolder, null, 2, list);
                    dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicFileAction);
                }
            }
            list = this.retrieve(string, fileObject);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLHistoryException();
        }
        catch (IOException iOException) {
            throw new SQLHistoryException();
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Handler
    extends DefaultHandler
    implements ContentHandler {
        private static final String ELEMENT_SQL = "sql";
        private static final String ATTR_URL_PROPERTY_VALUE = "url";
        private static final String ATTR_DATE_PROPERTY_VALUE = "date";
        private final String sqlHistoryFileName;
        private static String url;
        private static StringBuilder sql;
        private static Date date;
        boolean matchingUrl = false;
        private List<SQLHistory> xmlSqlHistoryList = new ArrayList<SQLHistory>();
        static boolean isSql;
        private int limit = 10000;

        public Handler(String string) {
            this.sqlHistoryFileName = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ELEMENT_SQL.equals(string3)) {
                isSql = true;
                url = attributes.getValue(ATTR_URL_PROPERTY_VALUE);
                if (attributes.getValue(ATTR_DATE_PROPERTY_VALUE).indexOf("/") != -1) {
                    try {
                        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                        date = dateFormat.parse(attributes.getValue(ATTR_DATE_PROPERTY_VALUE));
                    }
                    catch (ParseException parseException) {
                        Calendar calendar = Calendar.getInstance();
                        date = calendar.getTime();
                    }
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(new Long(attributes.getValue(ATTR_DATE_PROPERTY_VALUE)));
                    date = calendar.getTime();
                }
            } else {
                isSql = false;
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (ELEMENT_SQL.equals(string3) && url != null && sql != null && date != null) {
                this.addHistory(url, sql.toString(), date);
                Handler.reset();
            }
        }

        private static void reset() {
            url = null;
            date = null;
            sql = null;
        }

        private void addHistory(String string, String string2, Date date) {
            String string3 = NbPreferences.forModule(SQLHistoryPersistenceManager.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", "");
            if (!string3.equals("")) {
                this.limit = Integer.parseInt(NbPreferences.forModule(SQLHistoryPersistenceManager.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", ""));
            }
            if (this.xmlSqlHistoryList.size() <= this.limit || this.limit == 0) {
                this.xmlSqlHistoryList.add(new SQLHistory(string, string2, date));
                this.setXmlSqlHistoryList(this.xmlSqlHistoryList);
            } else {
                this.xmlSqlHistoryList.remove(this.xmlSqlHistoryList.size() - 1);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (isSql) {
                String string = new String(cArray, n, n2);
                if (sql == null) {
                    sql = new StringBuilder();
                    sql.append(string);
                } else {
                    sql.append(string);
                }
            }
        }

        public void setXmlSqlHistoryList(List<SQLHistory> list) {
            this.xmlSqlHistoryList = list;
        }

        public List<SQLHistory> getXmlSqlHistoryList() {
            if (this.xmlSqlHistoryList == null) {
                return new ArrayList<SQLHistory>();
            }
            return this.xmlSqlHistoryList;
        }

        static {
            isSql = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XmlWriter {
        private PrintWriter pw;
        private List<SQLHistory> sqlHistoryList;
        private FileObject data;

        public XmlWriter(FileObject fileObject, List<SQLHistory> list, PrintWriter printWriter) {
            this.data = fileObject;
            this.sqlHistoryList = list;
            this.pw = printWriter;
        }

        private Node createElements(Document document) {
            Element element = null;
            Element element2 = null;
            if (null == document.getDocumentElement()) {
                element = document.createElement("history");
                for (SQLHistory sQLHistory : this.sqlHistoryList) {
                    element2 = document.createElement("sql");
                    element2.appendChild(document.createTextNode(sQLHistory.getSql()));
                    element2.setAttribute("url", sQLHistory.getUrl());
                    element2.setAttribute("date", new Long(sQLHistory.getDate().getTime()).toString());
                    element.appendChild(element2);
                }
                document.adoptNode(element);
            } else {
                element = document.getDocumentElement();
                for (SQLHistory sQLHistory : this.sqlHistoryList) {
                    element2 = document.createElement("sql");
                    element2.appendChild(document.createTextNode(sQLHistory.getSql()));
                    element2.setAttribute("url", sQLHistory.getUrl());
                    element2.setAttribute("date", new Long(sQLHistory.getDate().getTime()).toString());
                    element.insertBefore(element2, element.getFirstChild());
                }
            }
            return element;
        }

        private Node removeElements(Document document) {
            NodeList nodeList = null;
            Element element = document.getDocumentElement();
            if (null != element) {
                int n;
                nodeList = element.getElementsByTagName("sql");
                int n2 = SQLHistoryPersistenceManager.getInstance().getNumElemsToRemove();
                if (n2 == 0) {
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        if (nodeList.item(0) == null) continue;
                        element.removeChild(nodeList.item(0));
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (nodeList.item(0) == null) continue;
                    element.removeChild(nodeList.item(nodeList.getLength() - 1));
                }
            }
            return element;
        }

        private void write() {
            this.pw.println("<?xml version='1.0' encoding='UTF-8' ?>");
        }

        private void write(Node node, String string) {
            switch (node.getNodeType()) {
                case 9: {
                    Document document = (Document)node;
                    this.pw.println(string + "<?xml version='1.0'?>");
                    for (Node node2 = document.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.write(node2, string);
                    }
                    break;
                }
                case 1: {
                    Node node3;
                    Element element = (Element)node;
                    this.pw.print(string + "<" + element.getTagName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        node3 = namedNodeMap.item(i);
                        this.pw.print(" " + node3.getNodeName() + "='" + this.fixup(node3.getNodeValue()) + "'");
                    }
                    this.pw.println(">");
                    String string2 = string + "    ";
                    for (node3 = element.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        this.write(node3, string2);
                    }
                    this.pw.println(string + "</" + element.getTagName() + ">");
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    String string3 = text.getData().trim();
                    if (string3 == null || string3.length() <= 0) break;
                    this.pw.println(string + this.fixup(string3));
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "Ignoring node: " + node.getClass().getName());
                }
            }
        }

        private String fixup(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            block7: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    default: {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                    }
                }
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AtomicFileAction
    implements FileSystem.AtomicAction {
        List<SQLHistory> sqlHistoryList;
        DataFolder parent;
        boolean remove;
        FileObject data;
        Handler handler;
        int actionType;

        AtomicFileAction(DataFolder dataFolder, Handler handler, int n, List<SQLHistory> list) {
            this.parent = dataFolder;
            this.handler = handler;
            this.sqlHistoryList = list;
            this.actionType = n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            PrintWriter printWriter = null;
            XmlWriter xmlWriter = null;
            DocumentBuilderFactory documentBuilderFactory = null;
            DocumentBuilder documentBuilder = null;
            try {
                FileObject fileObject = this.parent.getPrimaryFile();
                String string = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separator + SQLHistoryPersistenceManager.SQL_HISTORY_FILE_NAME + ".xml";
                switch (this.actionType) {
                    case 0: {
                        FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
                        XMLDataObject xMLDataObject = (XMLDataObject)XMLDataObject.find((FileObject)fileObject2);
                        InputSource inputSource = new InputSource(xMLDataObject.getPrimaryFile().getInputStream());
                        inputSource.setSystemId(fileObject2.getURL().toExternalForm());
                        XMLReader xMLReader = XMLUtil.createXMLReader();
                        xMLReader.setContentHandler(this.handler);
                        xMLReader.setErrorHandler(this.handler);
                        xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                        xMLReader.parse(inputSource);
                        return;
                    }
                    case 1: {
                        documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        if (fileObject.getChildren().length == 0) {
                            this.data = fileObject.createData(SQLHistoryPersistenceManager.SQL_HISTORY_FILE_NAME, "xml");
                            fileLock = this.data.lock();
                            outputStream = this.data.getOutputStream(fileLock);
                            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
                            SQLHistoryPersistenceManager.document = documentBuilder.newDocument();
                            xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, printWriter);
                            xmlWriter.write();
                        } else {
                            this.data = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
                            InputStream inputStream = this.data.getInputStream();
                            SQLHistoryPersistenceManager.document = documentBuilder.parse(inputStream);
                            inputStream.close();
                            fileLock = this.data.lock();
                            outputStream = this.data.getOutputStream(fileLock);
                            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
                        }
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, printWriter);
                        xmlWriter.write(xmlWriter.createElements(document), "");
                        return;
                    }
                    case 2: {
                        documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        if (fileObject.getChildren().length > 0) {
                            this.data = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
                            InputStream inputStream = this.data.getInputStream();
                            SQLHistoryPersistenceManager.document = documentBuilder.parse(inputStream);
                            inputStream.close();
                            fileLock = this.data.lock();
                            outputStream = this.data.getOutputStream(fileLock);
                            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
                        }
                        xmlWriter = new XmlWriter(this.data, this.sqlHistoryList, printWriter);
                        xmlWriter.write();
                        xmlWriter.write(xmlWriter.removeElements(document), "");
                        return;
                    }
                }
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                LOGGER.log(Level.INFO, parserConfigurationException.getMessage());
                throw new IOException();
            }
            catch (SAXException sAXException) {
                LOGGER.log(Level.INFO, sAXException.getMessage());
                throw new IOException();
            }
            finally {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                    printWriter = null;
                }
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }
}

