/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowNetwork {
    private EmbeddedPlanarGraph originalGraph;
    private Map<MGraph.Vertex, Node> vertexNodeMap;
    private Map<Face, Node> faceNodeMap;
    public Collection<Node> nodes;
    public Collection<Arc> arcs;
    public Node source;
    public Node sink;

    public static FlowNetwork createGraph(EmbeddedPlanarGraph embeddedPlanarGraph) {
        FlowNetwork flowNetwork = new FlowNetwork(embeddedPlanarGraph);
        flowNetwork.createGraph();
        return flowNetwork;
    }

    private FlowNetwork(EmbeddedPlanarGraph embeddedPlanarGraph) {
        this.originalGraph = embeddedPlanarGraph;
        this.vertexNodeMap = new HashMap<MGraph.Vertex, Node>();
        this.faceNodeMap = new HashMap<Face, Node>();
        this.nodes = new ArrayList<Node>();
        this.arcs = new ArrayList<Arc>();
    }

    /*
     * WARNING - void declaration
     */
    private void createGraph() {
        void var4_9;
        Object object;
        Object object2;
        Object object3;
        Collection<MGraph.Vertex> collection = this.originalGraph.getOriginalGraph().getVertices();
        ArrayList<Face> arrayList = this.originalGraph.getFaces();
        for (MGraph.Vertex object4 : collection) {
            object3 = this.getNode(object4);
            for (Face face : arrayList) {
                if (!face.containsVertex(object4)) continue;
                object2 = this.getNode(face);
                object = face.getDartsFrom(object4);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Face.Dart dart = (Face.Dart)iterator.next();
                    this.addArc((Node)object3, (Node)object2, dart);
                }
            }
        }
        for (Face face : arrayList) {
            object3 = this.getNode(face);
            for (Face.Dart dart : face.getDarts()) {
                object2 = this.originalGraph.getOppositeFace(face, dart);
                object = this.getNode((Face)object2);
                this.addArc((Node)object3, (Node)object, dart);
            }
        }
        this.source = new Node();
        this.source.isSource = true;
        this.sink = new Node();
        this.sink.isSink = true;
        int n = 0;
        boolean bl = false;
        for (Node node : this.getNodes()) {
            if (node.production > 0) {
                Arc arc = this.addArc(this.source, node);
                arc.capacity = node.production;
                arc.cost = 0;
                n += node.production;
                continue;
            }
            if (node.production >= 0) continue;
            Arc arc = this.addArc(node, this.sink);
            arc.capacity = -node.production;
            arc.cost = 0;
            var4_9 += node.production;
        }
        this.source.production = n;
        this.sink.production = (int)var4_9;
    }

    public EmbeddedPlanarGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public Node getNode(MGraph.Vertex vertex) {
        Node node = this.vertexNodeMap.get(vertex);
        if (node == null) {
            node = new Node(vertex);
            this.vertexNodeMap.put(vertex, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node getNode(Face face) {
        Node node = this.faceNodeMap.get(face);
        if (node == null) {
            node = new Node(face);
            this.faceNodeMap.put(face, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getSink() {
        return this.sink;
    }

    public Arc addArc(Node node, Node node2, Face.Dart dart) {
        Arc arc = new Arc(node, node2, dart);
        this.arcs.add(arc);
        return arc;
    }

    public Arc addArc(Node node, Node node2) {
        return this.addArc(node, node2, null);
    }

    public void removeArc(Arc arc) {
        this.arcs.remove(arc);
        Node node = arc.getSourceNode();
        if (node != null) {
            node.removeOutputArc(arc);
        }
        if ((node = arc.getDestinationNode()) != null) {
            node.removeInputArc(arc);
        }
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    public Collection<Arc> getArcs() {
        return this.arcs;
    }

    public void removeSourceAndSink() {
        this.nodes.remove(this.source);
        this.nodes.remove(this.sink);
        ArrayList<Arc> arrayList = new ArrayList<Arc>(this.source.getOutputArcs());
        for (Arc arc : arrayList) {
            this.removeArc(arc);
        }
        arrayList = new ArrayList<Arc>(this.sink.getInputArcs());
        for (Arc arc : arrayList) {
            this.removeArc(arc);
        }
    }

    public String toString() {
        String string = "Flow Network\n";
        string = string + "Source:\n" + this.source + "\n";
        string = string + "Sink:\n" + this.sink + "\n";
        string = string + "Nodes:\n";
        for (Node node : this.nodes) {
            string = string + node + "\n";
        }
        return string;
    }

    public static class ResidualArc
    extends Arc {
        private boolean isReverse;
        private Arc arc;

        public ResidualArc(Node node, Node node2, Arc arc, boolean bl) {
            super(node, node2, null);
            this.isReverse = bl;
            this.arc = arc;
            if (!bl) {
                this.setCapacity(arc.getCapacity() - arc.getFlow());
            } else {
                this.setCapacity(arc.getFlow());
            }
            this.setCost(arc.getCost());
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public Arc getArc() {
            return this.arc;
        }

        public String toString() {
            String string = "ResidualArc:\n";
            string = string + "isReverse = " + this.isReverse + "\n";
            string = string + "capacity = " + this.getCapacity() + "\n";
            string = string + "cost = " + this.getCost() + "\n";
            string = string + "flow = " + this.getFlow() + "\n";
            return string;
        }
    }

    public static class ResidualFlowNetwork
    extends FlowNetwork {
        private Map<Arc, ResidualArc> arcToResidualArcMap;
        private Map<Arc, ResidualArc> arcToReverseResidualArcMap;
        private FlowNetwork network;
        private Map<Node, Node> nodeMap;

        public ResidualFlowNetwork(FlowNetwork flowNetwork) {
            super(null);
            this.network = flowNetwork;
            this.nodeMap = new HashMap<Node, Node>();
            this.arcToResidualArcMap = new HashMap<Arc, ResidualArc>();
            this.arcToReverseResidualArcMap = new HashMap<Arc, ResidualArc>();
            this.source = this.getNode(flowNetwork.getSource());
            this.source.isSource = true;
            this.sink = this.getNode(flowNetwork.getSink());
            this.sink.isSink = true;
            for (Arc arc : flowNetwork.getArcs()) {
                this.addResidualArc(arc);
            }
        }

        private void addResidualArc(Arc arc) {
            Node node = this.getNode(arc.getSourceNode());
            Node node2 = this.getNode(arc.getDestinationNode());
            ResidualArc residualArc = new ResidualArc(node, node2, arc, false);
            this.arcToResidualArcMap.put(arc, residualArc);
            ResidualArc residualArc2 = new ResidualArc(node2, node, arc, true);
            this.arcToReverseResidualArcMap.put(arc, residualArc2);
        }

        public ResidualArc getResidualArcFromArc(Arc arc) {
            return this.arcToResidualArcMap.get(arc);
        }

        public ResidualArc getReverseResidualArcFromArc(Arc arc) {
            return this.arcToReverseResidualArcMap.get(arc);
        }

        private Node getNode(Node node) {
            Node node2 = this.nodeMap.get(node);
            if (node2 == null) {
                if (node.isVertexNode()) {
                    node2 = this.getNode(node.getVertex());
                } else if (node.isFaceNode()) {
                    node2 = this.getNode(node.getFace());
                } else {
                    node2 = new Node();
                    node2.setProduction(node.getProduction());
                    this.nodes.add(node2);
                }
                this.nodeMap.put(node, node2);
            }
            return node2;
        }
    }

    public static class Arc {
        private Node sourceNode;
        private Node destinationNode;
        private int capacity;
        private int cost;
        private int flow;
        private int lowerBound;
        private Face.Dart dart;

        public Arc(Node node, Node node2, Face.Dart dart) {
            this.sourceNode = node;
            this.destinationNode = node2;
            this.dart = dart;
            this.flow = 0;
            if (this.sourceNode.isVertexNode() || node2.isVertexNode()) {
                this.lowerBound = 0;
                this.capacity = 3;
                this.cost = 0;
            } else if (this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode()) {
                this.lowerBound = 0;
                this.capacity = Integer.MAX_VALUE;
                this.cost = 1;
            }
            this.sourceNode.addOutputArc(this);
            this.destinationNode.addInputArc(this);
        }

        public Node getSourceNode() {
            return this.sourceNode;
        }

        public Node getDestinationNode() {
            return this.destinationNode;
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int n) {
            this.cost = n;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int n) {
            this.capacity = n;
        }

        public void setFlow(int n) {
            this.flow = n;
        }

        public int getFlow() {
            return this.flow;
        }

        public void addFlow(int n) {
            this.flow += n;
        }

        public void substractCapacity(int n) {
            this.capacity -= n;
        }

        public void addCapacity(int n) {
            this.capacity += n;
        }

        public boolean isVertexArc() {
            return this.sourceNode.isVertexNode();
        }

        public boolean isFaceArc() {
            return this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode();
        }

        public String toString() {
            String string = "Arc:\n";
            string = string + "capacity = " + this.capacity + "\n";
            string = string + "cost = " + this.cost + "\n";
            string = string + "flow = " + this.flow + "\n";
            string = string + "lowerBound = " + this.lowerBound + "\n";
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private Face face;
        private MGraph.Vertex vertex;
        private Collection<Arc> inputArcs = new ArrayList<Arc>();
        private Collection<Arc> outputArcs = new ArrayList<Arc>();
        private int production;
        private boolean isSource;
        private boolean isSink;

        public Node() {
        }

        public Node(Face face) {
            this();
            this.face = face;
            int n = face.getDegree();
            this.production = face.isOuterFace() ? -(1 * n + 4) : (n == 2 ? 0 : -(1 * n - 4));
        }

        public Node(MGraph.Vertex vertex) {
            this();
            this.vertex = vertex;
            this.production = 4 - vertex.getDegree();
        }

        public MGraph.Vertex getVertex() {
            return this.vertex;
        }

        public Face getFace() {
            return this.face;
        }

        public boolean isFaceNode() {
            return this.face != null;
        }

        public boolean isVertexNode() {
            return this.vertex != null;
        }

        public void addInputArc(Arc arc) {
            this.inputArcs.add(arc);
        }

        public void removeInputArc(Arc arc) {
            this.inputArcs.remove(arc);
        }

        public void addOutputArc(Arc arc) {
            this.outputArcs.add(arc);
        }

        public void removeOutputArc(Arc arc) {
            this.outputArcs.remove(arc);
        }

        public Collection<Arc> getInputArcs() {
            return this.inputArcs;
        }

        public Collection<Arc> getOutputArcs() {
            return this.outputArcs;
        }

        public Arc getArcToVia(Node node, Face.Dart dart) {
            MGraph.Edge edge = dart.getEdge();
            for (Arc arc : this.outputArcs) {
                if (arc.getDestinationNode() != node || arc.getDart().getEdge() != edge) continue;
                return arc;
            }
            return null;
        }

        public int getProduction() {
            return this.production;
        }

        public void setProduction(int n) {
            this.production = n;
        }

        public String toString() {
            String string = "Node: \n";
            if (this.isSource) {
                string = "Source Node:\n";
            } else if (this.isSink) {
                string = "Sink Node:\n";
            }
            string = string + "hashCode: " + this.hashCode() + "\n";
            string = string + "vertex: " + this.vertex + "\n";
            string = string + "face: " + this.face + "\n";
            string = string + "production: " + this.production + "\n";
            return string;
        }
    }
}

