/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.view.spi;

import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.lib.editor.util.PriorityMutex;

public class LockView
extends View {
    private static final String PROPERTY_VIEW_HIERARCHY_MUTEX = "viewHierarchyMutex";
    private static final String PROPERTY_FOLD_HIERARCHY_MUTEX = "foldHierarchyMutex";
    private View view;
    private PriorityMutex mutex;
    private AbstractDocument doc;

    public static synchronized PriorityMutex getViewHierarchyMutex(JTextComponent jTextComponent) {
        PriorityMutex priorityMutex = (PriorityMutex)jTextComponent.getClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX);
        if (priorityMutex == null) {
            priorityMutex = new PriorityMutex();
            jTextComponent.putClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX, priorityMutex);
        }
        jTextComponent.putClientProperty(PROPERTY_VIEW_HIERARCHY_MUTEX, priorityMutex);
        return priorityMutex;
    }

    public static LockView get(View view) {
        while (view != null && !(view instanceof LockView)) {
            view = view.getParent();
        }
        return (LockView)view;
    }

    public LockView(View view) {
        super(null);
        this.view = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(View view) {
        Object object;
        View view2 = this.getParent();
        if (view2 != null && view != null) {
            throw new IllegalStateException("Unexpected state occurred when trying to set non-null parent to LockView with non-null parent already set.");
        }
        if (this.mutex == null && view != null && (object = (JTextComponent)view.getContainer()) != null) {
            this.mutex = LockView.getViewHierarchyMutex((JTextComponent)object);
        }
        if (view != null) {
            object = view.getDocument();
            if (!(object instanceof AbstractDocument)) {
                throw new IllegalStateException("Currently the LockView is designed to work with AbstractDocument instances only.");
            }
            this.doc = (AbstractDocument)object;
        }
        this.doc.readLock();
        try {
            this.lock();
            try {
                this.setParentLocked(view);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            this.doc.readUnlock();
        }
    }

    protected void setParentLocked(View view) {
        if (view == null && this.view != null) {
            this.view.setParent(null);
        }
        super.setParent(view);
        if (view != null && this.view != null) {
            this.view.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(View view) {
        this.lock();
        try {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        if (this.mutex != null) {
            this.mutex.lock();
        }
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public boolean isPriorityThreadWaiting() {
        return this.mutex.isPriorityThreadWaiting();
    }

    public Thread getLockThread() {
        return this.mutex.getLockThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public AttributeSet getAttributes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPreferredSpan(int n) {
        this.lock();
        try {
            if (this.view != null) {
                float f = this.view.getPreferredSpan(n);
                return f;
            }
            float f = 10.0f;
            return f;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMinimumSpan(int n) {
        this.lock();
        try {
            if (this.view != null) {
                float f = this.view.getMinimumSpan(n);
                return f;
            }
            float f = 10.0f;
            return f;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaximumSpan(int n) {
        this.lock();
        try {
            if (this.view != null) {
                float f = this.view.getMaximumSpan(n);
                return f;
            }
            float f = 2.1474836E9f;
            return f;
        }
        finally {
            this.unlock();
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        View view2 = this.getParent();
        if (view2 != null) {
            view2.preferenceChanged(this, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAlignment(int n) {
        this.lock();
        try {
            if (this.view != null) {
                float f = this.view.getAlignment(n);
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, Shape shape) {
        if (graphics == null) {
            return;
        }
        this.lock();
        try {
            if (this.view != null) {
                this.view.paint(graphics, shape);
            }
        }
        finally {
            this.unlock();
        }
    }

    public int getViewCount() {
        return 1;
    }

    public View getView(int n) {
        return this.view;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return 0;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.lock();
        try {
            if (this.view != null) {
                Shape shape2 = this.view.modelToView(n, shape, bias);
                return shape2;
            }
            Shape shape3 = null;
            return shape3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        this.lock();
        try {
            if (this.view != null) {
                Shape shape2 = this.view.modelToView(n, bias, n2, bias2, shape);
                return shape2;
            }
            Shape shape3 = null;
            return shape3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.lock();
        try {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        this.lock();
        try {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                return n3;
            }
            int n4 = -1;
            return n4;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.lock();
        try {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.lock();
        try {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.lock();
        try {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(float f, float f2, Shape shape) {
        this.lock();
        try {
            String string = this.view != null ? this.view.getToolTipText(f, f2, shape) : null;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getStartOffset() {
        if (this.view != null) {
            return this.view.getStartOffset();
        }
        Element element = this.getElement();
        return element != null ? element.getStartOffset() : 0;
    }

    public int getEndOffset() {
        if (this.view != null) {
            return this.view.getEndOffset();
        }
        Element element = this.getElement();
        return element != null ? element.getEndOffset() : 0;
    }

    public Element getElement() {
        if (this.view != null) {
            return this.view.getElement();
        }
        Document document = this.getDocument();
        return document != null ? document.getDefaultRootElement() : null;
    }

    public View breakView(int n, float f, Shape shape) {
        throw new Error("Can't break lock view");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResizeWeight(int n) {
        this.lock();
        try {
            if (this.view != null) {
                int n2 = this.view.getResizeWeight(n);
                return n2;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(float f, float f2) {
        this.lock();
        try {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }
        finally {
            this.unlock();
        }
    }
}

