/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import org.netbeans.editor.StringMap;

public class StringCache {
    private static final int DEFAULT_MAX_SIZE = 300;
    private static final int DEFAULT_INITIAL_CAPACITY = 701;
    int maxSize;
    int size;
    StringMap strMap;
    private Entry chain;
    private Entry endChain;
    private Entry freeEntry;
    public int statQueries;
    public int statHits;

    public StringCache() {
        this(300, 701);
    }

    public StringCache(int n) {
        this(n, 2 * n);
    }

    public StringCache(int n, int n2) {
        this.maxSize = n;
        this.strMap = new StringMap(n2);
    }

    private void toStart(Entry entry) {
        if (entry != this.chain) {
            Entry entry2 = entry.prev;
            Entry entry3 = entry.next;
            if (entry3 != null) {
                entry3.prev = entry2;
            } else {
                this.endChain = entry2;
            }
            entry2.next = entry3;
            if (this.chain != null) {
                entry.next = this.chain;
                this.chain.prev = entry;
            }
            this.chain = entry;
        }
    }

    public String getString(char[] cArray, int n, int n2) {
        String string;
        ++this.statQueries;
        Object object = this.strMap.get(cArray, n, n2);
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            this.toStart(entry);
            ++this.statHits;
            string = entry.str;
        } else if (object instanceof String) {
            ++this.statHits;
            string = (String)object;
        } else {
            string = new String(cArray, n, n2);
            this.storeString(string);
        }
        return string;
    }

    private void removeString(String string) {
        Object v = this.strMap.remove(string);
        if (v instanceof Entry) {
            Entry entry = (Entry)v;
            Entry entry2 = entry.prev;
            Entry entry3 = entry.next;
            if (entry == this.chain) {
                this.chain = entry3;
                if (entry == this.endChain) {
                    this.endChain = null;
                }
            } else if (entry3 != null) {
                entry3.prev = entry2;
            } else {
                this.endChain = entry2;
            }
            this.freeEntry = entry;
            --this.size;
        }
    }

    private void storeString(String string) {
        Entry entry;
        if (this.size >= this.maxSize) {
            entry = this.endChain;
            this.toStart(entry);
            this.strMap.remove(entry.str);
            entry.str = string;
        } else {
            if (this.freeEntry != null) {
                entry = this.freeEntry;
                this.freeEntry = null;
                entry.str = string;
                entry.next = this.chain;
            } else {
                entry = new Entry(string, this.chain);
            }
            if (this.chain != null) {
                this.chain.prev = entry;
            } else {
                this.endChain = entry;
            }
            this.chain = entry;
            ++this.size;
        }
        this.strMap.put(string, entry);
    }

    public void putSurviveString(String string) {
        this.removeString(string);
        this.strMap.put(string, string);
    }

    public String toString() {
        String string = "size=" + this.size + ", maxSize=" + this.maxSize + ", statHits=" + this.statHits + ", statQueries=" + this.statQueries;
        if (this.statQueries > 0) {
            string = string + ", hit ratio=" + this.statHits * 100 / this.statQueries + "%";
        }
        return string;
    }

    static class Entry {
        String str;
        Entry next;
        Entry prev;

        Entry(String string, Entry entry) {
            this.str = string;
            this.next = entry;
        }
    }
}

