/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.DrawContext;

public final class Coloring
implements Serializable {
    public static final int FONT_MODE_APPLY_NAME = 1;
    public static final int FONT_MODE_APPLY_STYLE = 2;
    public static final int FONT_MODE_APPLY_SIZE = 4;
    public static final int FONT_MODE_DEFAULT = 7;
    private Font font;
    private int fontMode;
    private Color foreColor;
    private Color backColor;
    private Color underlineColor;
    private Color waveUnderlineColor;
    private Color strikeThroughColor;
    private Color topBorderLineColor;
    private Color rightBorderLineColor;
    private Color bottomBorderLineColor;
    private Color leftBorderLineColor;
    private transient HashMap fontAndForeColorCache;
    private transient HashMap backColorCache;
    static final long serialVersionUID = -1382649127124476675L;
    private static final WeakHashMap<AttributeSet, Coloring> colorings = new WeakHashMap();

    public Coloring() {
        this(null, null, null);
    }

    public Coloring(Font font, Color color, Color color2) {
        this(font, 7, color, color2, null, null);
    }

    public Coloring(Font font, int n, Color color, Color color2) {
        this(font, n, color, color2, null, null);
    }

    public Coloring(Font font, int n, Color color, Color color2, Color color3, Color color4) {
        this(font, n, color, color2, color3, color4, null);
    }

    public Coloring(Font font, int n, Color color, Color color2, Color color3, Color color4, Color color5) {
        this(font, n, color, color2, color3, color4, color5, null, null, null, null);
    }

    public Coloring(Font font, int n, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, Color color8, Color color9) {
        font = n != 0 ? font : null;
        n = font != null ? n : 7;
        this.font = font;
        this.fontMode = n;
        this.foreColor = color;
        this.backColor = color2;
        this.underlineColor = color3;
        this.strikeThroughColor = color4;
        this.waveUnderlineColor = color5;
        this.topBorderLineColor = color6;
        this.rightBorderLineColor = color7;
        this.bottomBorderLineColor = color8;
        this.leftBorderLineColor = color9;
        this.checkCaches();
    }

    private void checkCaches() {
        boolean bl;
        boolean bl2 = this.font != null && this.fontMode != 0 && this.fontMode != 7;
        boolean bl3 = bl = this.foreColor != null && this.hasAlpha(this.foreColor);
        if (bl2 || bl) {
            this.fontAndForeColorCache = new HashMap(bl2 && bl ? 47 : 23);
        }
        if (this.backColor != null && this.hasAlpha(this.backColor)) {
            this.backColorCache = new HashMap(23);
        }
    }

    private boolean hasAlpha(Color color) {
        return (color.getRGB() & 0xFF000000) != -16777216;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontMode() {
        return this.fontMode;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public Color getWaveUnderlineColor() {
        return this.waveUnderlineColor;
    }

    public Color getStrikeThroughColor() {
        return this.strikeThroughColor;
    }

    public Color getTopBorderLineColor() {
        return this.topBorderLineColor;
    }

    public Color getRightBorderLineColor() {
        return this.rightBorderLineColor;
    }

    public Color getBottomBorderLineColor() {
        return this.bottomBorderLineColor;
    }

    public Color getLeftBorderLineColor() {
        return this.leftBorderLineColor;
    }

    private Font modifyFont(Font font) {
        return new Font((this.fontMode & 1) != 0 ? this.font.getName() : font.getName(), (this.fontMode & 2) != 0 ? this.font.getStyle() : font.getStyle(), (this.fontMode & 4) != 0 ? this.font.getSize() : font.getSize());
    }

    private Color modifyForeColor(Color color) {
        int n = this.foreColor.getAlpha();
        int n2 = this.foreColor.getRGB();
        int n3 = color.getRGB();
        int n4 = ((this.foreColor.getRed() * n + color.getRed() * (255 - n)) / 255 & 0xFF) << 16;
        return new Color(n4 += (((n2 & 0xFF00) * n + (n3 & 0xFF00) * (255 - n)) / 255 & 0xFF00) + (((n2 & 0xFF) * n + (n3 & 0xFF) * (255 - n)) / 255 & 0xFF), false);
    }

    private Color modifyBackColor(Color color) {
        int n = this.backColor.getAlpha();
        int n2 = this.backColor.getRGB();
        int n3 = color.getRGB();
        int n4 = ((this.backColor.getRed() * n + color.getRed() * (255 - n)) / 255 & 0xFF) << 16;
        return new Color(n4 += (((n2 & 0xFF00) * n + (n3 & 0xFF00) * (255 - n)) / 255 & 0xFF00) + (((n2 & 0xFF) * n + (n3 & 0xFF) * (255 - n)) / 255 & 0xFF), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(DrawContext drawContext) {
        Serializable serializable;
        HashMap hashMap;
        Serializable serializable2;
        if (this.font != null) {
            if (this.fontMode == 7) {
                drawContext.setFont(this.font);
            } else {
                serializable2 = drawContext.getFont();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Font)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyFont((Font)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        drawContext.setFont((Font)serializable);
                    }
                }
            }
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                drawContext.setForeColor(this.foreColor);
            } else {
                serializable2 = drawContext.getForeColor();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyForeColor((Color)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        drawContext.setForeColor((Color)serializable);
                    }
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                drawContext.setBackColor(this.backColor);
            } else {
                serializable2 = drawContext.getBackColor();
                if (serializable2 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable2);
                            this.backColorCache.put(serializable2, serializable);
                        }
                        drawContext.setBackColor((Color)serializable);
                    }
                }
            }
        }
        if (this.underlineColor != null) {
            drawContext.setUnderlineColor(this.underlineColor);
        }
        if (this.waveUnderlineColor != null) {
            drawContext.setWaveUnderlineColor(this.waveUnderlineColor);
        }
        if (this.strikeThroughColor != null) {
            drawContext.setStrikeThroughColor(this.strikeThroughColor);
        }
        if (this.topBorderLineColor != null) {
            drawContext.setTopBorderLineColor(this.topBorderLineColor);
        }
        if (this.rightBorderLineColor != null) {
            drawContext.setRightBorderLineColor(this.rightBorderLineColor);
        }
        if (this.bottomBorderLineColor != null) {
            drawContext.setBottomBorderLineColor(this.bottomBorderLineColor);
        }
        if (this.leftBorderLineColor != null) {
            drawContext.setLeftBorderLineColor(this.leftBorderLineColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(JComponent jComponent) {
        Serializable serializable;
        HashMap hashMap;
        Serializable serializable2;
        if (this.font != null) {
            if (this.fontMode == 7) {
                jComponent.setFont(this.font);
            } else {
                serializable2 = jComponent.getFont();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Font)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyFont((Font)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        jComponent.setFont((Font)serializable);
                    }
                }
            }
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                jComponent.setForeground(this.foreColor);
            } else {
                serializable2 = jComponent.getForeground();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyForeColor((Color)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        jComponent.setForeground((Color)serializable);
                    }
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                jComponent.setBackground(this.backColor);
            } else {
                serializable2 = jComponent.getBackground();
                if (serializable2 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable2);
                            this.backColorCache.put(serializable2, serializable);
                        }
                        jComponent.setBackground((Color)serializable);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coloring apply(Coloring coloring) {
        Serializable serializable;
        HashMap hashMap;
        if (coloring == null) {
            return this;
        }
        Font font = coloring.font;
        int n = 7;
        Serializable serializable2 = coloring.foreColor;
        Serializable serializable3 = coloring.backColor;
        Color color = coloring.underlineColor;
        Color color2 = coloring.waveUnderlineColor;
        Color color3 = coloring.strikeThroughColor;
        Color color4 = coloring.topBorderLineColor;
        Color color5 = coloring.rightBorderLineColor;
        Color color6 = coloring.bottomBorderLineColor;
        Color color7 = coloring.leftBorderLineColor;
        if (this.font != null) {
            if (this.fontMode == 7) {
                font = this.font;
            } else if (font != null) {
                hashMap = this.fontAndForeColorCache;
                synchronized (hashMap) {
                    serializable = (Font)this.fontAndForeColorCache.get(font);
                    if (serializable == null) {
                        serializable = this.modifyFont(font);
                        this.fontAndForeColorCache.put(font, serializable);
                    }
                    font = serializable;
                }
            }
        } else {
            n = coloring.fontMode;
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                serializable2 = this.foreColor;
            } else if (serializable2 != null) {
                hashMap = this.fontAndForeColorCache;
                synchronized (hashMap) {
                    serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                    if (serializable == null) {
                        serializable = this.modifyForeColor((Color)serializable2);
                        this.fontAndForeColorCache.put(serializable2, serializable);
                    }
                    serializable2 = serializable;
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                serializable3 = this.backColor;
            } else {
                serializable3 = this.backColor;
                if (serializable3 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable3);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable3);
                            this.backColorCache.put(serializable3, serializable);
                        }
                        serializable3 = serializable;
                    }
                }
            }
        }
        if (this.underlineColor != null) {
            color = this.underlineColor;
        }
        if (this.waveUnderlineColor != null) {
            color2 = this.waveUnderlineColor;
        }
        if (this.strikeThroughColor != null) {
            color3 = this.strikeThroughColor;
        }
        if (this.topBorderLineColor != null) {
            color4 = this.topBorderLineColor;
        }
        if (this.rightBorderLineColor != null) {
            color5 = this.rightBorderLineColor;
        }
        if (this.bottomBorderLineColor != null) {
            color6 = this.bottomBorderLineColor;
        }
        if (this.leftBorderLineColor != null) {
            color7 = this.leftBorderLineColor;
        }
        if (coloring.fontMode != 7 || font != coloring.font || serializable2 != coloring.foreColor || serializable3 != coloring.backColor || color != coloring.underlineColor || color2 != coloring.waveUnderlineColor || color3 != coloring.strikeThroughColor || color4 != coloring.topBorderLineColor || color5 != coloring.rightBorderLineColor || color6 != coloring.bottomBorderLineColor || color7 != coloring.leftBorderLineColor) {
            return new Coloring(font, n, (Color)serializable2, (Color)serializable3, color, color3, color2, color4, color5, color6, color7);
        }
        return coloring;
    }

    public boolean equals(Object object) {
        if (object instanceof Coloring) {
            Coloring coloring = (Coloring)object;
            return (this.font == null && coloring.font == null || this.font != null && this.font.equals(coloring.font)) && this.fontMode == coloring.fontMode && (this.foreColor == null && coloring.foreColor == null || this.foreColor != null && this.foreColor.equals(coloring.foreColor)) && (this.backColor == null && coloring.backColor == null || this.backColor != null && this.backColor.equals(coloring.backColor)) && (this.underlineColor == null && coloring.underlineColor == null || this.underlineColor != null && this.underlineColor.equals(coloring.underlineColor)) && (this.waveUnderlineColor == null && coloring.waveUnderlineColor == null || this.waveUnderlineColor != null && this.waveUnderlineColor.equals(coloring.waveUnderlineColor)) && (this.strikeThroughColor == null && coloring.strikeThroughColor == null || this.strikeThroughColor != null && this.strikeThroughColor.equals(coloring.strikeThroughColor)) && (this.topBorderLineColor == null && coloring.topBorderLineColor == null || this.topBorderLineColor != null && this.topBorderLineColor.equals(coloring.topBorderLineColor)) && (this.rightBorderLineColor == null && coloring.rightBorderLineColor == null || this.rightBorderLineColor != null && this.rightBorderLineColor.equals(coloring.rightBorderLineColor)) && (this.bottomBorderLineColor == null && coloring.bottomBorderLineColor == null || this.bottomBorderLineColor != null && this.bottomBorderLineColor.equals(coloring.bottomBorderLineColor)) && (this.leftBorderLineColor == null && coloring.leftBorderLineColor == null || this.leftBorderLineColor != null && this.leftBorderLineColor.equals(coloring.leftBorderLineColor));
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        n += this.font != null ? this.font.hashCode() : 0;
        n += this.fontMode;
        n += this.foreColor != null ? this.foreColor.hashCode() : 0;
        n += this.backColor != null ? this.backColor.hashCode() : 0;
        n += this.underlineColor != null ? this.underlineColor.hashCode() : 0;
        n += this.waveUnderlineColor != null ? this.waveUnderlineColor.hashCode() : 0;
        n += this.strikeThroughColor != null ? this.strikeThroughColor.hashCode() : 0;
        n += this.topBorderLineColor != null ? this.topBorderLineColor.hashCode() : 0;
        n += this.rightBorderLineColor != null ? this.rightBorderLineColor.hashCode() : 0;
        n += this.bottomBorderLineColor != null ? this.bottomBorderLineColor.hashCode() : 0;
        return n += this.leftBorderLineColor != null ? this.leftBorderLineColor.hashCode() : 0;
    }

    public static Coloring changeFont(Coloring coloring, Font font) {
        return Coloring.changeFont(coloring, font, coloring.getFontMode());
    }

    public static Coloring changeFont(Coloring coloring, Font font, int n) {
        if (font == null && coloring.font == null || font != null && font.equals(coloring.font) && coloring.fontMode == n) {
            return coloring;
        }
        return new Coloring(font, coloring.foreColor, coloring.backColor);
    }

    public static Coloring changeForeColor(Coloring coloring, Color color) {
        if (color == null && coloring.foreColor == null || color != null && color.equals(coloring.foreColor)) {
            return coloring;
        }
        return new Coloring(coloring.font, color, coloring.backColor);
    }

    public static Coloring changeBackColor(Coloring coloring, Color color) {
        if (color == null && coloring.backColor == null || color != null && color.equals(coloring.backColor)) {
            return coloring;
        }
        return new Coloring(coloring.font, coloring.foreColor, color);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.fontMode == 0) {
            this.fontMode = 7;
        }
        this.checkCaches();
    }

    public String toString() {
        return "font=" + this.font + ", fontMode=" + this.fontMode + ", foreColor=" + this.foreColor + ", backColor=" + this.backColor + ", underlineColor=" + this.underlineColor + ", waveUnderlineColor=" + this.waveUnderlineColor + ", strikeThroughColor=" + this.strikeThroughColor + ", topBorderLineColor=" + this.topBorderLineColor + ", rightBorderLineColor=" + this.rightBorderLineColor + ", bottomBorderLineColor=" + this.bottomBorderLineColor + ", leftBorderLineColor=" + this.leftBorderLineColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Coloring fromAttributeSet(AttributeSet attributeSet) {
        WeakHashMap<AttributeSet, Coloring> weakHashMap = colorings;
        synchronized (weakHashMap) {
            Coloring coloring = colorings.get(attributeSet);
            if (coloring == null) {
                Object[] objectArray = Coloring.toFont(attributeSet);
                coloring = new Coloring((Font)objectArray[0], (Integer)objectArray[1], (Color)attributeSet.getAttribute(StyleConstants.Foreground), (Color)attributeSet.getAttribute(StyleConstants.Background), (Color)attributeSet.getAttribute(StyleConstants.Underline), (Color)attributeSet.getAttribute(StyleConstants.StrikeThrough), (Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor), (Color)attributeSet.getAttribute(EditorStyleConstants.TopBorderLineColor), (Color)attributeSet.getAttribute(EditorStyleConstants.RightBorderLineColor), (Color)attributeSet.getAttribute(EditorStyleConstants.BottomBorderLineColor), (Color)attributeSet.getAttribute(EditorStyleConstants.LeftBorderLineColor));
                colorings.put(attributeSet, coloring);
            }
            return coloring;
        }
    }

    private static Object[] toFont(AttributeSet attributeSet) {
        int n = 0;
        String string = null;
        Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
        if (object instanceof String) {
            string = (String)object;
            ++n;
        }
        int n2 = 0;
        Object object2 = attributeSet.getAttribute(StyleConstants.FontSize);
        if (object2 instanceof Integer) {
            n2 = (Integer)object2;
            n += 4;
        }
        int n3 = 0;
        Object object3 = attributeSet.getAttribute(StyleConstants.Bold);
        Object object4 = attributeSet.getAttribute(StyleConstants.Italic);
        if (object3 != null || object4 != null) {
            if (Boolean.TRUE.equals(object3)) {
                ++n3;
            }
            if (Boolean.TRUE.equals(object4)) {
                n3 += 2;
            }
            n += 2;
        }
        return new Object[]{new Font(string, n3, n2), new Integer(n)};
    }
}

