/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyExecution;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.netbeans.modules.editor.fold.SpiPackageAccessor;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class FoldHierarchyTransactionImpl {
    private static final Logger LOG;
    private static final boolean debug;
    private static final Fold[] EMPTY_FOLDS;
    private static final FoldStateChange[] EMPTY_FOLD_STATE_CHANGES;
    private static final int[] EMPTY_INT_ARRAY;
    private static final int MAX_NESTING_LEVEL = 1000;
    private FoldHierarchyTransaction transaction;
    private boolean committed;
    private FoldHierarchyExecution execution;
    private Fold lastOperationFold;
    private int lastOperationIndex;
    private Fold addFoldBlock;
    private List unblockedFoldLists = new ArrayList(4);
    private int unblockedFoldMaxPriority = -1;
    private Set addedToHierarchySet;
    private Set removedFromHierarchySet;
    private Map fold2StateChange;
    private int affectedStartOffset;
    private int affectedEndOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FoldHierarchyTransactionImpl(FoldHierarchyExecution foldHierarchyExecution) {
        this.execution = foldHierarchyExecution;
        this.affectedStartOffset = Integer.MAX_VALUE;
        this.affectedEndOffset = -1;
        this.transaction = SpiPackageAccessor.get().createFoldHierarchyTransaction(this);
    }

    public FoldHierarchyTransaction getTransaction() {
        return this.transaction;
    }

    public void commit() {
        this.checkNotCommitted();
        this.committed = true;
        this.execution.clearActiveTransaction();
        if (!this.isEmpty()) {
            FoldStateChange[] foldStateChangeArray;
            Fold[] foldArray;
            Fold[] foldArray2;
            int n;
            if (this.removedFromHierarchySet != null && (n = this.removedFromHierarchySet.size()) != 0) {
                foldArray2 = new Fold[n];
                this.removedFromHierarchySet.toArray(foldArray2);
            } else {
                foldArray2 = EMPTY_FOLDS;
            }
            if (this.addedToHierarchySet != null && (n = this.addedToHierarchySet.size()) != 0) {
                foldArray = new Fold[n];
                this.addedToHierarchySet.toArray(foldArray);
            } else {
                foldArray = EMPTY_FOLDS;
            }
            if (this.fold2StateChange != null) {
                foldStateChangeArray = new FoldStateChange[this.fold2StateChange.size()];
                this.fold2StateChange.values().toArray(foldStateChangeArray);
            } else {
                foldStateChangeArray = EMPTY_FOLD_STATE_CHANGES;
            }
            for (int i = foldStateChangeArray.length - 1; i >= 0; --i) {
                FoldStateChange foldStateChange = foldStateChangeArray[i];
                Fold fold = foldStateChange.getFold();
                this.updateAffectedOffsets(fold);
                int n2 = foldStateChange.getOriginalStartOffset();
                if (n2 != -1) {
                    this.updateAffectedStartOffset(n2);
                }
                if ((n2 = foldStateChange.getOriginalEndOffset()) == -1) continue;
                this.updateAffectedEndOffset(n2);
            }
            this.execution.createAndFireFoldHierarchyEvent(foldArray2, foldArray, foldStateChangeArray, this.affectedStartOffset, this.affectedEndOffset);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (debug) {
            System.err.println("insertUpdate: offset=" + documentEvent.getOffset() + ", length=" + documentEvent.getLength());
        }
        try {
            this.insertCheckEndOffset(this.execution.getRootFold(), documentEvent);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private void insertCheckEndOffset(Fold fold, DocumentEvent documentEvent) throws BadLocationException {
        int n = documentEvent.getOffset() + documentEvent.getLength();
        int n2 = FoldUtilitiesImpl.findFoldStartIndex(fold, n, false);
        if (n2 >= 0) {
            int n3;
            Fold fold2 = fold.getFold(n2);
            if (n2 > 0 && fold2.getStartOffset() == n) {
                fold2 = fold.getFold(--n2);
            }
            if ((n3 = fold2.getEndOffset()) >= n) {
                this.insertCheckEndOffset(fold2, documentEvent);
                ApiPackageAccessor.get().foldInsertUpdate(fold2, documentEvent);
                if (n3 == n) {
                    this.setEndOffset(fold2, documentEvent.getDocument(), documentEvent.getOffset());
                } else {
                    ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
                    if (apiPackageAccessor.foldIsStartDamaged(fold2) || apiPackageAccessor.foldIsEndDamaged(fold2)) {
                        this.execution.remove(fold2, this);
                        this.removeDamagedNotify(fold2);
                        if (debug) {
                            System.err.println("insertUpdate: removed damaged " + fold2);
                        }
                    }
                }
            }
        }
    }

    private FoldOperationImpl getOperation(Fold fold) {
        return ApiPackageAccessor.get().foldGetOperation(fold);
    }

    private FoldManager getManager(Fold fold) {
        return this.getOperation(fold).getManager();
    }

    private void setEndOffset(Fold fold, Document document, int n) throws BadLocationException {
        int n2 = fold.getEndOffset();
        ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
        apiPackageAccessor.foldSetEndOffset(fold, document, n);
        apiPackageAccessor.foldStateChangeEndOffsetChanged(this.getFoldStateChange(fold), n2);
    }

    public void setCollapsed(Fold fold, boolean bl) {
        boolean bl2 = fold.isCollapsed();
        if (bl2 != bl) {
            ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
            apiPackageAccessor.foldSetCollapsed(fold, bl);
            apiPackageAccessor.foldStateChangeCollapsedChanged(this.getFoldStateChange(fold));
        }
    }

    private void removeDamagedNotify(Fold fold) {
        this.getManager(fold).removeDamagedNotify(fold);
    }

    private void removeEmptyNotify(Fold fold) {
        this.getManager(fold).removeEmptyNotify(fold);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (debug) {
            System.err.println("removeUpdate: offset=" + documentEvent.getOffset());
        }
        this.removeCheckDamaged(this.execution.getRootFold(), documentEvent);
    }

    private void removeCheckDamaged(Fold fold, DocumentEvent documentEvent) {
        ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
        int n = FoldUtilitiesImpl.findFoldStartIndex(fold, documentEvent.getOffset(), true);
        if (n >= 0) {
            boolean bl;
            do {
                Fold fold2 = fold.getFold(n);
                bl = false;
                if (FoldUtilities.isEmpty(fold2)) {
                    this.removeCheckDamaged(fold2, documentEvent);
                    this.execution.remove(fold2, this);
                    this.getManager(fold2).removeEmptyNotify(fold2);
                    bl = true;
                    if (debug) {
                        System.err.println("insertUpdate: removed empty " + fold2);
                    }
                } else if (apiPackageAccessor.foldIsStartDamaged(fold2) || apiPackageAccessor.foldIsEndDamaged(fold2)) {
                    this.removeCheckDamaged(fold2, documentEvent);
                    this.execution.remove(fold2, this);
                    this.getManager(fold2).removeDamagedNotify(fold2);
                    bl = true;
                    if (debug) {
                        System.err.println("insertUpdate: removed damaged " + fold2);
                    }
                } else if (fold2.getFoldCount() > 0) {
                    this.removeCheckDamaged(fold2, documentEvent);
                }
                if (bl) continue;
                if (fold2.isCollapsed() && apiPackageAccessor.foldIsExpandNecessary(fold2)) {
                    this.setCollapsed(fold2, false);
                }
                apiPackageAccessor.foldRemoveUpdate(fold2, documentEvent);
            } while (bl && n < fold.getFoldCount());
        }
    }

    private boolean isEmpty() {
        return !(this.fold2StateChange != null && this.fold2StateChange.size() != 0 || this.addedToHierarchySet != null && this.addedToHierarchySet.size() != 0 || this.removedFromHierarchySet != null && this.removedFromHierarchySet.size() != 0);
    }

    public FoldStateChange getFoldStateChange(Fold fold) {
        FoldStateChange foldStateChange;
        if (this.fold2StateChange == null) {
            this.fold2StateChange = new HashMap();
        }
        if ((foldStateChange = (FoldStateChange)this.fold2StateChange.get(fold)) == null) {
            foldStateChange = ApiPackageAccessor.get().createFoldStateChange(fold);
            this.fold2StateChange.put(fold, foldStateChange);
        }
        return foldStateChange;
    }

    void removeFold(Fold fold) {
        Fold fold2;
        if (debug) {
            System.err.println("removeFold: " + fold);
        }
        if ((fold2 = fold.getParent()) != null) {
            int n = fold2.getFoldIndex(fold);
            this.removeFoldFromHierarchy(fold2, n, null);
            this.lastOperationFold = fold2;
            this.lastOperationIndex = n;
        } else {
            if (!this.execution.isBlocked(fold)) {
                throw new IllegalStateException("Fold already removed: " + fold);
            }
            this.execution.unmarkBlocked(fold);
            this.unblockBlocked(fold);
        }
        this.processUnblocked();
    }

    void removeAllFolds(Fold[] foldArray) {
        for (int i = foldArray.length - 1; i >= 0; --i) {
            this.removeFold(foldArray[i]);
        }
        this.removeAllChildrenAndSelf(this.execution.getRootFold());
    }

    private void removeAllChildrenAndSelf(Fold fold) {
        int n = fold.getFoldCount();
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                this.removeAllChildrenAndSelf(fold.getFold(i));
            }
        }
        if (!FoldUtilities.isRootFold(fold)) {
            this.removeFold(fold);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    boolean addFold(Fold fold) {
        if (debug) {
            System.err.println("addFold: " + fold);
        }
        return this.addFold(fold, null, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addFold(Fold fold, Fold fold2, int n) {
        int[] nArray;
        boolean bl;
        int n2;
        Object object;
        Fold fold3;
        Fold fold4;
        boolean bl2;
        int n3;
        int n4 = fold.getStartOffset();
        int n5 = fold.getEndOffset();
        int n6 = this.getOperation(fold).getPriority();
        if (fold2 == null) {
            fold2 = this.lastOperationFold;
            if (fold2 == null || n4 < fold2.getStartOffset() || n5 > fold2.getEndOffset()) {
                fold2 = this.execution.getRootFold();
                n3 = FoldUtilitiesImpl.findFoldInsertIndex(fold2, n4);
                bl2 = false;
            } else {
                n3 = this.lastOperationIndex;
                bl2 = true;
            }
        } else {
            n3 = FoldUtilitiesImpl.findFoldInsertIndex(fold2, n4);
            bl2 = false;
        }
        int n7 = fold2.getFoldCount();
        if (bl2 && n3 > n7) {
            n3 = FoldUtilitiesImpl.findFoldInsertIndex(fold2, n4);
            bl2 = false;
        }
        if (n3 > 0) {
            fold4 = fold2.getFold(n3 - 1);
            if (bl2 && n4 < fold4.getStartOffset()) {
                n3 = FoldUtilitiesImpl.findFoldInsertIndex(fold2, n4);
                bl2 = false;
                fold4 = n3 > 0 ? fold2.getFold(n3 - 1) : null;
            }
        } else {
            fold4 = null;
        }
        if (n3 < n7) {
            fold3 = fold2.getFold(n3);
            if (bl2 && n4 >= fold3.getStartOffset()) {
                n3 = FoldUtilitiesImpl.findFoldInsertIndex(fold2, n4);
                bl2 = false;
                fold4 = n3 > 0 ? fold2.getFold(n3 - 1) : null;
                fold3 = n3 < n7 ? fold2.getFold(n3) : null;
            }
        } else {
            fold3 = null;
        }
        if (fold4 != null && n4 < fold4.getEndOffset()) {
            if (n5 <= fold4.getEndOffset()) {
                StringBuilder stringBuilder;
                if (n < 1000) {
                    if (this.getManager(fold) != this.getManager(fold4)) return this.addFold(fold, fold4, n + 1);
                    if (fold.getStartOffset() != fold4.getStartOffset()) return this.addFold(fold, fold4, n + 1);
                    if (fold.getEndOffset() != fold4.getEndOffset()) return this.addFold(fold, fold4, n + 1);
                    if (LOG.isLoggable(Level.WARNING)) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Adding a fold that is identical with another previously added fold from the same FoldManager is not allowed.\n");
                        stringBuilder.append("Existing fold: ");
                        stringBuilder.append(fold4.toString());
                        stringBuilder.append("; FoldManager: ").append(this.getManager(fold4));
                        stringBuilder.append("\n");
                        stringBuilder.append("     New fold: ");
                        stringBuilder.append(fold.toString());
                        stringBuilder.append("; FoldManager: ").append(this.getManager(fold));
                        stringBuilder.append("\n");
                        LOG.warning(stringBuilder.toString());
                    }
                } else if (LOG.isLoggable(Level.WARNING)) {
                    stringBuilder = new StringBuilder();
                    object = this.getOperation(fold4).getDocument();
                    stringBuilder.append("Too many nested folds in ");
                    stringBuilder.append(object.getClass().getName());
                    stringBuilder.append("@");
                    stringBuilder.append(Integer.toHexString(System.identityHashCode(object)));
                    stringBuilder.append("['").append((String)object.getProperty("mimeType")).append("', ");
                    stringBuilder.append(this.findFilePath((Document)object)).append("]\n");
                    stringBuilder.append("Dumping the nesting folds:\n");
                    for (Fold fold5 = fold4; fold5 != null; fold5 = fold5.getParent()) {
                        stringBuilder.append(fold5.toString());
                        stringBuilder.append("; FoldManager: ").append(this.getManager(fold5));
                        stringBuilder.append("\n");
                    }
                    n2 = 0;
                    if (!$assertionsDisabled) {
                        n2 = 1;
                        if (1 == 0) {
                            throw new AssertionError();
                        }
                    }
                    if (n2 != 0) {
                        LOG.log(Level.WARNING, null, new Throwable(stringBuilder.toString()));
                    } else {
                        LOG.warning(stringBuilder.toString());
                    }
                }
                bl = true;
                this.addFoldBlock = fold4;
                nArray = null;
            } else if (n6 > this.getOperation(fold4).getPriority()) {
                if (fold4.getFoldCount() > 0) {
                    nArray = this.inspectOverlap(fold4, n4, n6, 1);
                    bl = nArray == null;
                } else {
                    bl = false;
                    nArray = EMPTY_INT_ARRAY;
                }
            } else {
                bl = true;
                this.addFoldBlock = fold4;
                nArray = null;
            }
        } else {
            bl = false;
            nArray = null;
        }
        if (!bl) {
            int n8 = n3;
            object = null;
            if (fold3 != null && n5 > fold3.getStartOffset()) {
                if (n5 >= fold3.getEndOffset()) {
                    n8 = FoldUtilitiesImpl.findFoldStartIndex(fold2, n5, false);
                    fold3 = fold2.getFold(n8);
                }
                if (n5 < fold3.getEndOffset()) {
                    if (n6 > this.getOperation(fold3).getPriority()) {
                        if (fold3.getFoldCount() > 0) {
                            object = this.inspectOverlap(fold3, n5, n6, 1);
                            if (object == null) {
                                bl = true;
                            }
                        } else {
                            object = EMPTY_INT_ARRAY;
                        }
                    } else {
                        bl = true;
                        this.addFoldBlock = fold3;
                    }
                } else {
                    ++n8;
                }
            }
            if (!bl) {
                if (nArray != null) {
                    if (nArray.length == 0) {
                        n2 = 0;
                    } else {
                        n2 = this.removeOverlap(fold4, nArray, fold);
                        n8 += fold4.getFoldCount();
                    }
                    this.removeFoldFromHierarchy(fold2, n3 - 1, fold);
                    n3 += n2 - 1;
                    --n8;
                }
                if (object != null) {
                    n2 = (object).length == 0 ? 0 : this.removeOverlap(fold3, (int[])object, fold);
                    this.removeFoldFromHierarchy(fold2, n8, fold);
                    n8 += n2;
                }
                ApiPackageAccessor.get().foldExtractToChildren(fold2, n3, n8 - n3, fold);
                this.updateAffectedOffsets(fold);
                this.markFoldAddedToHierarchy(fold);
                this.processUnblocked();
            }
        }
        if (bl) {
            this.execution.markBlocked(fold, this.addFoldBlock);
            this.addFoldBlock = null;
        }
        this.lastOperationFold = fold2;
        this.lastOperationIndex = n3 + 1;
        if (bl) return false;
        return true;
    }

    private String findFilePath(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof FileObject) {
            return ((FileObject)object).getPath();
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile().getPath();
        }
        if (object != null) {
            return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
        }
        return "null";
    }

    private int[] inspectOverlap(Fold fold, int n, int n2, int n3) {
        int[] nArray;
        Fold fold2;
        int n4 = FoldUtilitiesImpl.findFoldStartIndex(fold, n, false);
        if (n4 >= 0 && FoldUtilities.containsOffset(fold2 = fold.getFold(n4), n)) {
            if (n2 > this.getOperation(fold2).getPriority()) {
                if (fold2.getFoldCount() > 0) {
                    nArray = this.inspectOverlap(fold2, n, n2, n3 + 1);
                    if (nArray != null) {
                        nArray[n3] = n4;
                    }
                } else {
                    nArray = new int[n3 + 1];
                    nArray[0] = 1;
                    nArray[n3] = n4;
                }
            } else {
                this.addFoldBlock = fold2;
                nArray = null;
            }
        } else {
            nArray = new int[n3 + 1];
            nArray[0] = 0;
            nArray[n3] = n4;
        }
        return nArray;
    }

    private int removeOverlap(Fold fold, int[] nArray, Fold fold2) {
        int n;
        int n2 = 0;
        int n3 = nArray.length - 1;
        for (n = 1; n < n3; ++n) {
            int n4 = nArray[n] + n2;
            this.removeFoldFromHierarchy(fold, n4, fold2);
            n2 += n4;
        }
        n = nArray[n3] + n2;
        if (nArray[0] == 0) {
            ++n;
        } else {
            this.removeFoldFromHierarchy(fold, n, fold2);
        }
        return n;
    }

    private void removeFoldFromHierarchy(Fold fold, int n, Fold fold2) {
        Fold fold3 = ApiPackageAccessor.get().foldReplaceByChildren(fold, n);
        this.updateAffectedOffsets(fold3);
        this.markFoldRemovedFromHierarchy(fold3);
        this.unblockBlocked(fold3);
        if (fold2 != null) {
            this.execution.markBlocked(fold3, fold2);
        }
    }

    private void unblockBlocked(Fold fold) {
        Set set = this.execution.unmarkBlock(fold);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Fold fold2 = (Fold)iterator.next();
                int n = this.getOperation(fold2).getPriority();
                while (this.unblockedFoldLists.size() <= n) {
                    this.unblockedFoldLists.add(new ArrayList(4));
                }
                ((List)this.unblockedFoldLists.get(n)).add(fold2);
                if (n <= this.unblockedFoldMaxPriority) continue;
                this.unblockedFoldMaxPriority = n;
            }
        }
    }

    private void processUnblocked() {
        if (this.unblockedFoldMaxPriority >= 0) {
            for (int i = this.unblockedFoldMaxPriority; i >= 0; --i) {
                List list = (List)this.unblockedFoldLists.get(i);
                Fold fold = this.execution.getRootFold();
                for (int j = list.size() - 1; j >= 0; --j) {
                    Fold fold2 = (Fold)list.remove(j);
                    if (this.execution.isAddedOrBlocked(fold2)) continue;
                    this.unblockedFoldMaxPriority = -1;
                    this.addFold(fold2, fold, 0);
                    if (this.unblockedFoldMaxPriority >= i) {
                        throw new IllegalStateException("Folds removed with priority=" + this.unblockedFoldMaxPriority);
                    }
                    if (list.size() == j) continue;
                    throw new IllegalStateException("Same priority folds removed");
                }
            }
        }
        this.unblockedFoldMaxPriority = -1;
    }

    private void markFoldAddedToHierarchy(Fold fold) {
        if (this.removedFromHierarchySet == null || !this.removedFromHierarchySet.remove(fold)) {
            if (this.addedToHierarchySet == null) {
                this.addedToHierarchySet = new HashSet();
            }
            this.addedToHierarchySet.add(fold);
        }
    }

    private void markFoldRemovedFromHierarchy(Fold fold) {
        if (this.addedToHierarchySet == null || !this.addedToHierarchySet.remove(fold)) {
            if (this.removedFromHierarchySet == null) {
                this.removedFromHierarchySet = new HashSet();
            }
            this.removedFromHierarchySet.add(fold);
        }
    }

    private void updateAffectedOffsets(Fold fold) {
        this.updateAffectedStartOffset(fold.getStartOffset());
        this.updateAffectedEndOffset(fold.getEndOffset());
    }

    private void updateAffectedStartOffset(int n) {
        if (n < this.affectedStartOffset) {
            this.affectedStartOffset = n;
        }
    }

    private void updateAffectedEndOffset(int n) {
        if (n > this.affectedEndOffset) {
            this.affectedEndOffset = n;
        }
    }

    private void checkNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("FoldHierarchyChange already committed.");
        }
    }

    static {
        $assertionsDisabled = !FoldHierarchyTransactionImpl.class.desiredAssertionStatus();
        LOG = Logger.getLogger(FoldHierarchyTransactionImpl.class.getName());
        debug = Boolean.getBoolean("netbeans.debug.editor.fold");
        EMPTY_FOLDS = new Fold[0];
        EMPTY_FOLD_STATE_CHANGES = new FoldStateChange[0];
        EMPTY_INT_ARRAY = new int[0];
    }
}

