/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyTransactionImpl;
import org.netbeans.modules.editor.fold.FoldManagerFactoryProvider;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public final class FoldHierarchyExecution
implements DocumentListener {
    private static final String PROPERTY_FOLD_HIERARCHY_MUTEX = "foldHierarchyMutex";
    private static final String PROPERTY_FOLDING_ENABLED = "code-folding-enable";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold");
    private static final boolean debugFire = Boolean.getBoolean("netbeans.debug.editor.fold.fire");
    private static final FoldOperationImpl[] EMPTY_FOLD_OPERTAION_IMPL_ARRAY = new FoldOperationImpl[0];
    private final JTextComponent component;
    private FoldHierarchy hierarchy;
    private Fold rootFold;
    private FoldOperationImpl[] operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
    private Map blocked2block = new HashMap(4);
    private Map block2blockedSet = new HashMap(4);
    private boolean inited;
    private AbstractDocument lastDocument;
    private PriorityMutex mutex;
    private final EventListenerList listenerList;
    private boolean foldingEnabled;
    private FoldHierarchyTransactionImpl activeTransaction;
    private PropertyChangeListener componentChangesListener;

    public static synchronized FoldHierarchy getOrCreateFoldHierarchy(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            throw new NullPointerException("component cannot be null");
        }
        FoldHierarchyExecution foldHierarchyExecution = (FoldHierarchyExecution)jTextComponent.getClientProperty(FoldHierarchyExecution.class);
        if (foldHierarchyExecution == null) {
            foldHierarchyExecution = new FoldHierarchyExecution(jTextComponent);
            foldHierarchyExecution.init();
            jTextComponent.putClientProperty(FoldHierarchyExecution.class, foldHierarchyExecution);
        }
        return foldHierarchyExecution.getHierarchy();
    }

    private FoldHierarchyExecution(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.listenerList = new EventListenerList();
    }

    private void init() {
        this.mutex = (PriorityMutex)this.component.getClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX);
        if (this.mutex == null) {
            this.mutex = new PriorityMutex();
            this.component.putClientProperty(PROPERTY_FOLD_HIERARCHY_MUTEX, this.mutex);
        }
        this.hierarchy = ApiPackageAccessor.get().createFoldHierarchy(this);
        Document document = this.component.getDocument();
        try {
            this.rootFold = ApiPackageAccessor.get().createFold(new FoldOperationImpl(this, null, Integer.MAX_VALUE), FoldHierarchy.ROOT_FOLD_TYPE, "root", false, document, 0, document.getEndPosition().getOffset(), 0, 0, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        this.foldingEnabled = this.getFoldingEnabledSetting();
        this.startComponentChangesListening();
        this.rebuild();
    }

    public final FoldHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public final void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public Fold getRootFold() {
        return this.rootFold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFoldHierarchyListener(FoldHierarchyListener foldHierarchyListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(FoldHierarchyListener.class, foldHierarchyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFoldHierarchyListener(FoldHierarchyListener foldHierarchyListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(FoldHierarchyListener.class, foldHierarchyListener);
        }
    }

    void fireFoldHierarchyListener(FoldHierarchyEvent foldHierarchyEvent) {
        if (debugFire) {
            System.err.println("Firing FoldHierarchyEvent:\n" + foldHierarchyEvent);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$org$netbeans$api$editor$fold$FoldHierarchyListener == null ? FoldHierarchyExecution.class$("org.netbeans.api.editor.fold.FoldHierarchyListener") : class$org$netbeans$api$editor$fold$FoldHierarchyListener)) continue;
            ((FoldHierarchyListener)objectArray[i + 1]).foldHierarchyChanged(foldHierarchyEvent);
        }
    }

    public boolean add(Fold fold, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        if (fold.getParent() != null || this.isBlocked(fold)) {
            throw new IllegalStateException("Fold already added: " + fold);
        }
        boolean bl = foldHierarchyTransactionImpl.addFold(fold);
        return bl;
    }

    public void remove(Fold fold, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        foldHierarchyTransactionImpl.removeFold(fold);
    }

    public boolean isAddedOrBlocked(Fold fold) {
        return fold.getParent() != null || this.isBlocked(fold);
    }

    public boolean isBlocked(Fold fold) {
        return this.getBlock(fold) != null;
    }

    Fold getBlock(Fold fold) {
        return this.blocked2block.size() > 0 ? (Fold)this.blocked2block.get(fold) : null;
    }

    void markBlocked(Fold fold, Fold fold2) {
        this.blocked2block.put(fold, fold2);
        HashSet<Fold> hashSet = (HashSet<Fold>)this.block2blockedSet.get(fold2);
        if (hashSet == null) {
            hashSet = new HashSet<Fold>();
            this.block2blockedSet.put(fold2, hashSet);
        }
        if (!hashSet.add(fold)) {
            throw new IllegalStateException("fold " + fold + " already blocked");
        }
    }

    Fold unmarkBlocked(Fold fold) {
        Fold fold2 = (Fold)this.blocked2block.remove(fold);
        if (fold2 == null) {
            throw new IllegalArgumentException("Not blocked: " + fold);
        }
        Set set = (Set)this.block2blockedSet.get(fold2);
        if (!set.remove(fold)) {
            throw new IllegalStateException("Not blocker for " + fold);
        }
        if (set.size() == 0) {
            this.block2blockedSet.remove(fold2);
        }
        return fold2;
    }

    Set unmarkBlock(Fold fold) {
        Set set = (Set)this.block2blockedSet.remove(fold);
        if (set != null) {
            int n = this.blocked2block.size();
            this.blocked2block.keySet().removeAll(set);
            if (n - this.blocked2block.size() != set.size()) {
                throw new IllegalStateException("Not all removed: " + set);
            }
        }
        return set;
    }

    public void collapse(Collection collection) {
        this.setCollapsed(collection, true);
    }

    public void expand(Collection collection) {
        this.setCollapsed(collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCollapsed(Collection collection, boolean bl) {
        FoldHierarchyTransactionImpl foldHierarchyTransactionImpl = this.openTransaction();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Fold fold = (Fold)iterator.next();
                foldHierarchyTransactionImpl.setCollapsed(fold, bl);
            }
        }
        finally {
            foldHierarchyTransactionImpl.commit();
        }
    }

    public FoldHierarchyTransactionImpl openTransaction() {
        if (this.activeTransaction != null) {
            throw new IllegalStateException("Active transaction already exists.");
        }
        this.activeTransaction = new FoldHierarchyTransactionImpl(this);
        return this.activeTransaction;
    }

    void clearActiveTransaction() {
        if (this.activeTransaction == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        this.activeTransaction = null;
    }

    void createAndFireFoldHierarchyEvent(Fold[] foldArray, Fold[] foldArray2, FoldStateChange[] foldStateChangeArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("affectedStartOffset=" + n + " < 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("affectedEndOffset=" + n2 + " < affectedStartOffset=" + n);
        }
        FoldHierarchyEvent foldHierarchyEvent = ApiPackageAccessor.get().createFoldHierarchyEvent(this.hierarchy, foldArray, foldArray2, foldStateChangeArray, n, n2);
        this.fireFoldHierarchyListener(foldHierarchyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        boolean bl;
        AbstractDocument abstractDocument;
        Document document;
        if (this.lastDocument != null) {
            DocumentUtilities.removeDocumentListener((Document)this.lastDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
            this.lastDocument = null;
        }
        if ((document = this.getComponent().getDocument()) instanceof AbstractDocument) {
            abstractDocument = (AbstractDocument)document;
            bl = false;
        } else {
            abstractDocument = null;
            bl = true;
        }
        if (!this.foldingEnabled) {
            bl = true;
        }
        if (abstractDocument != null) {
            abstractDocument.readLock();
            if (!bl) {
                this.lastDocument = abstractDocument;
                DocumentUtilities.addDocumentListener((Document)this.lastDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
            }
        }
        try {
            this.lock();
            try {
                this.rebuildManagers(bl);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            if (abstractDocument != null) {
                abstractDocument.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildManagers(boolean bl) {
        Fold[] foldArray;
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i].release();
        }
        this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
        FoldManagerFactoryProvider foldManagerFactoryProvider = !bl ? FoldManagerFactoryProvider.getDefault() : FoldManagerFactoryProvider.getEmpty();
        List list = foldManagerFactoryProvider.getFactoryList(this.getHierarchy());
        int n = list.size();
        if (debug) {
            System.err.println("FoldHierarchy rebuild(): FoldManager factory count=" + n);
        }
        int n2 = n - 1;
        boolean bl2 = false;
        try {
            this.operations = new FoldOperationImpl[n];
            for (int i = 0; i < n; ++i) {
                foldArray = (Fold[])list.get(i);
                FoldManager foldManager = foldArray.createFoldManager();
                this.operations[i] = new FoldOperationImpl(this, foldManager, n2);
                --n2;
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
            }
        }
        FoldHierarchyTransactionImpl foldHierarchyTransactionImpl = this.openTransaction();
        bl2 = false;
        try {
            foldArray = new Fold[this.blocked2block.size()];
            this.blocked2block.keySet().toArray(foldArray);
            foldHierarchyTransactionImpl.removeAllFolds(foldArray);
            for (int i = 0; i < n; ++i) {
                this.operations[i].initFolds(foldHierarchyTransactionImpl);
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.operations = EMPTY_FOLD_OPERTAION_IMPL_ARRAY;
            }
            foldHierarchyTransactionImpl.commit();
        }
    }

    private void startComponentChangesListening() {
        if (this.componentChangesListener == null) {
            this.componentChangesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("document".equals(string)) {
                        FoldHierarchyExecution.this.foldingEnabled = FoldHierarchyExecution.this.getFoldingEnabledSetting();
                        FoldHierarchyExecution.this.rebuild();
                    } else if (FoldHierarchyExecution.PROPERTY_FOLDING_ENABLED.equals(string)) {
                        FoldHierarchyExecution.this.foldingEnabledSettingChange();
                    }
                }
            };
            this.getComponent().addPropertyChangeListener(this.componentChangesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent documentEvent) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl foldHierarchyTransactionImpl = this.openTransaction();
            try {
                foldHierarchyTransactionImpl.insertUpdate(documentEvent);
                int n = this.operations.length;
                for (int i = 0; i < n; ++i) {
                    this.operations[i].insertUpdate(documentEvent, foldHierarchyTransactionImpl);
                }
            }
            finally {
                foldHierarchyTransactionImpl.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent documentEvent) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl foldHierarchyTransactionImpl = this.openTransaction();
            try {
                foldHierarchyTransactionImpl.removeUpdate(documentEvent);
                int n = this.operations.length;
                for (int i = 0; i < n; ++i) {
                    this.operations[i].removeUpdate(documentEvent, foldHierarchyTransactionImpl);
                }
            }
            finally {
                foldHierarchyTransactionImpl.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent documentEvent) {
        this.lock();
        try {
            FoldHierarchyTransactionImpl foldHierarchyTransactionImpl = this.openTransaction();
            try {
                foldHierarchyTransactionImpl.changedUpdate(documentEvent);
                int n = this.operations.length;
                for (int i = 0; i < n; ++i) {
                    this.operations[i].changedUpdate(documentEvent, foldHierarchyTransactionImpl);
                }
            }
            finally {
                foldHierarchyTransactionImpl.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean getFoldingEnabledSetting() {
        Boolean bl = (Boolean)this.component.getClientProperty(PROPERTY_FOLDING_ENABLED);
        return bl != null ? bl : true;
    }

    public void foldingEnabledSettingChange() {
        boolean bl = this.foldingEnabled;
        this.foldingEnabled = this.getFoldingEnabledSetting();
        if (bl != this.foldingEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FoldHierarchyExecution.this.rebuild();
                }
            });
        }
    }

    public void checkConsistency() {
        try {
            FoldHierarchyExecution.checkFoldConsistency(this.getRootFold());
        }
        catch (RuntimeException runtimeException) {
            System.err.println("FOLD HIERARCHY INCONSISTENCY FOUND\n" + this);
            throw runtimeException;
        }
    }

    private static void checkFoldConsistency(Fold fold) {
        int n = fold.getStartOffset();
        int n2 = fold.getEndOffset();
        int n3 = n;
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            Fold fold2 = fold.getFold(i);
            if (fold2.getParent() != fold) {
                throw new IllegalStateException("Wrong parent of child=" + fold2 + ": " + fold2.getParent() + " != " + fold);
            }
            int n4 = fold.getFoldIndex(fold2);
            if (n4 != i) {
                throw new IllegalStateException("Fold index " + n4 + " instead of " + i);
            }
            int n5 = fold2.getStartOffset();
            int n6 = fold2.getEndOffset();
            if (n5 < n3) {
                throw new IllegalStateException("childStartOffset=" + n5 + " < lastEndOffset=" + n3);
            }
            if (n5 > n6) {
                throw new IllegalStateException("childStartOffset=" + n5 + " > childEndOffset=" + n6);
            }
            n3 = n6;
            FoldHierarchyExecution.checkFoldConsistency(fold2);
        }
    }

    public String toString() {
        int n;
        Map.Entry entry;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("component=");
        stringBuffer.append(System.identityHashCode(this.getComponent()));
        stringBuffer.append('\n');
        stringBuffer.append(FoldUtilitiesImpl.foldToStringChildren(this.hierarchy.getRootFold(), 0));
        stringBuffer.append('\n');
        if (this.blocked2block != null) {
            stringBuffer.append("BLOCKED\n");
            iterator = this.blocked2block.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                stringBuffer.append("    ");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(" blocked-by ");
                stringBuffer.append(entry.getValue());
                stringBuffer.append('\n');
            }
        }
        if (this.block2blockedSet != null) {
            stringBuffer.append("BLOCKERS\n");
            iterator = this.block2blockedSet.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                stringBuffer.append("    ");
                stringBuffer.append(entry.getKey());
                stringBuffer.append('\n');
                Set set = (Set)entry.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("        blocks ");
                    stringBuffer.append(iterator2.next());
                    stringBuffer.append('\n');
                }
            }
        }
        if ((n = this.operations.length) > 0) {
            stringBuffer.append("Fold Managers\n");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("FOLD MANAGER [");
                stringBuffer.append(i);
                stringBuffer.append("]:\n");
                stringBuffer.append(this.operations[i].getManager());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static {
        FoldOperation.isBoundsValid(0, 0, 0, 0);
    }
}

