/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.samples;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.IReportConnectionFactory;
import com.jaspersoft.ireport.samples.db.SampleDatabaseConnection;
import com.jaspersoft.ireport.samples.db.SampleDatabaseConnectionFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbPreferences;

public class Installer
extends ModuleInstall {
    public void restored() {
        List classpath = IReportManager.getInstance().getClasspath();
        File libDir = InstalledFileLocator.getDefault().locate("modules/ext", null, false);
        if (libDir != null && libDir.isDirectory()) {
            File[] jars = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("hsqldb-") && name.toLowerCase().endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                if (classpath.contains(jars[i].getPath())) continue;
                classpath.add(jars[i].getPath());
            }
            IReportManager.getInstance().setClasspath(classpath);
        }
        IReportManager.getInstance().addConnectionImplementationFactory((IReportConnectionFactory)new SampleDatabaseConnectionFactory());
        if (!NbPreferences.forModule(Installer.class).getBoolean("samples.testConnectionCreated", false)) {
            SampleDatabaseConnection connection = new SampleDatabaseConnection();
            IReportManager.getInstance().addConnection((IReportConnection)connection);
            NbPreferences.forModule(Installer.class).putBoolean("samples.testConnectionCreated", true);
        }
    }
}

