/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguageImpl;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLanguageProvider
extends LanguageProvider {
    private static Map<String, org.netbeans.api.lexer.Language<STokenId>> preprocessorImport = new HashMap<String, org.netbeans.api.lexer.Language<STokenId>>();
    private static Map<String, Map<String, org.netbeans.api.lexer.Language<STokenId>>> tokenImports = new HashMap<String, Map<String, org.netbeans.api.lexer.Language<STokenId>>>();
    private static Map<SLanguageProvider, SLanguageProvider> providers = new WeakHashMap<SLanguageProvider, SLanguageProvider>();

    public SLanguageProvider() {
        providers.put(this, null);
    }

    public org.netbeans.api.lexer.Language<STokenId> findLanguage(String string) {
        if (LanguagesManager.getDefault().isSupported(string)) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(string);
                if (language instanceof LanguageImpl) {
                    new Listener((LanguageImpl)language);
                }
                if (language.getParser() == null) {
                    return null;
                }
                return new SLanguageHierarchy(language).language();
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public LanguageEmbedding<?> findLanguageEmbedding(Token token, LanguagePath languagePath, InputAttributes inputAttributes) {
        String string = languagePath.innerLanguage().mimeType();
        if (!LanguagesManager.getDefault().isSupported(string)) {
            return null;
        }
        org.netbeans.api.lexer.Language<STokenId> language = SLanguageProvider.getTokenImport(string, token);
        if (language == null) {
            language = SLanguageProvider.getPreprocessorImport(languagePath, token);
        }
        if (language == null) {
            return null;
        }
        Integer n = (Integer)token.getProperty((Object)"startSkipLength");
        int n2 = n == null ? 0 : n;
        n = (Integer)token.getProperty((Object)"endSkipLength");
        int n3 = n == null ? 0 : n;
        return LanguageEmbedding.create(language, (int)n2, (int)n3);
    }

    private static org.netbeans.api.lexer.Language<STokenId> getPreprocessorImport(LanguagePath languagePath, Token token) {
        String string = token.id().name();
        if (!string.equals("PE")) {
            return null;
        }
        String string2 = languagePath.topLanguage().mimeType();
        if (!preprocessorImport.containsKey(string2)) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(string2);
                Feature feature = language.getPreprocessorImport();
                if (feature != null) {
                    String string3 = (String)feature.getValue("mimeType");
                    preprocessorImport.put(string2, (org.netbeans.api.lexer.Language<STokenId>)org.netbeans.api.lexer.Language.find((String)string3));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return preprocessorImport.get(string2);
    }

    private static org.netbeans.api.lexer.Language<STokenId> getTokenImport(String string, Token token) {
        String string2 = token.id().name();
        Map<String, org.netbeans.api.lexer.Language<STokenId>> map = tokenImports.get(string);
        if (map == null) {
            map = new HashMap<String, org.netbeans.api.lexer.Language<STokenId>>();
            tokenImports.put(string, map);
            try {
                Language language = LanguagesManager.getDefault().getLanguage(string);
                Map<String, Feature> map2 = language.getTokenImports();
                if (map2 != null) {
                    for (String string3 : map2.keySet()) {
                        Feature feature = map2.get(string3);
                        String string4 = (String)feature.getValue("mimeType");
                        map.put(string3, (org.netbeans.api.lexer.Language<STokenId>)org.netbeans.api.lexer.Language.find((String)string4));
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return map.get(string2);
    }

    static void refresh() {
        for (SLanguageProvider sLanguageProvider : providers.keySet()) {
            sLanguageProvider.firePropertyChange("LanguageProvider.PROP_LANGUAGE");
            sLanguageProvider.firePropertyChange("LanguageProvider.PROP_EMBEDDED_LANGUAGE");
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private LanguageImpl language;

        Listener(LanguageImpl languageImpl) {
            this.language = languageImpl;
            languageImpl.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SLanguageProvider.refresh();
        }
    }
}

