/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.render.AbstractOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.swing.AWTFSFont;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.SwingReplacedElement;

public class Java2DOutputDevice
extends AbstractOutputDevice
implements OutputDevice {
    private Graphics2D _graphics;

    public Java2DOutputDevice(Graphics2D graphics) {
        this._graphics = graphics;
    }

    public Java2DOutputDevice(BufferedImage outputImage) {
        this(outputImage.createGraphics());
    }

    public void drawBorderLine(Rectangle bounds, int side, int lineWidth, boolean solid) {
        int adj;
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        int n = adj = solid ? 1 : 0;
        if (side == 1) {
            this.drawLine(x, y + lineWidth / 2, x + w - adj, y + lineWidth / 2);
        } else if (side == 2) {
            this.drawLine(x + lineWidth / 2, y, x + lineWidth / 2, y + h - adj);
        } else if (side == 8) {
            int offset = lineWidth / 2;
            if (lineWidth % 2 == 1) {
                ++offset;
            }
            this.drawLine(x + w - offset, y, x + w - offset, y + h - adj);
        } else if (side == 4) {
            int offset = lineWidth / 2;
            if (lineWidth % 2 == 1) {
                ++offset;
            }
            this.drawLine(x, y + h - offset, x + w - adj, y + h - offset);
        }
    }

    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        ReplacedElement replaced = box.getReplacedElement();
        if (replaced instanceof SwingReplacedElement) {
            Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c);
            this.translate(contentBounds.x, contentBounds.y);
            JComponent component = ((SwingReplacedElement)box.getReplacedElement()).getJComponent();
            component.paint(this._graphics);
            this.translate(-contentBounds.x, -contentBounds.y);
        } else if (replaced instanceof ImageReplacedElement) {
            Image image = ((ImageReplacedElement)replaced).getImage();
            Point location = replaced.getLocation();
            this._graphics.drawImage(image, (int)location.getX(), (int)location.getY(), null);
        }
    }

    public void setColor(Color color) {
        this._graphics.setColor(color);
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this._graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this._graphics.fillRect(x, y, width, height);
    }

    public void setClip(Shape s) {
        this._graphics.setClip(s);
    }

    public Shape getClip() {
        return this._graphics.getClip();
    }

    public void clip(Shape s) {
        this._graphics.clip(s);
    }

    public void translate(double tx, double ty) {
        this._graphics.translate(tx, ty);
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public void drawOval(int x, int y, int width, int height) {
        this._graphics.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this._graphics.fillOval(x, y, width, height);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this._graphics.getRenderingHint(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        this._graphics.setRenderingHint(key, value);
    }

    public void setFont(FSFont font) {
        this._graphics.setFont(((AWTFSFont)font).getAWTFont());
    }

    public void setStroke(Stroke s) {
        this._graphics.setStroke(s);
    }

    public Stroke getStroke() {
        return this._graphics.getStroke();
    }

    public void fill(Shape s) {
        this._graphics.fill(s);
    }

    public void drawImage(FSImage image, int x, int y) {
        this._graphics.drawImage(((AWTFSImage)image).getImage(), x, y, null);
    }
}

