/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.openide.text.NbDocument;

public final class PositionBounds {
    private Position begin;
    private Position end;
    private final GuardedSectionsImpl guards;

    public PositionBounds(Position position, Position position2, GuardedSectionsImpl guardedSectionsImpl) {
        this.begin = position;
        this.end = position2;
        this.guards = guardedSectionsImpl;
        this.assertPositionBounds();
    }

    public static PositionBounds create(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(styledDocument.createPosition(n), styledDocument.createPosition(n2), guardedSectionsImpl);
    }

    public static PositionBounds createBodyBounds(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(new BiasedPosition(styledDocument.createPosition(n - 1), Position.Bias.Backward), new BiasedPosition(styledDocument.createPosition(n2 + 1), Position.Bias.Forward), guardedSectionsImpl);
    }

    public static PositionBounds createUnresolved(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(new UnresolvedPosition(n), new UnresolvedPosition(n2), guardedSectionsImpl);
    }

    public static PositionBounds createBodyUnresolved(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        return new PositionBounds(new BiasedPosition(new UnresolvedPosition(n - 1), Position.Bias.Backward), new BiasedPosition(new UnresolvedPosition(n2 + 1), Position.Bias.Forward), guardedSectionsImpl);
    }

    public void resolvePositions() throws BadLocationException {
        StyledDocument styledDocument = this.guards.getDocument();
        if (this.begin instanceof UnresolvedPosition) {
            this.begin = styledDocument.createPosition(this.begin.getOffset());
        } else if (this.begin instanceof BiasedPosition) {
            ((BiasedPosition)this.begin).resolve(styledDocument);
        }
        if (this.end instanceof UnresolvedPosition) {
            this.end = styledDocument.createPosition(this.end.getOffset());
        } else if (this.end instanceof BiasedPosition) {
            ((BiasedPosition)this.end).resolve(styledDocument);
        }
        this.assertPositionBounds();
    }

    public Position getBegin() {
        return this.begin;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setText(final String string) throws BadLocationException {
        final StyledDocument styledDocument = this.guards.getDocument();
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[]{null};
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    int n = PositionBounds.this.begin.getOffset();
                    int n2 = PositionBounds.this.end.getOffset();
                    int n3 = string.length();
                    if (n3 == 0) {
                        if (n2 > n) {
                            styledDocument.remove(n, n2 - n);
                        }
                    } else {
                        int n4 = styledDocument.getLength();
                        if (n2 - n >= 1) {
                            styledDocument.insertString(n + 1, string, null);
                            n3 = styledDocument.getLength() - n4;
                            styledDocument.remove(n + 1 + n3, n2 - n - 1);
                            styledDocument.remove(n, 1);
                        } else {
                            styledDocument.insertString(n, string, null);
                            n3 = styledDocument.getLength() - n4;
                            if (n2 > n) {
                                styledDocument.remove(n + n3, n2 - n);
                            }
                            if (PositionBounds.this.begin.getOffset() != n) {
                                PositionBounds.this.begin = styledDocument.createPosition(n);
                            }
                            if (PositionBounds.this.end.getOffset() - n != n3) {
                                PositionBounds.this.end = styledDocument.createPosition(n + n3);
                            }
                            PositionBounds.this.assertPositionBounds();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    public String getText() throws BadLocationException {
        int n;
        StyledDocument styledDocument = this.guards.getDocument();
        int n2 = this.begin.getOffset();
        return n2 <= (n = this.end.getOffset()) ? styledDocument.getText(n2, n - n2) : "";
    }

    private void assertPositionBounds() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Position bounds[");
        try {
            String string = this.getText();
            stringBuilder.append(this.begin);
            stringBuilder.append(",");
            stringBuilder.append(this.end);
            stringBuilder.append(",\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        catch (BadLocationException badLocationException) {
            stringBuilder.append("Invalid: ");
            stringBuilder.append(badLocationException.getMessage());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static final class BiasedPosition
    implements Position {
        private Position delegate;
        private Position.Bias bias;

        public BiasedPosition(Position position, Position.Bias bias) {
            this.delegate = position;
            this.bias = bias;
        }

        public int getOffset() {
            return this.bias == Position.Bias.Backward ? this.delegate.getOffset() + 1 : this.delegate.getOffset() - 1;
        }

        void resolve(StyledDocument styledDocument) throws BadLocationException {
            if (this.delegate instanceof UnresolvedPosition) {
                this.delegate = styledDocument.createPosition(this.delegate.getOffset());
            }
        }
    }

    private static final class UnresolvedPosition
    implements Position {
        private int offset;

        public UnresolvedPosition(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

